/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.globusonlinetool.myswingutils;

import com.sshtools.common.globusonlinetool.GOHelper;
import com.sshtools.common.globusonlinetool.myswingutils.JTreeNodeDynamic;
import com.sshtools.common.globusonlinetool.myswingutils.TransferableTreeNode;
import com.sshtools.common.ui.ResourceIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DragDropTree
extends JTree
implements Autoscroll,
ActionListener {
    private Insets insets;
    private int top = 0;
    private int bottom = 0;
    private int topRow = 0;
    private int bottomRow = 0;
    private JPopupMenu popupMenu;
    private DefaultTreeModel treeModel;
    private ImageIcon toRefreshIcon;
    static final String ICON = "/com/sshtools/common/globusonlinetool/largego.png";

    public DragDropTree() {
        this.setModel(this.treeModel);
        this.setShowsRootHandles(true);
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(1);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, new TreeDragGestureListener());
        DropTarget dropTarget = new DropTarget(this, new TreeDropTargetListener());
        final DragDropTree thisTree = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    TreePath tp = thisTree.getClosestPathForLocation(evt.getX(), evt.getY());
                    if (thisTree.getSelectionPath() != null && tp.equals(thisTree.getSelectionPath())) {
                        if (evt.getButton() != 1) {
                            if (evt.getButton() == 3) {
                                JMenuItem item;
                                JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)tp.getLastPathComponent();
                                DragDropTree.this.popupMenu = new JPopupMenu();
                                if (!node.isUncertain()) {
                                    if (node.getParent() != null) {
                                        item = new JMenuItem("Delete");
                                        item.setActionCommand("delete");
                                        item.addActionListener(thisTree);
                                        DragDropTree.this.popupMenu.add(item);
                                    }
                                    if (!node.isLeaf()) {
                                        item = new JMenuItem("New Directory");
                                        item.setActionCommand("newDir");
                                        item.addActionListener(thisTree);
                                        DragDropTree.this.popupMenu.add(item);
                                    }
                                    if (node.getParent() != null) {
                                        item = new JMenuItem("Show details");
                                        item.setActionCommand("show");
                                        item.addActionListener(thisTree);
                                        DragDropTree.this.popupMenu.add(item);
                                    }
                                }
                                if (node.getParent() != null) {
                                    item = new JMenuItem("Refresh");
                                    item.setActionCommand("refresh");
                                    item.addActionListener(thisTree);
                                    DragDropTree.this.popupMenu.add(item);
                                }
                                DragDropTree.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.toRefreshIcon = DragDropTree.createImageIcon("../refresh.png");
        if (this.toRefreshIcon != null) {
            this.setCellRenderer(new MyRenderer(this.toRefreshIcon));
        }
    }

    public DragDropTree(DefaultTreeModel model) {
        this();
        this.setModel(model);
        this.treeModel = model;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = DragDropTree.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        TreePath tp = this.getSelectionPath();
        if (evt.getActionCommand().equals("delete")) {
            if (tp.getLastPathComponent() instanceof JTreeNodeDynamic.MyTreeNode) {
                JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)tp.getLastPathComponent();
                String file = node.getFullPath();
                String endpoint = node.getEndpoint();
                int reply = node.isLeaf() ? JOptionPane.showConfirmDialog(null, "Do you want to delete the file \n" + endpoint + ":" + file + " ?", "Delete Confirmation", 0, 3, new ResourceIcon(this.getClass(), ICON)) : JOptionPane.showConfirmDialog(null, "Do you want to delete the directory \n" + endpoint + ":" + file + "\n and all the files/directories in it recursively?", "Delete Confirmation", 0, 3, new ResourceIcon(this.getClass(), ICON));
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (reply == 0) {
                    int status = GOHelper.deleteFiles(endpoint, file);
                    if (status == GOHelper.SUCCESS) {
                        JTreeNodeDynamic.MyTreeNode parentNode = (JTreeNodeDynamic.MyTreeNode)node.getParent();
                        parentNode.setLoaded(false);
                        parentNode.loadChildren((DefaultTreeModel)this.getModel(), parentNode.getEndpoint(), parentNode.getFullPath());
                    } else if (status == GOHelper.IN_PROGRESS) {
                        node.setUncertain(true);
                    } else if (status == GOHelper.FAIL) {
                        JOptionPane.showMessageDialog(null, "Cannot delete file/directory.\n" + endpoint + ":" + file, "Error: Delete file/directory", 0);
                    }
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (evt.getActionCommand().equals("refresh")) {
            if (tp.getLastPathComponent() instanceof JTreeNodeDynamic.MyTreeNode) {
                JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)tp.getLastPathComponent();
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (node.isUncertain() || node.isLeaf()) {
                    JTreeNodeDynamic.MyTreeNode parentNode = (JTreeNodeDynamic.MyTreeNode)node.getParent();
                    parentNode.setLoaded(false);
                    parentNode.loadChildren((DefaultTreeModel)this.getModel(), parentNode.getEndpoint(), parentNode.getFullPath());
                } else {
                    node.setLoaded(false);
                    node.loadChildren((DefaultTreeModel)this.getModel(), node.getEndpoint(), node.getFullPath());
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (evt.getActionCommand().equals("show")) {
            if (tp.getLastPathComponent() instanceof JTreeNodeDynamic.MyTreeNode) {
                JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)tp.getLastPathComponent();
                Map details = node.getNodeFileDetails();
                String fileSize = GOHelper.humanReadableByteCount(Long.valueOf(details.get("size") + ""), true);
                JOptionPane.showMessageDialog(null, "Endpoint: " + node.getEndpoint() + "\n" + "File: " + node.getFullPath() + "\n" + "\t\tUser: " + details.get("user") + "\n" + "\t\tGroup: " + details.get("group") + "\n" + "\t\tSize: " + fileSize + " or " + details.get("size") + " B\n" + "\t\tPermissions: " + details.get("permissions") + "\n" + "\t\tLast Modified: " + GOHelper.formatDateTime(details.get("last_modified") + ""), "File Information:", 1, new ResourceIcon(this.getClass(), ICON));
            }
        } else if (evt.getActionCommand().equals("newDir") && tp.getLastPathComponent() instanceof JTreeNodeDynamic.MyTreeNode) {
            JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)tp.getLastPathComponent();
            if (!node.isLeaf()) {
                String directory = GOHelper.createMkDirDialog();
                if (!directory.equals("") && GOHelper.mkEndpointDir(node.getEndpoint(), node.getFullPath() + "/" + directory)) {
                    node.setLoaded(false);
                    node.loadChildren((DefaultTreeModel)this.getModel(), node.getEndpoint(), node.getFullPath());
                }
            } else {
                JOptionPane.showMessageDialog(null, "Cannot create directory in a file!", "Error: Create New Directory", 0);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width = Math.max(400, preferredSize.width);
        preferredSize.height = Math.max(500, preferredSize.height);
        return preferredSize;
    }

    @Override
    public Insets getAutoscrollInsets() {
        return this.insets;
    }

    @Override
    public void autoscroll(Point p) {
        this.top = Math.abs(this.getLocation().y) + 10;
        this.bottom = this.top + this.getParent().getHeight() - 20;
        if (p.y < this.top) {
            int next = this.topRow--;
            ++this.bottomRow;
            this.scrollRowToVisible(next);
        } else if (p.y > this.bottom) {
            int next = this.bottomRow++;
            --this.topRow;
            this.scrollRowToVisible(next);
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(DefaultTreeModel treeModel) {
        this.treeModel = treeModel;
    }

    private static class MyDragSourceListener
    implements DragSourceListener {
        private MyDragSourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            int dropAction;
            if (dragSourceDropEvent.getDropSuccess() && (dropAction = dragSourceDropEvent.getDropAction()) == 2) {
                System.out.println("MOVE: remove node");
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext context = dragSourceDragEvent.getDragSourceContext();
            int dropAction = dragSourceDragEvent.getDropAction();
            if ((dropAction & 1) != 0) {
                context.setCursor(DragSource.DefaultCopyDrop);
            } else if ((dropAction & 2) != 0) {
                context.setCursor(DragSource.DefaultMoveDrop);
            } else {
                context.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    private class TreeDropTargetListener
    implements DropTargetListener {
        private int highlightedRow = -1;
        private Rectangle dirtyRegion = null;
        private Color highlightColor = new Color(Color.BLUE.getRed(), Color.BLUE.getGreen(), Color.BLUE.getBlue(), 100);

        private TreeDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DragDropTree.this.top = Math.abs(DragDropTree.this.getLocation().y);
            DragDropTree.this.bottom = DragDropTree.this.top + DragDropTree.this.getParent().getHeight();
            DragDropTree.this.topRow = DragDropTree.this.getClosestRowForLocation(0, DragDropTree.this.top);
            DragDropTree.this.bottomRow = DragDropTree.this.getClosestRowForLocation(0, DragDropTree.this.bottom);
            DragDropTree.this.insets = new Insets(DragDropTree.this.top + 10, 0, DragDropTree.this.bottom - 10, DragDropTree.this.getWidth());
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (null != this.dirtyRegion) {
                DragDropTree.this.paintImmediately(this.dirtyRegion);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            int closestRow;
            JTree tree;
            block9: {
                tree = (JTree)dropTargetDragEvent.getDropTargetContext().getComponent();
                closestRow = -1;
                Point location = dropTargetDragEvent.getLocation();
                TreePath path = DragDropTree.this.getPathForLocation(location.x, location.y);
                try {
                    DefaultMutableTreeNode selection = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (selection != null && selection.isLeaf()) {
                        closestRow = tree.getRowForPath(path.getParentPath());
                    } else if (path != null && !path.toString().trim().equals("null")) {
                        closestRow = tree.getClosestRowForLocation((int)location.getX(), (int)location.getY());
                    }
                }
                catch (NullPointerException e) {
                    if (path == null || path.toString().trim().equals("null")) break block9;
                    closestRow = tree.getClosestRowForLocation((int)location.getX(), (int)location.getY());
                }
            }
            boolean highlighted = false;
            Graphics g = DragDropTree.this.getGraphics();
            if (closestRow != -1 && this.highlightedRow != closestRow) {
                if (null != this.dirtyRegion) {
                    DragDropTree.this.paintImmediately(this.dirtyRegion);
                }
                for (int j = 0; j < tree.getRowCount(); ++j) {
                    Rectangle firstRowRect;
                    if (closestRow != j) continue;
                    this.dirtyRegion = firstRowRect = DragDropTree.this.getRowBounds(closestRow);
                    g.setColor(this.highlightColor);
                    g.fillRect((int)this.dirtyRegion.getX(), (int)this.dirtyRegion.getY(), (int)this.dirtyRegion.getWidth(), (int)this.dirtyRegion.getHeight());
                    this.highlightedRow = closestRow;
                }
            }
            if (closestRow == -1 && null != this.dirtyRegion) {
                DragDropTree.this.paintImmediately(this.dirtyRegion);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
            block8: {
                try {
                    Point dropLocation = dropTargetDropEvent.getLocation();
                    TreePath dropPath = DragDropTree.this.getPathForLocation(dropLocation.x, dropLocation.y);
                    Object destinationNode = dropPath.getLastPathComponent();
                    if (((TreeNode)destinationNode).isLeaf()) {
                        dropPath = dropPath.getParentPath();
                        destinationNode = dropPath.getLastPathComponent();
                    }
                    if (destinationNode != null && destinationNode instanceof TreeNode && !((TreeNode)destinationNode).isLeaf()) {
                        try {
                            Transferable tr = dropTargetDropEvent.getTransferable();
                            if (tr.isDataFlavorSupported(TransferableTreeNode.DEFAULT_MUTABLE_TREENODE_FLAVOR)) {
                                dropTargetDropEvent.acceptDrop(3);
                                JTreeNodeDynamic.MyTreeNode sourceTreeNode = (JTreeNodeDynamic.MyTreeNode)tr.getTransferData(TransferableTreeNode.DEFAULT_MUTABLE_TREENODE_FLAVOR);
                                dropTargetDropEvent.getDropTargetContext().getComponent().setCursor(Cursor.getPredefinedCursor(3));
                                this.addElement(dropPath, sourceTreeNode, dropTargetDropEvent.getDropTargetContext().getComponent());
                                dropTargetDropEvent.getDropTargetContext().getComponent().setCursor(Cursor.getDefaultCursor());
                                dropTargetDropEvent.dropComplete(true);
                                break block8;
                            }
                            System.out.println("Rejected");
                            dropTargetDropEvent.rejectDrop();
                        }
                        catch (IOException io) {
                            io.printStackTrace();
                            dropTargetDropEvent.rejectDrop();
                        }
                        catch (UnsupportedFlavorException ufe) {
                            ufe.printStackTrace();
                            dropTargetDropEvent.rejectDrop();
                        }
                        break block8;
                    }
                    dropTargetDropEvent.rejectDrop();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }

        private void addElement(TreePath path, Object element, Component component) {
            JTreeNodeDynamic.MyTreeNode destinationNode = (JTreeNodeDynamic.MyTreeNode)path.getLastPathComponent();
            JTreeNodeDynamic.MyTreeNode sourceNode = (JTreeNodeDynamic.MyTreeNode)element;
            String destPath = destinationNode.getFullPath() + "/" + this.nodePathChecker(sourceNode.getNodeName());
            int reply = JOptionPane.showConfirmDialog(null, "Are you show you want to transfer files/directories from \n" + sourceNode.getEndpoint() + ":" + sourceNode.getFullPath() + "\nto\n" + destinationNode.getEndpoint() + ":" + destPath + " ?", "Transfer Confirmation", 0, 3, new ResourceIcon(this.getClass(), DragDropTree.ICON));
            if (reply == 0) {
                int status = GOHelper.transferFiles(sourceNode.getEndpoint(), destinationNode.getEndpoint(), sourceNode.getFullPath(), destPath, !sourceNode.isLeaf());
                if (status == GOHelper.SUCCESS) {
                    destinationNode.setLoaded(false);
                    destinationNode.loadChildren((DefaultTreeModel)DragDropTree.this.getModel(), destinationNode.getEndpoint(), destinationNode.getFullPath());
                } else if (status == GOHelper.IN_PROGRESS) {
                    sourceNode.setUncertain(true);
                    DefaultTreeModel model = (DefaultTreeModel)DragDropTree.this.getModel();
                    model.insertNodeInto(sourceNode, destinationNode, destinationNode.getChildCount());
                } else if (status == GOHelper.FAIL) {
                    JOptionPane.showMessageDialog(null, "Cannot transfer file/directory from\n" + sourceNode.getEndpoint() + ":" + sourceNode.getFullPath() + "\nto\n" + destinationNode.getEndpoint() + ":" + destinationNode.getFullPath(), "Error: transfer file/directory", 0);
                }
            }
        }

        private String nodePathChecker(String nodePath) {
            if (nodePath.contains("/")) {
                String[] temp = nodePath.split("/");
                nodePath = temp[temp.length - 1];
            }
            return nodePath;
        }
    }

    private static class TreeDragGestureListener
    implements DragGestureListener {
        private TreeDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JTree tree = (JTree)dragGestureEvent.getComponent();
            TreePath path = tree.getSelectionPath();
            JTreeNodeDynamic.MyTreeNode selectedNode = (JTreeNodeDynamic.MyTreeNode)path.getLastPathComponent();
            if (path == null || selectedNode.isUncertain()) {
                if (selectedNode.isUncertain()) {
                    JOptionPane.showMessageDialog(null, "You are not allowed to transfer \"work in progress\" file/directory. Please refresh the file/directory before trying again.", "Warning", 2, new ResourceIcon(this.getClass(), DragDropTree.ICON));
                }
            } else {
                DefaultMutableTreeNode selection = (DefaultMutableTreeNode)path.getLastPathComponent();
                TransferableTreeNode node = new TransferableTreeNode(selection);
                dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, node, new MyDragSourceListener());
            }
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        Icon toRefreshIcon;

        public MyRenderer(Icon icon) {
            this.toRefreshIcon = icon;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this.IsIncomplete(value)) {
                this.setIcon(this.toRefreshIcon);
                this.setToolTipText("Please refresh parent node to check if the task is completed.");
            } else {
                this.setToolTipText(null);
            }
            return this;
        }

        protected boolean IsIncomplete(Object value) {
            JTreeNodeDynamic.MyTreeNode node;
            return value != null && value instanceof JTreeNodeDynamic.MyTreeNode && (node = (JTreeNodeDynamic.MyTreeNode)value).isUncertain();
        }
    }
}

