/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.AboutAction;
import com.sshtools.common.ui.ChangelogAction;
import com.sshtools.common.ui.ExitAction;
import com.sshtools.common.ui.NewWindowAction;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshToolsApplicationInternalFrame
extends JInternalFrame
implements SshToolsApplicationContainer {
    public static final String PREF_LAST_FRAME_GEOMETRY = "application.lastFrameGeometry";
    protected Log log = LogFactory.getLog(SshToolsApplicationInternalFrame.class);
    protected StandardAction exitAction;
    protected StandardAction aboutAction;
    protected StandardAction changelogAction;
    protected StandardAction newWindowAction;
    protected JSeparator toolSeparator;
    private SshToolsApplicationPanel panel;
    private SshToolsApplication application;
    private boolean showAboutBox = true;
    private boolean showChangelogBox = true;
    private boolean showExitAction = true;
    private boolean showNewWindowAction = true;
    private boolean showMenu = true;

    public void showAboutBox(boolean showAboutBox) {
        this.showAboutBox = showAboutBox;
    }

    public void showChangelogBox(boolean showChangelogBox) {
        this.showChangelogBox = showChangelogBox;
    }

    public void showExitAction(boolean showExitAction) {
        this.showExitAction = showExitAction;
    }

    public void showNewWindowAction(boolean showNewWindowAction) {
        this.showNewWindowAction = showNewWindowAction;
    }

    @Override
    public void init(final SshToolsApplication application, SshToolsApplicationPanel panel) throws SshToolsApplicationException {
        this.panel = panel;
        this.application = application;
        if (application != null) {
            this.setTitle(ConfigurationLoader.getVersionString(application.getApplicationName(), application.getApplicationVersion()));
        }
        panel.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        if (this.showExitAction && application != null) {
            this.exitAction = new ExitAction(application, this);
            panel.registerAction(this.exitAction);
        }
        if (this.showNewWindowAction && application != null) {
            this.newWindowAction = new NewWindowAction(application);
            panel.registerAction(this.newWindowAction);
        }
        panel.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Help", "Help", 104, 99));
        if (this.showAboutBox && application != null) {
            this.aboutAction = new AboutAction(this, application);
            panel.registerAction(this.aboutAction);
        }
        if (this.showChangelogBox && application != null) {
            this.changelogAction = new ChangelogAction(this, application);
            panel.registerAction(this.changelogAction);
        }
        this.getApplicationPanel().rebuildActionComponents();
        JPanel p = new JPanel(new BorderLayout());
        if (panel.getJMenuBar() != null) {
            this.setJMenuBar(panel.getJMenuBar());
        }
        if (panel.getToolBar() != null) {
            JPanel t = new JPanel(new BorderLayout());
            t.add((Component)panel.getToolBar(), "North");
            this.toolSeparator = new JSeparator(0);
            t.add((Component)this.toolSeparator, "South");
            this.toolSeparator.setVisible(panel.getToolBar().isVisible());
            final SshToolsApplicationPanel pnl = panel;
            panel.getToolBar().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent evt) {
                    SshToolsApplicationInternalFrame.this.log.debug("Tool separator is now " + pnl.getToolBar().isVisible());
                    SshToolsApplicationInternalFrame.this.toolSeparator.setVisible(pnl.getToolBar().isVisible());
                }
            });
            p.add((Component)t, "North");
        }
        p.add((Component)panel, "Center");
        if (panel.getStatusBar() != null) {
            p.add((Component)panel.getStatusBar(), "South");
        }
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(p);
        this.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                int confirm;
                boolean changed;
                if (application != null) {
                    application.closeContainer(SshToolsApplicationInternalFrame.this);
                } else if (evt.getPropertyName().equals("closed") && (changed = ((Boolean)evt.getNewValue()).booleanValue()) && (confirm = JOptionPane.showOptionDialog(SshToolsApplicationInternalFrame.this, "Close " + SshToolsApplicationInternalFrame.this.getTitle() + "?", "Close Operation", 0, 3, null, null, null)) == 0) {
                    SshToolsApplicationInternalFrame.this.getDesktopPane().remove(SshToolsApplicationInternalFrame.this);
                }
            }
        });
        this.pack();
    }

    @Override
    public void setContainerTitle(String title) {
        this.setTitle(title);
    }

    public SshToolsApplication getApplication() {
        return this.application;
    }

    @Override
    public void setContainerVisible(boolean visible) {
        this.setVisible(visible);
    }

    @Override
    public boolean isContainerVisible() {
        return this.isVisible();
    }

    @Override
    public SshToolsApplicationPanel getApplicationPanel() {
        return this.panel;
    }

    @Override
    public void closeContainer() {
        if (this.application != null && this.application.getContainerCount() == 1) {
            PreferencesStore.putRectangle(PREF_LAST_FRAME_GEOMETRY, this.getBounds());
        }
        this.dispose();
        this.getApplicationPanel().deregisterAction(this.newWindowAction);
        this.getApplicationPanel().deregisterAction(this.exitAction);
        this.getApplicationPanel().deregisterAction(this.aboutAction);
        this.getApplicationPanel().deregisterAction(this.changelogAction);
        this.getApplicationPanel().rebuildActionComponents();
    }

    @Override
    public Component getWindow() {
        return this;
    }
}

