/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.util;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShutdownHooks
extends Thread {
    protected static Log log = LogFactory.getLog(ShutdownHooks.class);
    private static LinkedList files = new LinkedList();
    private static LinkedList codes = new LinkedList();

    public static synchronized void deleteOnExit(String filename) {
        files.addFirst(filename);
    }

    public static synchronized void runOnExit(Runnable codeblob) {
        codes.addFirst(codeblob);
    }

    public static synchronized void exit(boolean exit) {
        for (String file : files) {
            File f = new File(file);
            if (!(f != null & f.exists())) continue;
            f.delete();
        }
        Iterator icodes = codes.iterator();
        Notif n = new Notif(codes.size());
        while (icodes.hasNext()) {
            Runnable code = (Runnable)icodes.next();
            try {
                Helper t = new Helper(code, n);
                t.start();
                if (exit) continue;
                t.join();
            }
            catch (IllegalThreadStateException e) {
                log.error("Exception", e);
            }
            catch (InterruptedException e) {
                log.error("Exception", e);
            }
        }
        files = new LinkedList();
        codes = new LinkedList();
        if (exit) {
            n.start();
        }
    }

    @Override
    public void run() {
        ShutdownHooks.exit(false);
    }

    private static class Notif
    extends Thread {
        volatile int count;
        private Object lock = new Object();

        public Notif(int n) {
            this.count = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            Object object = this.lock;
            synchronized (object) {
                --this.count;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                while (this.count > 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            System.exit(0);
        }
    }

    private static class Helper
    extends Thread {
        Runnable task;
        Notif notif;

        public Helper(Runnable r, Notif n) {
            this.task = r;
            this.notif = n;
        }

        @Override
        public void run() {
            this.task.run();
            this.notif.done();
        }
    }
}

