/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.authentication.ExampleFileFilter;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MyProxyPrompt {
    public static final String PASSWORD_ICON = "/com/sshtools/common/authentication/largepassword.png";
    private static MyProxyPrompt instance;
    private Component parent;
    private String title = "Retrieve Credentials from MyProxy:";
    private String default_name;
    private String default_voname;
    private String default_host;
    private String lastError = "";
    private MyProxyDialog last;
    private String lastFILE = null;

    private MyProxyPrompt() {
    }

    public void setParentComponent(Component component) {
        this.parent = component;
    }

    public boolean doGet(Component component, StringBuffer stringbuffer, StringBuffer stringbuffer1, StringBuffer stringbuffer2, StringBuffer stringbuffer3) {
        if (component == null) {
            component = this.parent;
        }
        Window window = component != null ? (Window)SwingUtilities.getAncestorOfClass(Window.class, component) : null;
        MyProxyDialog myproxydialog = null;
        myproxydialog = window instanceof Frame ? new MyProxyDialog((Frame)window) : (window instanceof Dialog ? new MyProxyDialog((Dialog)window) : new MyProxyDialog());
        stringbuffer.append(myproxydialog.getHost());
        stringbuffer1.append(myproxydialog.getAccountName());
        stringbuffer2.append(myproxydialog.getPassword());
        stringbuffer3.append(myproxydialog.getVOName());
        this.last = myproxydialog;
        this.lastFILE = this.last.getPKCSFile();
        return myproxydialog.getCanceled();
    }

    public boolean keyBased(StringBuffer bufferf, StringBuffer bufferp) {
        bufferp.append(this.last.getCPassword());
        bufferf.append(this.last.getCFile());
        return this.last.getKeybased();
    }

    public boolean getBrowser() {
        return this.last.getBrowser();
    }

    public boolean getAnother() {
        return this.last.getAnother();
    }

    public static MyProxyPrompt getInstance() {
        if (instance == null) {
            instance = new MyProxyPrompt();
        }
        return instance;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public void setHost(String newhost) {
        this.default_host = newhost;
    }

    public void setAccountName(String newname) {
        this.default_name = newname;
    }

    public void setVOName(String newvoname) {
        this.default_voname = newvoname;
    }

    public void setError(String s) {
        this.lastError = s;
    }

    public void setProperties(SshConnectionProperties properties) {
        if (properties instanceof SshToolsConnectionProfile) {
            this.lastFILE = ((SshToolsConnectionProfile)properties).getApplicationProperty("sshterm.pkcs12.defaults.file", null);
        }
    }

    class MyProxyDialog
    extends JDialog {
        JLabel promptLabel;
        JTextField host;
        JTextField name;
        JTextField cfile;
        JPasswordField password;
        JPasswordField cpassword;
        JTextField voname;
        boolean cancelled;
        boolean myproxy;
        boolean browser;
        boolean another;

        String getPassword() {
            if (this.cancelled || !this.myproxy) {
                return null;
            }
            return new String(this.password.getPassword());
        }

        String getCPassword() {
            if (this.cancelled || this.myproxy || this.browser) {
                return null;
            }
            return new String(this.cpassword.getPassword());
        }

        String getHost() {
            return !this.cancelled && this.myproxy ? this.host.getText() : null;
        }

        String getAccountName() {
            return !this.cancelled && this.myproxy ? this.name.getText() : null;
        }

        String getVOName() {
            return !this.cancelled && this.myproxy ? this.voname.getText() : null;
        }

        String getCFile() {
            return !this.cancelled && !this.myproxy && !this.browser ? this.cfile.getText() : null;
        }

        String getPKCSFile() {
            return this.cfile.getText();
        }

        boolean getCanceled() {
            return this.cancelled;
        }

        void setFile(File f) {
            this.cfile.setText(f.getAbsolutePath());
        }

        void init() {
            this.setDefaultCloseOperation(2);
            JPanel pMyproxy = new JPanel(new GridBagLayout());
            GridBagConstraints gridbagconstraints = new GridBagConstraints();
            gridbagconstraints.insets = new Insets(0, 0, 2, 2);
            gridbagconstraints.anchor = 17;
            gridbagconstraints.fill = 2;
            gridbagconstraints.weightx = 0.0;
            UIUtil.jGridBagAdd(pMyproxy, new JLabel("Host: "), gridbagconstraints, -1);
            gridbagconstraints.weightx = 1.0;
            UIUtil.jGridBagAdd(pMyproxy, this.host, gridbagconstraints, 0);
            gridbagconstraints.weightx = 0.0;
            UIUtil.jGridBagAdd(pMyproxy, new JLabel("Account Name: "), gridbagconstraints, -1);
            gridbagconstraints.weightx = 1.0;
            UIUtil.jGridBagAdd(pMyproxy, this.name, gridbagconstraints, 0);
            gridbagconstraints.weightx = 0.0;
            UIUtil.jGridBagAdd(pMyproxy, new JLabel("Passphrase: "), gridbagconstraints, -1);
            gridbagconstraints.weightx = 1.0;
            UIUtil.jGridBagAdd(pMyproxy, this.password, gridbagconstraints, 0);
            gridbagconstraints.weightx = 0.0;
            UIUtil.jGridBagAdd(pMyproxy, new JLabel("VO Name: "), gridbagconstraints, -1);
            gridbagconstraints.weightx = 1.0;
            UIUtil.jGridBagAdd(pMyproxy, this.voname, gridbagconstraints, 0);
            this.promptLabel.setHorizontalAlignment(0);
            JPanel pOuterMP = new JPanel(new BorderLayout());
            pOuterMP.add((Component)this.promptLabel, "North");
            pOuterMP.add((Component)pMyproxy, "Center");
            JButton jbutton = new JButton("Use MyProxy");
            jbutton.setMnemonic('m');
            jbutton.setDefaultCapable(true);
            jbutton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    MyProxyDialog.this.another = false;
                    MyProxyDialog.this.cancelled = false;
                    MyProxyDialog.this.browser = false;
                    MyProxyDialog.this.myproxy = true;
                    MyProxyDialog.this.cancelled = false;
                    MyProxyDialog.this.hide();
                }
            });
            this.getRootPane().setDefaultButton(jbutton);
            JPanel jpanel2 = new JPanel(new FlowLayout(2, 0, 0));
            jpanel2.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            jpanel2.add(jbutton);
            pOuterMP.add((Component)jpanel2, "South");
            IconWrapperPanel iconwrapperpanel = new IconWrapperPanel(new ResourceIcon("largelock.png"), pOuterMP);
            iconwrapperpanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JButton jbuttonB = new JButton("Browse...");
            jbuttonB.setMnemonic('b');
            jbuttonB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    JFileChooser chooser = new JFileChooser();
                    ExampleFileFilter filter = new ExampleFileFilter();
                    filter.addExtension("pfx");
                    filter.addExtension("p12");
                    filter.setDescription("pfx and p12 files");
                    chooser.setFileFilter(filter);
                    chooser.setFileHidingEnabled(false);
                    chooser.setDialogTitle("Select Certificate File For Authentication");
                    if (chooser.showOpenDialog(MyProxyPrompt.this.parent) == 0) {
                        MyProxyDialog.this.setFile(chooser.getSelectedFile());
                    }
                }
            });
            this.cpassword.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int k = e.getKeyCode();
                    if (k == 10) {
                        MyProxyDialog.this.another = false;
                        MyProxyDialog.this.cancelled = false;
                        MyProxyDialog.this.browser = false;
                        MyProxyDialog.this.myproxy = false;
                        MyProxyDialog.this.hide();
                        e.consume();
                    }
                }
            });
            JPanel filepan = new JPanel(new BorderLayout());
            filepan.add((Component)this.cfile, "Center");
            filepan.add((Component)jbuttonB, "East");
            JPanel jpanelC = new JPanel(new GridBagLayout());
            gridbagconstraints = new GridBagConstraints();
            gridbagconstraints.insets = new Insets(0, 0, 2, 2);
            gridbagconstraints.anchor = 17;
            gridbagconstraints.fill = 2;
            gridbagconstraints.weightx = 0.0;
            UIUtil.jGridBagAdd(jpanelC, new JLabel("Filename: "), gridbagconstraints, -1);
            gridbagconstraints.weightx = 1.0;
            UIUtil.jGridBagAdd(jpanelC, filepan, gridbagconstraints, 0);
            gridbagconstraints.weightx = 0.0;
            UIUtil.jGridBagAdd(jpanelC, new JLabel("Passphrase: "), gridbagconstraints, -1);
            gridbagconstraints.weightx = 1.0;
            UIUtil.jGridBagAdd(jpanelC, this.cpassword, gridbagconstraints, 0);
            JLabel promptLabelC = new JLabel("Use a Grid certificate in pkcs12 format:");
            promptLabelC.setHorizontalAlignment(0);
            JButton jbuttonC = new JButton("Use Certificate");
            jbuttonC.setMnemonic('t');
            jbuttonC.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    MyProxyDialog.this.another = false;
                    MyProxyDialog.this.cancelled = false;
                    MyProxyDialog.this.browser = false;
                    MyProxyDialog.this.myproxy = false;
                    MyProxyDialog.this.hide();
                }
            });
            JPanel jpanelC2 = new JPanel(new BorderLayout());
            jpanelC2.add((Component)jbuttonC, "East");
            JPanel jpanelC1 = new JPanel(new BorderLayout());
            jpanelC1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jpanelC1.add((Component)promptLabelC, "North");
            jpanelC1.add((Component)jpanelC, "Center");
            jpanelC1.add((Component)jpanelC2, "South");
            IconWrapperPanel iconwrapperpanelC = new IconWrapperPanel(new ResourceIcon("/com/sshtools/common/authentication/largepassphrase.png"), jpanelC1);
            iconwrapperpanelC.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JButton jbuttonB2 = new JButton("Use Certificate from Browser");
            jbuttonB2.setMnemonic('b');
            jbuttonB2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    MyProxyDialog.this.another = false;
                    MyProxyDialog.this.cancelled = false;
                    MyProxyDialog.this.myproxy = false;
                    MyProxyDialog.this.browser = true;
                    MyProxyDialog.this.hide();
                }
            });
            JPanel jpanelB = new JPanel(new BorderLayout());
            JLabel info = new JLabel("Search for certificates in Internet Explorer or Firefox:");
            JPanel jpanelB2 = new JPanel(new BorderLayout());
            JPanel jpanelB3 = new JPanel(new BorderLayout());
            jpanelB3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 0));
            jpanelB3.add((Component)jbuttonB2, "North");
            jpanelB2.add((Component)jpanelB3, "East");
            jpanelB2.add((Component)info, "North");
            jpanelB.add((Component)jpanelB2, "North");
            IconWrapperPanel iconwrapperpanelB = new IconWrapperPanel(new ResourceIcon("/com/sshtools/common/ui/proxy.png"), jpanelB);
            iconwrapperpanelB.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JLabel warn = new JLabel(MyProxyPrompt.this.lastError);
            warn.setForeground(Color.red);
            warn.setHorizontalAlignment(0);
            JButton jbutton1 = new JButton("Cancel");
            jbutton1.setMnemonic('c');
            jbutton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    MyProxyDialog.this.another = false;
                    MyProxyDialog.this.cancelled = true;
                    MyProxyDialog.this.browser = false;
                    MyProxyDialog.this.myproxy = false;
                    MyProxyDialog.this.hide();
                }
            });
            JButton jbuttonAnother = new JButton("Try Another Method");
            jbuttonAnother.setMnemonic('a');
            jbuttonAnother.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    MyProxyDialog.this.another = true;
                    MyProxyDialog.this.cancelled = false;
                    MyProxyDialog.this.browser = false;
                    MyProxyDialog.this.myproxy = false;
                    MyProxyDialog.this.hide();
                }
            });
            JPanel jpanelEND = new JPanel(new FlowLayout(0, 0, 0));
            jpanelEND.add(jbutton1);
            jpanelEND.add(jbuttonAnother);
            jpanelEND.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel jpanelW = new JPanel(new BorderLayout());
            jpanelW.add((Component)warn, "North");
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(jpanelW);
            this.getContentPane().add(iconwrapperpanel);
            this.getContentPane().add(iconwrapperpanelC);
            this.getContentPane().add(iconwrapperpanelB);
            this.getContentPane().add(jpanelEND);
            this.pack();
            this.setResizable(false);
            this.toFront();
            UIUtil.positionComponent(0, this);
            this.setVisible(true);
            this.password.requestFocus();
        }

        boolean getKeybased() {
            return !this.cancelled && !this.another && !this.browser && !this.myproxy;
        }

        boolean getAnother() {
            return this.another;
        }

        boolean getBrowser() {
            return this.browser;
        }

        MyProxyDialog() {
            super((Frame)null, "Grid Certificate/Proxy needed for Authentication", true);
            this.cancelled = true;
            this.myproxy = false;
            this.browser = false;
            this.another = false;
            this.promptLabel = new JLabel(MyProxyPrompt.this.title);
            this.host = new JTextField(15);
            this.name = new JTextField(15);
            this.voname = new JTextField(15);
            this.host.setText(MyProxyPrompt.this.default_host);
            this.name.setText(MyProxyPrompt.this.default_name);
            this.voname.setText(MyProxyPrompt.this.default_voname);
            this.password = new JPasswordField(15);
            this.cpassword = new JPasswordField(15);
            this.cfile = new JTextField(10);
            if (MyProxyPrompt.this.lastFILE == null) {
                this.cfile.setText(PreferencesStore.get("sshterm.pkcs12.defaults.file", ""));
            } else {
                this.cfile.setText(MyProxyPrompt.this.lastFILE);
            }
            this.init();
        }

        MyProxyDialog(Frame frame) {
            super(frame, "Grid Certificate/Proxy needed for Authentication", true);
            this.cancelled = true;
            this.myproxy = false;
            this.browser = false;
            this.another = false;
            this.promptLabel = new JLabel(MyProxyPrompt.this.title);
            this.host = new JTextField(15);
            this.name = new JTextField(15);
            this.host.setText(MyProxyPrompt.this.default_host);
            this.name.setText(MyProxyPrompt.this.default_name);
            this.password = new JPasswordField(15);
            this.cpassword = new JPasswordField(15);
            this.cfile = new JTextField(10);
            if (MyProxyPrompt.this.lastFILE == null) {
                this.cfile.setText(PreferencesStore.get("sshterm.pkcs12.defaults.file", ""));
            } else {
                this.cfile.setText(MyProxyPrompt.this.lastFILE);
            }
            this.init();
        }

        MyProxyDialog(Dialog dialog) {
            super(dialog, "Grid Certificate/Proxy needed for Authentication", true);
            this.cancelled = true;
            this.myproxy = false;
            this.browser = false;
            this.another = false;
            this.promptLabel = new JLabel(MyProxyPrompt.this.title);
            this.host = new JTextField(15);
            this.name = new JTextField(15);
            this.host.setText(MyProxyPrompt.this.default_host);
            this.name.setText(MyProxyPrompt.this.default_name);
            this.password = new JPasswordField(15);
            this.cpassword = new JPasswordField(15);
            this.cfile = new JTextField(10);
            if (MyProxyPrompt.this.lastFILE == null) {
                this.cfile.setText(PreferencesStore.get("sshterm.pkcs12.defaults.file", ""));
            } else {
                this.cfile.setText(MyProxyPrompt.this.lastFILE);
            }
            this.init();
        }
    }
}

