/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.subsystem.SubsystemMessageStore;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SubsystemClient
implements Runnable {
    private static Log log = LogFactory.getLog(SubsystemClient.class);
    private InputStream in;
    private OutputStream out;
    private Thread thread;
    private String name;
    private StartStopState state = new StartStopState(2);
    protected SubsystemMessageStore messageStore;
    protected SessionChannelClient session;

    public SubsystemClient(String name) {
        this.name = name;
        this.messageStore = new SubsystemMessageStore();
    }

    public SubsystemClient(String name, SubsystemMessageStore messageStore) {
        this.name = name;
        this.messageStore = messageStore;
    }

    public boolean isClosed() {
        return this.state.getValue() == 2;
    }

    public void setSessionChannel(SessionChannelClient session) {
        this.session = session;
        this.in = session.getInputStream();
        this.out = session.getOutputStream();
        session.setName(this.name);
    }

    public SessionChannelClient getSessionChannel() {
        return this.session;
    }

    public boolean start() throws IOException {
        this.thread = new SshThread(this, this.name + " subsystem", true);
        if (this.session == null) {
            throw new IOException("No valid session is attached to the subsystem!");
        }
        if (this.session.getState().getValue() != 2) {
            throw new IOException("The session is not open!");
        }
        this.thread.start();
        return this.onStart();
    }

    protected abstract boolean onStart() throws IOException;

    public String getName() {
        return this.name;
    }

    protected void sendMessage(SubsystemMessage msg) throws InvalidMessageException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Sending " + msg.getMessageName() + " subsystem message");
        }
        byte[] msgdata = msg.toByteArray();
        this.out.write(ByteArrayWriter.encodeInt(msgdata.length));
        this.out.write(msgdata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buffer = new byte[4];
        this.state.setValue(1);
        try {
            while (this.state.getValue() == 1 && this.session.getState().getValue() == 2) {
                int read = this.in.read(buffer);
                if (read > 0) {
                    int len = (int)ByteArrayReader.readInt(buffer, 0);
                    byte[] msg = new byte[len];
                    int pos = 0;
                    while (pos < len) {
                        read = this.in.read(msg, pos, msg.length - pos);
                        if (read > 0) {
                            pos += read;
                            continue;
                        }
                        if (read != -1) continue;
                    }
                    this.messageStore.addMessage(msg);
                    msg = null;
                    continue;
                }
                if (read != -1) continue;
                break;
            }
        }
        catch (IOException ioe) {
            log.fatal("Subsystem message loop failed!", ioe);
        }
        finally {
            this.state.setValue(2);
        }
        this.thread = null;
    }

    public void stop() throws IOException {
        this.state.setValue(2);
        this.in.close();
        this.out.close();
        this.session.close();
    }
}

