/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.math.BigInteger;

public class SshMsgKexGssComplete
extends SshMessage {
    protected static final int SSH_MSG_KEXGSS_COMPLETE = 32;
    private BigInteger f;
    private byte[] token = null;
    private byte[] MIC;

    public SshMsgKexGssComplete(byte[] token, byte[] MIC, BigInteger f) {
        super(32);
        this.f = f;
        this.MIC = MIC;
        this.token = token;
    }

    public SshMsgKexGssComplete() {
        super(32);
    }

    public byte[] getMIC() {
        return this.MIC;
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public BigInteger getF() {
        return this.f;
    }

    public byte[] getToken() {
        return this.token;
    }

    @Override
    public String getMessageName() {
        return "SSH_MSG_KEXGSS_COMPLETE";
    }

    @Override
    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeBigInteger(this.f);
            baw.writeBinaryString(this.MIC);
            if (this.token != null) {
                baw.write(-1);
                baw.writeBinaryString(this.token);
            } else {
                baw.write(0);
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error writing message data: " + ioe.getMessage());
        }
    }

    @Override
    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.f = bar.readBigInteger();
            this.MIC = bar.readBinaryString();
            this.token = (byte[])(bar.read() != 0 ? bar.readBinaryString() : null);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error reading message data: " + ioe.getMessage());
        }
    }
}

