/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.rsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.rsa.SshRsaPublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPrivateKey
extends SshPrivateKey {
    RSAPrivateKey prvKey;
    RSAPublicKey pubKey;

    public SshRsaPrivateKey(RSAPrivateKey prv, RSAPublicKey pub) {
        this.prvKey = prv;
        this.pubKey = pub;
    }

    public SshRsaPrivateKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader bar = new ByteArrayReader(encoded);
            String header = bar.readString();
            if (!header.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger e = bar.readBigInteger();
            BigInteger n = bar.readBigInteger();
            BigInteger p = bar.readBigInteger();
            RSAPrivateKeySpec prvSpec = new RSAPrivateKeySpec(n, p);
            RSAPublicKeySpec pubSpec = new RSAPublicKeySpec(n, e);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            this.prvKey = (RSAPrivateKey)kf.generatePrivate(prvSpec);
            this.pubKey = (RSAPublicKey)kf.generatePublic(pubSpec);
        }
        catch (Exception e) {
            throw new InvalidSshKeyException();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshRsaPrivateKey) {
            return this.prvKey.equals(((SshRsaPrivateKey)obj).prvKey);
        }
        return false;
    }

    public int hashCode() {
        return this.prvKey.hashCode();
    }

    @Override
    public String getAlgorithmName() {
        return "ssh-rsa";
    }

    @Override
    public int getBitLength() {
        return this.prvKey.getModulus().bitLength();
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.write(this.getPublicKey().getEncoded());
            baw.writeBigInteger(this.prvKey.getPrivateExponent());
            return baw.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public SshPublicKey getPublicKey() {
        return new SshRsaPublicKey(this.pubKey);
    }

    @Override
    public byte[] generateSignature(byte[] data) {
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initSign(this.prvKey);
            sig.update(data);
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.writeString(this.getAlgorithmName());
            baw.writeBinaryString(sig.sign());
            return baw.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }
}

