/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.shift;

import com.sshtools.common.configuration.InvalidProfileFileException;
import com.sshtools.common.ui.DataNotificationListener;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsApplicationSessionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.shift.AddFavouriteAction;
import com.sshtools.shift.BackAction;
import com.sshtools.shift.CopyFromAction;
import com.sshtools.shift.CopyToAction;
import com.sshtools.shift.DeleteAction;
import com.sshtools.shift.DirectoryListingTableModel;
import com.sshtools.shift.FavoriteAction;
import com.sshtools.shift.FileSizeTableCellRenderer;
import com.sshtools.shift.FileTransferDialog;
import com.sshtools.shift.ForwardAction;
import com.sshtools.shift.HomeAction;
import com.sshtools.shift.NewFolderAction;
import com.sshtools.shift.PropertiesAction;
import com.sshtools.shift.PropertiesDialog;
import com.sshtools.shift.RefreshAction;
import com.sshtools.shift.RenameAction;
import com.sshtools.shift.RootAction;
import com.sshtools.shift.SftpTableCellRenderer;
import com.sshtools.shift.UpAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.iharder.dnd.FileDrop;

public class ShiftSessionPanel
extends SshToolsApplicationSessionPanel {
    public static final ResourceIcon FILE_BROWSER_ICON = new ResourceIcon(ShiftSessionPanel.class, "sftpsession.png");
    static final ResourceIcon ADD_FAVOURITE_ICON = new ResourceIcon(ShiftSessionPanel.class, "largeaddfavourite.png");
    SftpClient sftp;
    JScrollPane scrollPane = new JScrollPane();
    JTable listing = new JTable();
    DirectoryListingTableModel model;
    JPanel navigation = new JPanel(new GridBagLayout());
    JLabel address = new JLabel("Address");
    JComboBox addressDropdown = new JComboBox();
    Stack backStack = new Stack();
    Stack forwardStack = new Stack();
    CopyFromAction copyFrom;
    CopyToAction copyTo;
    DeleteAction delete;
    NewFolderAction newFolder;
    UpAction up;
    BackAction back;
    ForwardAction forward;
    HomeAction home;
    RootAction root;
    RefreshAction refresh;
    RenameAction rename;
    PropertiesAction properties;
    AddFavouriteAction favorite;
    StatusBar statusBar;
    StandardAction cd;
    JPopupMenu popupMenu = new JPopupMenu();
    String lastDownloadPath = new String();
    String lastUploadPath = new String();
    Object lock = new Object();
    int weight = 10;
    boolean isUpdating = false;
    ChannelEventListener eventListener;
    Vector activeOperations = new Vector();
    private List taskList = Collections.synchronizedList(new LinkedList());
    private Object flag = new Object();

    public ShiftSessionPanel() {
        super(new BorderLayout());
    }

    @Override
    public SshToolsConnectionTab[] getAdditionalConnectionTabs() {
        return null;
    }

    @Override
    public boolean requiresConfiguration() {
        return false;
    }

    @Override
    public String getId() {
        return "shift";
    }

    @Override
    public void addEventListener(ChannelEventListener eventListener) {
        this.eventListener = eventListener;
        if (this.sftp != null) {
            this.sftp.addEventListener(eventListener);
        }
    }

    @Override
    public ResourceIcon getIcon() {
        return FILE_BROWSER_ICON;
    }

    @Override
    public void init(SshToolsApplication application) throws SshToolsApplicationException {
        super.init(application);
        this.listing.setShowGrid(false);
        this.listing.setShowHorizontalLines(false);
        this.listing.setShowVerticalLines(false);
        this.listing.setIntercellSpacing(new Dimension(0, 0));
        this.listing.setColumnSelectionAllowed(false);
        this.model = new DirectoryListingTableModel(this.sftp);
        this.listing.setModel(this.model);
        this.scrollPane.getViewport().add(this.listing);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.listing.setBackground(Color.white);
        Insets ins = new Insets(8, 2, 2, 2);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.fill = 2;
        gbc1.anchor = 11;
        gbc1.insets = ins;
        JPanel addresspanel = new JPanel();
        addresspanel.setLayout(new GridBagLayout());
        JButton go = new JButton("Go", new ResourceIcon(ShiftSessionPanel.class, "go.png")){

            public void actionPerformed(ActionEvent ev) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        ShiftSessionPanel.this.changeDirectory(ShiftSessionPanel.this.addressDropdown.getEditor().toString(), false);
                    }
                });
            }
        };
        go.setBorder(BorderFactory.createEmptyBorder());
        gbc1.weightx = 0.0;
        UIUtil.jGridBagAdd(this.navigation, this.address, gbc1, 17);
        gbc1.weightx = 1.0;
        gbc1.insets = new Insets(2, 2, 2, 2);
        UIUtil.jGridBagAdd(addresspanel, this.addressDropdown, gbc1, -1);
        gbc1.weightx = 0.0;
        gbc1.insets = new Insets(2, 2, 2, 2);
        UIUtil.jGridBagAdd(addresspanel, go, gbc1, 0);
        gbc1.weightx = 2.0;
        UIUtil.jGridBagAdd(this.navigation, addresspanel, gbc1, 0);
        this.statusBar = new StatusBar();
        this.add((Component)this.navigation, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.statusBar, "South");
        this.initActions();
        this.addressDropdown.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(value.toString());
                this.setBackground(isSelected ? Color.black : Color.white);
                this.setForeground(isSelected ? Color.white : Color.black);
                this.setIcon(FILE_BROWSER_ICON);
                return this;
            }
        });
        new FileDrop((Component)this.scrollPane, null, new FileDrop.Listener(){

            @Override
            public void filesDropped(final File[] files) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Vector<File> localfiles = new Vector<File>();
                        Vector<File> localdirs = new Vector<File>();
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i].isDirectory()) {
                                localdirs.add(files[i]);
                                continue;
                            }
                            localfiles.add(files[i]);
                        }
                        if (localdirs.size() > 0) {
                            ShiftSessionPanel.this.copyLocalDirectories(localdirs, localfiles);
                        } else if (files.length > 0) {
                            ShiftSessionPanel.this.copyLocalFiles(files);
                        }
                        try {
                            ShiftSessionPanel.this.model.refresh();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                thread.start();
            }
        });
        new FileDrop((Component)this.listing, null, new FileDrop.Listener(){

            @Override
            public void filesDropped(final File[] files) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Vector<File> localfiles = new Vector<File>();
                        Vector<File> localdirs = new Vector<File>();
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i].isDirectory()) {
                                localdirs.add(files[i]);
                                continue;
                            }
                            localfiles.add(files[i]);
                        }
                        if (localdirs.size() > 0) {
                            ShiftSessionPanel.this.copyLocalDirectories(localdirs, localfiles);
                        } else if (files.length > 0) {
                            ShiftSessionPanel.this.copyLocalFiles(files);
                        }
                        try {
                            ShiftSessionPanel.this.model.refresh();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                thread.start();
            }
        });
        this.deregisterAction(this.getAction("Options"));
        this.setActionVisible("New Window", false);
        this.setActionVisible("About", false);
        this.startProcessingEvents();
    }

    protected void initActions() {
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Edit", "Edit", 101, 10));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Navigate", "Navigate", 110, 20));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Favorites", "Favorites", 118, 30));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Help", "Help", 104, 90));
        ActionMap map = new ActionMap();
        this.listing.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if ((evt.getModifiers() & 4) > 0) {
                    ShiftSessionPanel.this.getContextMenu().show(ShiftSessionPanel.this.listing, evt.getX(), evt.getY());
                }
            }
        });
        this.home = new HomeAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        ShiftSessionPanel.this.changeDirectory("", true);
                    }
                });
            }
        };
        this.registerAction(this.home);
        map.put(KeyStroke.getKeyStroke(36, 0), this.home);
        this.refresh = new RefreshAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ShiftSessionPanel.this.model.refresh();
                        }
                        catch (IOException ex) {
                            SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "The operation failed", "Refresh Contents", ex);
                        }
                    }
                });
            }
        };
        this.registerAction(this.refresh);
        map.put(KeyStroke.getKeyStroke(116, 0), this.refresh);
        this.newFolder = new NewFolderAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        ShiftSessionPanel.this.createFolder();
                    }
                });
            }
        };
        this.registerAction(this.newFolder);
        this.rename = new RenameAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        ShiftSessionPanel.this.rename();
                    }
                });
            }
        };
        this.registerAction(this.rename);
        this.up = new UpAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        ShiftSessionPanel.this.moveToParent();
                        ShiftSessionPanel.this.setAvailableActions();
                    }
                });
            }
        };
        this.registerAction(this.up);
        map.put(KeyStroke.getKeyStroke(85, Keyboard_Modifier), this.up);
        this.properties = new PropertiesAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        PropertiesDialog dialog = new PropertiesDialog(ShiftSessionPanel.this.model.getFileAttributes(ShiftSessionPanel.this.listing.getSelectedRow()), ShiftSessionPanel.this.sftp, ShiftSessionPanel.this.model.getFilename(ShiftSessionPanel.this.listing.getSelectedRow()), ShiftSessionPanel.this.model);
                        dialog.show();
                    }
                });
            }
        };
        this.registerAction(this.properties);
        this.copyFrom = new CopyFromAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        ShiftSessionPanel.this.copyLocalFiles();
                    }
                });
            }
        };
        this.registerAction(this.copyFrom);
        this.copyTo = new CopyToAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        ShiftSessionPanel.this.copyRemoteFiles();
                    }
                });
            }
        };
        this.registerAction(this.copyTo);
        this.delete = new DeleteAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        ShiftSessionPanel.this.removeSelected();
                    }
                });
            }
        };
        this.registerAction(this.delete);
        this.loadFavorites();
        this.favorite = new AddFavouriteAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] options = new Object[]{"Add", "Cancel"};
                Object opt = JOptionPane.showInputDialog(ShiftSessionPanel.this, "Do you want add " + ShiftSessionPanel.this.sftp.pwd().toString() + " as a favorite? ", "Add Favorite", 3, ADD_FAVOURITE_ICON, null, ShiftSessionPanel.this.sftp.pwd().toString());
                if (opt != null) {
                    ShiftSessionPanel.this.getCurrentConnectionProfile().setSftpFavorite(opt.toString(), ShiftSessionPanel.this.sftp.pwd());
                    FavoriteAction action = new FavoriteAction(opt.toString(), ShiftSessionPanel.this.weight, ShiftSessionPanel.this.sftp.pwd()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            final String theDir = this.directory;
                            ShiftSessionPanel.this.addTask(new Runnable(){

                                @Override
                                public void run() {
                                    ShiftSessionPanel.this.changeDirectory(theDir, true);
                                }
                            });
                        }
                    };
                    ShiftSessionPanel.this.addFavorite(action);
                    try {
                        ShiftSessionPanel.this.getCurrentConnectionProfile().save();
                    }
                    catch (InvalidProfileFileException ex) {
                        ex.printStackTrace();
                    }
                    ShiftSessionPanel.this.weight += 10;
                }
            }
        };
        this.registerAction(this.favorite);
        map.put(KeyStroke.getKeyStroke(70, Keyboard_Modifier), this.favorite);
        this.listing.setActionMap(map);
        int i = 1;
        this.listing.getInputMap(i).put(KeyStroke.getKeyStroke(10, 0, false), "Enter");
        this.listing.getActionMap().put("Enter", new StandardAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (ShiftSessionPanel.this.model.isDirectory(ShiftSessionPanel.this.listing.getSelectedRow()) && ShiftSessionPanel.this.listing.getSelectedRowCount() == 1) {
                            ShiftSessionPanel.this.changeDirectory(ShiftSessionPanel.this.model.getFilename(ShiftSessionPanel.this.listing.getSelectedRow()), false);
                            ShiftSessionPanel.this.setAvailableActions();
                        }
                    }
                });
            }
        });
        this.listing.getInputMap(i).put(KeyStroke.getKeyStroke(36, Keyboard_Modifier, false), "Root");
        this.root = new RootAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        ShiftSessionPanel.this.changeDirectory("/", true);
                    }
                });
            }
        };
        this.registerAction(this.root);
        this.listing.getActionMap().put("Root", this.root);
        this.listing.getInputMap(i).put(KeyStroke.getKeyStroke(38, 0, false), "Up");
        this.listing.getActionMap().put("Up", new StandardAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (ShiftSessionPanel.this.listing.getSelectedRow() > 0) {
                            int row = ShiftSessionPanel.this.listing.getSelectedRow();
                            ShiftSessionPanel.this.listing.getSelectionModel().clearSelection();
                            ShiftSessionPanel.this.listing.getSelectionModel().setSelectionInterval(row - 1, row - 1);
                            ShiftSessionPanel.this.listing.repaint();
                            ShiftSessionPanel.this.setAvailableActions();
                        } else if (ShiftSessionPanel.this.listing.getSelectedRowCount() == 0) {
                            ShiftSessionPanel.this.listing.getSelectionModel().setSelectionInterval(ShiftSessionPanel.this.listing.getRowCount(), ShiftSessionPanel.this.listing.getRowCount());
                            ShiftSessionPanel.this.listing.repaint();
                            ShiftSessionPanel.this.setAvailableActions();
                        }
                    }
                });
            }
        });
        this.listing.getInputMap(i).put(KeyStroke.getKeyStroke(40, 0, false), "Down");
        this.listing.getActionMap().put("Down", new StandardAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (ShiftSessionPanel.this.listing.getSelectedRow() < ShiftSessionPanel.this.listing.getRowCount()) {
                            int row = ShiftSessionPanel.this.listing.getSelectedRow();
                            ShiftSessionPanel.this.listing.getSelectionModel().clearSelection();
                            ShiftSessionPanel.this.listing.getSelectionModel().setSelectionInterval(row + 1, row + 1);
                            ShiftSessionPanel.this.listing.repaint();
                            ShiftSessionPanel.this.setAvailableActions();
                        }
                    }
                });
            }
        });
        this.listing.getInputMap(i).put(KeyStroke.getKeyStroke(37, Keyboard_Modifier, false), "Back");
        this.back = new BackAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (ShiftSessionPanel.this.backStack.size() > 0) {
                            ShiftSessionPanel.this.changeDirectory((String)ShiftSessionPanel.this.backStack.pop(), false);
                            ShiftSessionPanel.this.setAvailableActions();
                        }
                    }
                });
            }
        };
        this.registerAction(this.back);
        this.listing.getActionMap().put("Back", this.back);
        this.listing.getInputMap(i).put(KeyStroke.getKeyStroke(39, Keyboard_Modifier, false), "Forward");
        this.forward = new ForwardAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShiftSessionPanel.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (ShiftSessionPanel.this.forwardStack.size() > 0) {
                            String cwd = (String)ShiftSessionPanel.this.forwardStack.pop();
                            ShiftSessionPanel.this.changeDirectory(cwd, true);
                            ShiftSessionPanel.this.setAvailableActions();
                        }
                    }
                });
            }
        };
        this.registerAction(this.forward);
        this.listing.getActionMap().put("Forward", this.forward);
    }

    private void loadFavorites() {
        try {
            Map map = this.getCurrentConnectionProfile().getSftpFavorites();
            for (Map.Entry entry : map.entrySet()) {
                String name = (String)entry.getKey();
                String directory = (String)entry.getValue();
                FavoriteAction action = new FavoriteAction(name, this.weight, directory){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final String theDir = this.directory;
                        ShiftSessionPanel.this.addTask(new Runnable(){

                            @Override
                            public void run() {
                                ShiftSessionPanel.this.changeDirectory(theDir, true);
                            }
                        });
                    }
                };
                this.registerAction(action);
                this.weight += 10;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void copyLocalFiles() {
        this.addTask(new Runnable(){

            @Override
            public void run() {
                File file;
                JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
                chooser.setMultiSelectionEnabled(true);
                chooser.setDialogTitle("Select files to upload");
                chooser.setFileSelectionMode(2);
                if (ShiftSessionPanel.this.lastUploadPath != null && !ShiftSessionPanel.this.lastUploadPath.equals("") && (file = new File(ShiftSessionPanel.this.lastUploadPath)).exists()) {
                    chooser.setCurrentDirectory(new File(ShiftSessionPanel.this.lastUploadPath));
                }
                if (chooser.showDialog(ShiftSessionPanel.this, "Upload") == 0) {
                    File[] files = chooser.getSelectedFiles();
                    ShiftSessionPanel.this.lastUploadPath = chooser.getCurrentDirectory().getAbsolutePath();
                    Vector<File> localfiles = new Vector<File>();
                    Vector<File> localdirs = new Vector<File>();
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].isDirectory()) {
                            localdirs.add(files[i]);
                            continue;
                        }
                        localfiles.add(files[i]);
                    }
                    if (localdirs.size() > 0) {
                        ShiftSessionPanel.this.copyLocalDirectories(localdirs, localfiles);
                    } else if (files.length > 0) {
                        ShiftSessionPanel.this.copyLocalFiles(files);
                    }
                }
            }
        });
    }

    private void copyRemoteFiles() {
        this.addTask(new Runnable(){

            @Override
            public void run() {
                File file;
                Vector<String> remotefiles = new Vector<String>();
                Vector<String> remotedirs = new Vector<String>();
                int[] rows = ShiftSessionPanel.this.listing.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    if (ShiftSessionPanel.this.model.isDirectory(rows[i])) {
                        remotedirs.add(ShiftSessionPanel.this.model.getFilename(rows[i]));
                        continue;
                    }
                    remotefiles.add(ShiftSessionPanel.this.model.getFilename(rows[i]));
                }
                JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Select destination location");
                if (ShiftSessionPanel.this.lastDownloadPath != null && !ShiftSessionPanel.this.lastDownloadPath.equals("") && (file = new File(ShiftSessionPanel.this.lastDownloadPath)).exists()) {
                    chooser.setCurrentDirectory(new File(ShiftSessionPanel.this.lastDownloadPath));
                }
                chooser.setFileSelectionMode(1);
                if (chooser.showDialog(ShiftSessionPanel.this, "Copy") == 0) {
                    try {
                        ShiftSessionPanel.this.sftp.lcd(chooser.getSelectedFile().getAbsolutePath());
                        ShiftSessionPanel.this.lastDownloadPath = chooser.getSelectedFile().getAbsolutePath();
                        if (remotefiles.size() > 0 && remotedirs.size() == 0) {
                            ShiftSessionPanel.this.copyRemoteFiles(remotefiles);
                        } else {
                            ShiftSessionPanel.this.copyRemoteDirectories(remotedirs, remotefiles, chooser.getSelectedFile());
                        }
                    }
                    catch (IOException ex) {
                        SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "An error occured copying the remote files!", "Copy files", ex);
                    }
                }
            }
        });
    }

    protected void moveToParent() {
        try {
            String cwd = this.model.getCurrentDirectory();
            int idx = cwd.lastIndexOf("/");
            if (idx >= 0 && cwd.length() > 1) {
                this.changeDirectory(cwd.substring(0, idx + 1), true);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean onOpenSession() throws IOException {
        this.sftp = this.manager.openSftpClient();
        if (this.eventListener != null) {
            this.sftp.addEventListener(this.eventListener);
        }
        this.sftp.addEventListener(new DataNotificationListener(this.statusBar));
        this.statusBar.setHost("Connected to " + this.manager.getProfile().getHost());
        this.statusBar.setConnected(true);
        this.listing.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ShiftSessionPanel.this.listing.getSelectedRowCount() == 1) {
                    if (ShiftSessionPanel.this.model.isDirectory(ShiftSessionPanel.this.listing.getSelectedRow())) {
                        ShiftSessionPanel.this.changeDirectory(ShiftSessionPanel.this.model.getFilename(ShiftSessionPanel.this.listing.getSelectedRow()), true);
                    } else {
                        Vector<String> l = new Vector<String>();
                        l.add(ShiftSessionPanel.this.model.getFilename(ShiftSessionPanel.this.listing.getSelectedRow()));
                        ShiftSessionPanel.this.copyRemoteFiles(l);
                    }
                }
                ShiftSessionPanel.this.setAvailableActions();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ShiftSessionPanel.this.setAvailableActions();
            }
        });
        this.listing.addMouseListener(new PopupListener(this.popupMenu));
        this.model = new DirectoryListingTableModel(this.sftp);
        this.listing.setModel(this.model);
        this.listing.setAutoCreateColumnsFromModel(true);
        this.model.refresh();
        this.updateAddress(this.model.getCurrentDirectory());
        DateFormat df = DateFormat.getDateInstance(3);
        this.listing.getColumn("Name").setCellRenderer(new SftpTableCellRenderer());
        this.listing.getColumn("Size").setCellRenderer(new FileSizeTableCellRenderer());
        this.listing.setBackground(Color.white);
        this.addressDropdown.setEditable(true);
        this.addressDropdown.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object object = ShiftSessionPanel.this.lock;
                    synchronized (object) {
                        if (!ShiftSessionPanel.this.isUpdating) {
                            if (e.getItem() instanceof TokenizedPathElement) {
                                ShiftSessionPanel.this.changeDirectory(((TokenizedPathElement)e.getItem()).path, true);
                            } else if (e.getItem() instanceof String) {
                                ShiftSessionPanel.this.changeDirectory(e.getItem().toString(), true);
                            }
                        }
                    }
                }
            }
        });
        this.listing.getColumnModel().getColumn(0).setPreferredWidth(200);
        return true;
    }

    protected void copyLocalFiles(final File[] localfiles) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    FileTransferDialog transfer = null;
                    try {
                        Vector<String> files = new Vector<String>();
                        for (int i = 0; i < localfiles.length; ++i) {
                            files.add(localfiles[i].getName());
                        }
                        transfer = new FileTransferDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ShiftSessionPanel.this), "Uploading", files.size());
                        Vector i = ShiftSessionPanel.this.activeOperations;
                        synchronized (i) {
                            ShiftSessionPanel.this.activeOperations.add(transfer);
                        }
                        transfer.putFiles(ShiftSessionPanel.this.sftp, localfiles[0].getParentFile(), files);
                        transfer.waitForCompletion();
                        i = ShiftSessionPanel.this.activeOperations;
                        synchronized (i) {
                            ShiftSessionPanel.this.activeOperations.remove(transfer);
                        }
                        System.out.println();
                        ShiftSessionPanel.this.model.refresh();
                    }
                    catch (Exception ex) {
                        if (transfer == null || transfer.isCancelled()) break block11;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "Failed to download files!", "SFTP Browser", ex);
                                }
                            });
                        }
                        catch (Exception ex1) {
                            ShiftSessionPanel.this.log.info("Failed to invoke message box through SwingUtilities", ex1);
                        }
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    protected void copyRemoteFiles(final List remotefiles) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    FileTransferDialog transfer = null;
                    try {
                        long totalBytes = 0L;
                        for (int i = 0; i < remotefiles.size(); ++i) {
                            FileAttributes attrs = ShiftSessionPanel.this.sftp.stat((String)remotefiles.get(i));
                            totalBytes += attrs.getSize().longValue();
                        }
                        transfer = new FileTransferDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ShiftSessionPanel.this), "Downloading", 1);
                        transfer.getRemoteFiles(ShiftSessionPanel.this.sftp, remotefiles, totalBytes);
                        Vector vector = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector) {
                            ShiftSessionPanel.this.activeOperations.add(transfer);
                        }
                        transfer.waitForCompletion();
                        vector = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector) {
                            ShiftSessionPanel.this.activeOperations.remove(transfer);
                        }
                    }
                    catch (Exception ex) {
                        if (transfer == null || transfer.isCancelled()) break block11;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "Failed to download files!", "SFTP Browser", ex);
                                }
                            });
                        }
                        catch (Exception ex1) {
                            ShiftSessionPanel.this.log.info("Failed to invoke message box through SwingUtilities", ex1);
                        }
                    }
                }
            }
        }, "Downloading files");
        thread.start();
    }

    protected void copyRemoteDirectories(final List remotedirs, final List remotefiles, final File localdir) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    FileTransferDialog transfer = null;
                    try {
                        int result = JOptionPane.showOptionDialog(ShiftSessionPanel.this, "How would you like to download the contents of " + (remotedirs.size() > 1 ? "these directories?" : "this directory?"), "Copy Directory", -1, 3, null, new String[]{"Synchronize", "Recurse Copy", "Flat Copy", "Cancel"}, "Recurse");
                        if (result == 3) {
                            return;
                        }
                        if (result == 0 && localdir.isDirectory() && localdir.listFiles().length > 0 && (result = JOptionPane.showConfirmDialog(ShiftSessionPanel.this, "The directory you have chosen is not empty!  \nThe synchronize option will clear the contents of this directory!  \n\nAre you sure you wish to proceed?", "Confirm Synchronize Operation", 0)) == 1) {
                            return;
                        }
                        ShiftSessionPanel.this.statusBar.setRemoteId("");
                        transfer = new FileTransferDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ShiftSessionPanel.this), "Downloading", 1);
                        transfer.copyRemoteDirectory(ShiftSessionPanel.this.sftp, remotedirs, remotefiles, localdir.getAbsolutePath(), result == 1 || result == 0, result == 0);
                        Vector vector = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector) {
                            ShiftSessionPanel.this.activeOperations.add(transfer);
                        }
                        transfer.waitForCompletion();
                        vector = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector) {
                            ShiftSessionPanel.this.activeOperations.remove(transfer);
                        }
                    }
                    catch (Exception ex) {
                        if (transfer == null || transfer.isCancelled()) break block12;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "Failed to download directories!", "SFTP Browser", ex);
                                }
                            });
                        }
                        catch (Exception ex1) {
                            ShiftSessionPanel.this.log.info("Failed to invoke message box through SwingUtilities", ex1);
                        }
                    }
                }
            }
        }, "Downloading directories");
        thread.start();
    }

    protected void copyLocalDirectories(final List localdirs, final List localfiles) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    FileTransferDialog transfer = null;
                    try {
                        int result = JOptionPane.showOptionDialog(ShiftSessionPanel.this, "How would you like to upload the contents of " + (localdirs.size() > 1 ? "these directories?" : "this directory?"), "Copy Directory", -1, 3, null, new String[]{"Synchronize", "Recurse Copy", "Flat Copy", "Cancel"}, "Recurse");
                        if (result == 3) {
                            return;
                        }
                        if (result == 0 && (result = JOptionPane.showConfirmDialog(ShiftSessionPanel.this, "The synchronize option will clear the contents of this directory!  \n\nAre you sure you wish to proceed?", "Confirm Synchronize Operation", 0)) == 1) {
                            return;
                        }
                        ShiftSessionPanel.this.statusBar.setRemoteId("");
                        transfer = new FileTransferDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ShiftSessionPanel.this), "Uploading", 1);
                        transfer.copyLocalDirectory(ShiftSessionPanel.this.sftp, localfiles, localdirs, ShiftSessionPanel.this.sftp.pwd(), result == 1 || result == 0, result == 0);
                        Vector vector = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector) {
                            ShiftSessionPanel.this.activeOperations.add(transfer);
                        }
                        transfer.waitForCompletion();
                        vector = ShiftSessionPanel.this.activeOperations;
                        synchronized (vector) {
                            ShiftSessionPanel.this.activeOperations.remove(transfer);
                        }
                        ShiftSessionPanel.this.model.refresh();
                    }
                    catch (Exception ex) {
                        if (transfer == null || transfer.isCancelled()) break block12;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "Failed to upload directories!", "SFTP Browser", ex);
                                }
                            });
                        }
                        catch (Exception ex1) {
                            ShiftSessionPanel.this.log.info("Failed to invoke message box through SwingUtilities", ex1);
                        }
                    }
                }
            }
        }, "Uploading directories");
        thread.start();
    }

    protected void createFolder() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    ShiftSessionPanel.this.statusBar.setStatusText("Creating folder");
                    String folder = JOptionPane.showInputDialog(ShiftSessionPanel.this, "Enter new folder name", "Create Folder", 2);
                    if (folder != null && !folder.trim().equals("")) {
                        ShiftSessionPanel.this.model.createFolder(folder);
                    }
                    ShiftSessionPanel.this.setAvailableActions();
                    ShiftSessionPanel.this.statusBar.setStatusText("Ready...");
                }
                catch (IOException ex) {
                    ShiftSessionPanel.this.statusBar.setStatusText("Ready...");
                    SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "Failed to create directory!", "SFTP Browser", ex);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    protected void rename() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    ShiftSessionPanel.this.statusBar.setStatusText("Renaming...");
                    String newname = JOptionPane.showInputDialog(ShiftSessionPanel.this, "Enter new name", "Rename", 2);
                    if (newname != null && !newname.trim().equals("")) {
                        ShiftSessionPanel.this.sftp.rename(ShiftSessionPanel.this.model.getFilename(ShiftSessionPanel.this.listing.getSelectedRow()), newname);
                        ShiftSessionPanel.this.model.refresh();
                    }
                    ShiftSessionPanel.this.setAvailableActions();
                    ShiftSessionPanel.this.statusBar.setStatusText("Ready...");
                }
                catch (IOException ex) {
                    ShiftSessionPanel.this.statusBar.setStatusText("Ready...");
                    SshToolsApplicationPanel.showErrorMessage(ShiftSessionPanel.this, "Failed to rename!", "SFTP Browser", ex);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    protected void changeDirectory(final String directory, final boolean forwards) {
        this.listing.getSelectionModel().clearSelection();
        this.setAvailableActions();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ShiftSessionPanel.this.statusBar.setStatusText("Listing directory contents... ");
                try {
                    if (forwards) {
                        ShiftSessionPanel.this.backStack.add(ShiftSessionPanel.this.model.getCurrentDirectory());
                    } else {
                        ShiftSessionPanel.this.forwardStack.add(ShiftSessionPanel.this.model.getCurrentDirectory());
                    }
                    ShiftSessionPanel.this.model.changeDirectory(directory);
                    ShiftSessionPanel.this.updateAddress(ShiftSessionPanel.this.model.getCurrentDirectory());
                    ShiftSessionPanel.this.statusBar.setStatusText("Ready...");
                    ShiftSessionPanel.this.setAvailableActions();
                }
                catch (IOException ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(ShiftSessionPanel.this, "Failed to change directory!\n" + ex.getMessage(), "SFTP Browser", 0);
                        }
                    });
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    protected void removeSelected() {
        try {
            String message;
            if (this.listing.getSelectedRowCount() == 1 && JOptionPane.showConfirmDialog(this, message = this.model.isDirectory(this.listing.getSelectedRow()) ? "Are you sure you wish to remove the selected folder and all its contents?" : "Are you sure you wish to remove this file?", "Confirm Delete", 0) == 0) {
                this.statusBar.setStatusText("Deleting...");
                this.model.removeFile(this.listing.getSelectedRows());
            }
            if (this.listing.getSelectedRowCount() > 1) {
                boolean containsFolder = false;
                int[] rows = this.listing.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    if (!this.model.isDirectory(rows[i])) continue;
                    containsFolder = true;
                    break;
                }
                if (JOptionPane.showConfirmDialog(this, message = containsFolder ? "Are you sure you wish to delete these " + String.valueOf(this.listing.getSelectedRowCount()) + " items and their contents?" : "Are you sure you wish to delete these " + String.valueOf(this.listing.getSelectedRowCount()) + " items?", "Confirm Multiple File Delete", 0) == 0) {
                    this.model.removeFile(this.listing.getSelectedRows());
                    this.setAvailableActions();
                }
            }
            this.statusBar.setStatusText("Ready...");
        }
        catch (IOException ex) {
            this.statusBar.setStatusText("Ready...");
            JOptionPane.showMessageDialog(this, "Failed to change directory!\n" + ex.getMessage(), "SFTP Browser", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAddress(String address) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (address.startsWith("/")) {
                this.isUpdating = true;
                StringTokenizer tokens = new StringTokenizer(address, "/");
                String path = "/";
                this.addressDropdown.removeAllItems();
                this.addressDropdown.addItem(new TokenizedPathElement("/", path));
                String tab = "  ";
                while (tokens.hasMoreElements()) {
                    String name = (String)tokens.nextElement();
                    path = path + (path.trim().length() > 1 ? "/" : "") + name;
                    this.addressDropdown.addItem(new TokenizedPathElement(tab + name, path));
                    tab = tab + tab;
                }
            } else {
                throw new IOException("Path must be absolute!!!");
            }
            this.addressDropdown.setSelectedIndex(this.addressDropdown.getModel().getSize() - 1);
            this.isUpdating = false;
        }
    }

    public boolean postConnection() {
        return true;
    }

    @Override
    public void setAvailableActions() {
        if (this.listing.getSelectedRowCount() == 0) {
            this.delete.setEnabled(false);
            this.properties.setEnabled(false);
            this.rename.setEnabled(false);
        } else {
            this.delete.setEnabled(true);
            this.properties.setEnabled(true);
            this.rename.setEnabled(true);
        }
        this.copyTo.setEnabled(true);
        this.copyFrom.setEnabled(true);
        this.up.setEnabled(true);
        this.newFolder.setEnabled(true);
        if (this.backStack.size() > 0) {
            this.back.setEnabled(true);
        } else {
            this.back.setEnabled(false);
        }
        if (this.forwardStack.size() > 0) {
            this.forward.setEnabled(true);
        } else {
            this.forward.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        for (FileTransferDialog dialog : this.activeOperations) {
            dialog.cancelOperation();
        }
        if (this.sftp != null && !this.sftp.isClosed()) {
            try {
                this.sftp.quit();
            }
            catch (Exception exception) {
            }
            finally {
                this.manager.requestDisconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canClose() {
        Vector vector = this.activeOperations;
        synchronized (vector) {
            if (this.sftp != null && !this.sftp.isClosed()) {
                if (this.activeOperations.size() > 0) {
                    return JOptionPane.showConfirmDialog(this, "There are " + String.valueOf(this.activeOperations.size()) + " active file operations in progress!\n" + "Do you want to cancel these operations and close the session?", "Terminate Operations", 0, 3) == 0;
                    {
                    }
                }
                if (JOptionPane.showConfirmDialog(this, "Close the current session?", "Close Session", 0, 3) == 1) {
                    return false;
                }
            }
            return true;
        }
    }

    private void startProcessingEvents() {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Runnable r = null;
                    Object object = ShiftSessionPanel.this.flag;
                    synchronized (object) {
                        if (ShiftSessionPanel.this.taskList.size() > 0) {
                            r = (Runnable)ShiftSessionPanel.this.taskList.remove(0);
                        } else {
                            try {
                                ShiftSessionPanel.this.flag.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (r == null) continue;
                    r.run();
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(Runnable r) {
        Object object = this.flag;
        synchronized (object) {
            this.taskList.add(r);
            this.flag.notifyAll();
        }
    }

    class TokenizedPathElement {
        String name;
        String path;

        TokenizedPathElement(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String toString() {
            return this.path;
        }
    }

    public class OutputStreamMonitor
    extends OutputStream
    implements ActionListener {
        Timer timer;
        OutputStream out;

        OutputStreamMonitor(OutputStream out) {
            this.out = out;
            this.timer = new Timer(500, this);
            this.timer.setRepeats(false);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            this.dataWritten(1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
            this.dataWritten(b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.dataWritten(len);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ShiftSessionPanel.this.statusBar.setSending(false);
        }

        void dataWritten(int i) {
            if (!this.timer.isRunning()) {
                ShiftSessionPanel.this.statusBar.setSending(true);
                this.timer.start();
            }
        }
    }

    public class InputStreamMonitor
    extends InputStream
    implements ActionListener {
        Timer timer;
        InputStream in;

        InputStreamMonitor(InputStream in) {
            this.in = in;
            this.timer = new Timer(500, this);
            this.timer.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ShiftSessionPanel.this.statusBar.setReceiving(false);
        }

        @Override
        public int read() throws IOException {
            int i = this.in.read();
            this.dataRead(1);
            return i;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int i = this.in.read(b);
            this.dataRead(i);
            return i;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int i = this.in.read(b, off, len);
            this.dataRead(i);
            return i;
        }

        void dataRead(int i) {
            if (!this.timer.isRunning()) {
                ShiftSessionPanel.this.statusBar.setReceiving(true);
                this.timer.start();
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ShiftSessionPanel.this.back.setEnabled(ShiftSessionPanel.this.backStack.size() > 0);
                ShiftSessionPanel.this.forward.setEnabled(ShiftSessionPanel.this.forwardStack.size() > 0);
                ShiftSessionPanel.this.up.setEnabled(true);
                if (ShiftSessionPanel.this.listing.getSelectedRowCount() > 0) {
                    ShiftSessionPanel.this.delete.setEnabled(true);
                } else {
                    ShiftSessionPanel.this.delete.setEnabled(false);
                }
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

