/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.hep.dcapj;

import edu.caltech.hep.dcapj.dCacheFile;
import edu.caltech.hep.dcapj.dCapLayer;
import edu.caltech.hep.dcapj.io.dCacheFileInputStream;
import edu.caltech.hep.dcapj.io.dCacheFileOutputStream;
import edu.caltech.hep.dcapj.util.InvalidConfigurationException;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import lia.util.net.common.FDTCloseable;
import lia.util.net.common.FileChannelProvider;
import lia.util.net.common.FileChannelProviderFactory;
import lia.util.net.copy.FDTReaderSession;
import lia.util.net.copy.FDTWriterSession;

public class dCacheFileChannelProviderFactory
implements FileChannelProviderFactory,
FDTCloseable {
    private final FileChannelProvider readerFileChannelProvider;
    private final FileChannelProvider writerFileChannelProvider;
    private final FileChannelProvider coordinatorChannelProvider;

    public dCacheFileChannelProviderFactory() throws Exception {
        dCapLayer.initialize();
        this.readerFileChannelProvider = new dCacheReaderFileChannelProvider();
        this.writerFileChannelProvider = new dCacheWriterFileChannelProvider();
        this.coordinatorChannelProvider = new dCacheCoordinatorChannelProvider();
    }

    @Override
    public FileChannelProvider newReaderFileChannelProvider(FDTReaderSession readerSession) {
        return this.readerFileChannelProvider;
    }

    @Override
    public FileChannelProvider newWriterFileChannelProvider(FDTWriterSession writerSession) {
        return this.writerFileChannelProvider;
    }

    @Override
    public boolean close(String downMessage, Throwable downCause) {
        try {
            dCapLayer.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean isClosed() {
        return !dCapLayer.isInitialized();
    }

    private static final class dCacheCoordinatorChannelProvider
    implements FileChannelProvider {
        private dCacheCoordinatorChannelProvider() {
        }

        @Override
        public File getFile(String fName) throws IOException {
            try {
                return new dCacheFile(fName, dCacheFile.Mode.WRITE_ONLY);
            }
            catch (InvalidConfigurationException ice) {
                throw new IOException(ice);
            }
        }

        @Override
        public int getPartitionID(File dCacheFile2) throws IOException {
            if (dCacheFile2 instanceof dCacheFile) {
                return ((dCacheFile)dCacheFile2).getPoolID();
            }
            throw new IOException("File: " + dCacheFile2 + " is not an edu.caltech.hep.dcapj.dCacheFile object");
        }

        @Override
        public FileChannel getFileChannel(File dCacheFile2, String openMode) throws IOException {
            if (dCacheFile2 instanceof dCacheFile) {
                try {
                    return new dCacheFileOutputStream((dCacheFile)dCacheFile2).getChannel();
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
            throw new IOException("File: " + dCacheFile2 + " is not an edu.caltech.hep.dcapj.dCacheFile object");
        }
    }

    private static final class dCacheWriterFileChannelProvider
    implements FileChannelProvider {
        private dCacheWriterFileChannelProvider() {
        }

        @Override
        public File getFile(String fName) throws IOException {
            try {
                return new dCacheFile(fName, dCacheFile.Mode.WRITE_ONLY);
            }
            catch (InvalidConfigurationException ice) {
                throw new IOException(ice);
            }
        }

        @Override
        public int getPartitionID(File dCacheFile2) throws IOException {
            if (dCacheFile2 instanceof dCacheFile) {
                return ((dCacheFile)dCacheFile2).getPoolID();
            }
            throw new IOException("File: " + dCacheFile2 + " is not an edu.caltech.hep.dcapj.dCacheFile object");
        }

        @Override
        public FileChannel getFileChannel(File dCacheFile2, String openMode) throws IOException {
            if (dCacheFile2 instanceof dCacheFile) {
                try {
                    return new dCacheFileOutputStream((dCacheFile)dCacheFile2).getChannel();
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
            throw new IOException("File: " + dCacheFile2 + " is not an edu.caltech.hep.dcapj.dCacheFile object");
        }
    }

    private static final class dCacheReaderFileChannelProvider
    implements FileChannelProvider {
        private dCacheReaderFileChannelProvider() {
        }

        @Override
        public File getFile(String fName) throws IOException {
            try {
                return new dCacheFile(fName, dCacheFile.Mode.READ_ONLY);
            }
            catch (InvalidConfigurationException ice) {
                throw new IOException(ice);
            }
        }

        @Override
        public int getPartitionID(File dCacheFile2) throws IOException {
            if (dCacheFile2 instanceof dCacheFile) {
                return ((dCacheFile)dCacheFile2).getPoolID();
            }
            throw new IOException("File: " + dCacheFile2 + " is not an edu.caltech.hep.dcapj.dCacheFile object");
        }

        @Override
        public FileChannel getFileChannel(File dCacheFile2, String openMode) throws IOException {
            if (dCacheFile2 instanceof dCacheFile) {
                try {
                    return new dCacheFileInputStream((dCacheFile)dCacheFile2).getChannel();
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
            throw new IOException("File: " + dCacheFile2 + " is not an edu.caltech.hep.dcapj.dCacheFile object");
        }
    }
}

