/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.DERString;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.AdditionalInformationSyntax;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x500.DirectoryString;
import java.io.IOException;

public class AdditionalInformationSyntaxUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "AdditionalInformationSyntax";
    }

    public void performTest() throws Exception {
        AdditionalInformationSyntax additionalInformationSyntax = new AdditionalInformationSyntax("hello world");
        this.checkConstruction(additionalInformationSyntax, new DirectoryString("hello world"));
        try {
            AdditionalInformationSyntax.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(AdditionalInformationSyntax additionalInformationSyntax, DirectoryString directoryString) throws IOException {
        this.checkValues(additionalInformationSyntax, directoryString);
        additionalInformationSyntax = AdditionalInformationSyntax.getInstance(additionalInformationSyntax);
        this.checkValues(additionalInformationSyntax, directoryString);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(additionalInformationSyntax.toASN1Object().getEncoded());
        DERString dERString = (DERString)((Object)aSN1InputStream.readObject());
        additionalInformationSyntax = AdditionalInformationSyntax.getInstance(dERString);
        this.checkValues(additionalInformationSyntax, directoryString);
    }

    private void checkValues(AdditionalInformationSyntax additionalInformationSyntax, DirectoryString directoryString) {
        this.checkMandatoryField("information", directoryString, additionalInformationSyntax.getInformation());
    }

    public static void main(String[] stringArray) {
        AdditionalInformationSyntaxUnitTest.runTest(new AdditionalInformationSyntaxUnitTest());
    }
}

