/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.ocsp.CertHash;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;

public class CertHashUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "CertHash";
    }

    public void performTest() throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.2.3"));
        byte[] byArray = new byte[20];
        CertHash certHash = new CertHash(algorithmIdentifier, byArray);
        this.checkConstruction(certHash, algorithmIdentifier, byArray);
        certHash = CertHash.getInstance(null);
        if (certHash != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            CertHash.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(CertHash certHash, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws IOException {
        this.checkValues(certHash, algorithmIdentifier, byArray);
        certHash = CertHash.getInstance(certHash);
        this.checkValues(certHash, algorithmIdentifier, byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(certHash.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        certHash = CertHash.getInstance(aSN1Sequence);
        this.checkValues(certHash, algorithmIdentifier, byArray);
    }

    private void checkValues(CertHash certHash, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.checkMandatoryField("algorithmHash", algorithmIdentifier, certHash.getHashAlgorithm());
        this.checkMandatoryField("certificateHash", byArray, certHash.getCertificateHash());
    }

    public static void main(String[] stringArray) {
        CertHashUnitTest.runTest(new CertHashUnitTest());
    }
}

