/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1ObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OctetString;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OutputStream;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.DERNull;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DEROctetString;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.oiw.ElGamalParameter;
import edu.illinois.ncsa.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import edu.illinois.ncsa.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import edu.illinois.ncsa.bouncycastle.asn1.x509.AlgorithmIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.x509.GeneralName;
import edu.illinois.ncsa.bouncycastle.asn1.x509.GeneralNames;
import edu.illinois.ncsa.bouncycastle.asn1.x509.IssuingDistributionPoint;
import edu.illinois.ncsa.bouncycastle.asn1.x509.KeyUsage;
import edu.illinois.ncsa.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import edu.illinois.ncsa.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import edu.illinois.ncsa.bouncycastle.asn1.x509.TBSCertList;
import edu.illinois.ncsa.bouncycastle.asn1.x509.TBSCertificateStructure;
import edu.illinois.ncsa.bouncycastle.asn1.x509.Time;
import edu.illinois.ncsa.bouncycastle.asn1.x509.V1TBSCertificateGenerator;
import edu.illinois.ncsa.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import edu.illinois.ncsa.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509Extension;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509Extensions;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509Name;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.encoders.Base64;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class GenerationTest
extends SimpleTest {
    private byte[] v1Cert = Base64.decode("MIGtAgEBMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMMAkFVMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAxMlowNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMTAaMA0GCSqGSIb3DQEBAQUAAwkAMAYCAQECAQI=");
    private byte[] v3Cert = Base64.decode("MIIBSKADAgECAgECMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMMAkFVMRYwFAYDVQQKDA1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAwMlowNjELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsMBlRlc3QgMjAYMBAGBisOBwIBATAGAgEBAgECAwQAAgEDo4GVMIGSMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAyggECMCAGA1UdDgEB/wQWBBQ2T3aRz8you6PBCaJJEFNrqgh0UTALBgNVHQ8EBAMCBBA=");
    private byte[] v3CertNullSubject = Base64.decode("MIHGoAMCAQICAQIwDQYJKoZIhvcNAQEEBQAwJTELMAkGA1UEAwwCQVUxFjAUBgNVBAoMDUJvdW5jeSBDYXN0bGUwHhcNNzAwMTAxMDAwMDAxWhcNNzAwMTAxMDAwMDAyWjAAMBgwEAYGKw4HAgEBMAYCAQECAQIDBAACAQOjSjBIMEYGA1UdEQEB/wQ8MDqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAy");
    private byte[] v2CertList = Base64.decode("MIIBRQIBATANBgkqhkiG9w0BAQUFADAlMQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZRcNNzAwMTAxMDAwMDAwWhcNNzAwMTAxMDAwMDAyWjAkMCICAQEXDTcwMDEwMTAwMDAwMVowDjAMBgNVHRUEBQoDAIAAoIHFMIHCMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAyggECMEMGA1UdEgQ8MDqkODA2MQswCQYDVQQDDAJBVTEWMBQGA1UECgwNQm91bmN5IENhc3RsZTEPMA0GA1UECwwGVGVzdCAzMAoGA1UdFAQDAgEBMAwGA1UdHAEB/wQCMAA=");

    private void tbsV1CertGen() throws IOException {
        V1TBSCertificateGenerator v1TBSCertificateGenerator = new V1TBSCertificateGenerator();
        Date date = new Date(1000L);
        Date date2 = new Date(12000L);
        v1TBSCertificateGenerator.setSerialNumber(new DERInteger(1));
        v1TBSCertificateGenerator.setStartDate(new Time(date));
        v1TBSCertificateGenerator.setEndDate(new Time(date2));
        v1TBSCertificateGenerator.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
        v1TBSCertificateGenerator.setSubject(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 1"));
        v1TBSCertificateGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, new DERNull()));
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull()), new RSAPublicKeyStructure(BigInteger.valueOf(1L), BigInteger.valueOf(2L)));
        v1TBSCertificateGenerator.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        TBSCertificateStructure tBSCertificateStructure = v1TBSCertificateGenerator.generateTBSCertificate();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(tBSCertificateStructure);
        if (!Arrays.areEqual(byteArrayOutputStream.toByteArray(), this.v1Cert)) {
            this.fail("failed v1 cert generation");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.v1Cert));
        DERObject dERObject = aSN1InputStream.readObject();
        byteArrayOutputStream = new ByteArrayOutputStream();
        aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(dERObject);
        if (!Arrays.areEqual(byteArrayOutputStream.toByteArray(), this.v1Cert)) {
            this.fail("failed v1 cert read back test");
        }
    }

    private AuthorityKeyIdentifier createAuthorityKeyId(SubjectPublicKeyInfo subjectPublicKeyInfo, X509Name x509Name, int n) {
        GeneralName generalName = new GeneralName(x509Name);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(generalName);
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo, new GeneralNames(new DERSequence(aSN1EncodableVector)), BigInteger.valueOf(n));
    }

    private void tbsV3CertGen() throws IOException {
        V3TBSCertificateGenerator v3TBSCertificateGenerator = new V3TBSCertificateGenerator();
        Date date = new Date(1000L);
        Date date2 = new Date(2000L);
        v3TBSCertificateGenerator.setSerialNumber(new DERInteger(2));
        v3TBSCertificateGenerator.setStartDate(new Time(date));
        v3TBSCertificateGenerator.setEndDate(new Time(date2));
        v3TBSCertificateGenerator.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
        v3TBSCertificateGenerator.setSubject(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"));
        v3TBSCertificateGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, new DERNull()));
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new DERInteger(3));
        v3TBSCertificateGenerator.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        Vector<ASN1ObjectIdentifier> vector = new Vector<ASN1ObjectIdentifier>();
        Hashtable<ASN1ObjectIdentifier, X509Extension> hashtable = new Hashtable<ASN1ObjectIdentifier, X509Extension>();
        vector.addElement(X509Extensions.AuthorityKeyIdentifier);
        vector.addElement(X509Extensions.SubjectKeyIdentifier);
        vector.addElement(X509Extensions.KeyUsage);
        hashtable.put(X509Extensions.AuthorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(this.createAuthorityKeyId(subjectPublicKeyInfo, new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
        hashtable.put(X509Extensions.SubjectKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(new SubjectKeyIdentifier(subjectPublicKeyInfo))));
        hashtable.put(X509Extensions.KeyUsage, new X509Extension(false, (ASN1OctetString)new DEROctetString(new KeyUsage(16))));
        X509Extensions x509Extensions = new X509Extensions(vector, hashtable);
        v3TBSCertificateGenerator.setExtensions(x509Extensions);
        TBSCertificateStructure tBSCertificateStructure = v3TBSCertificateGenerator.generateTBSCertificate();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(tBSCertificateStructure);
        if (!Arrays.areEqual(byteArrayOutputStream.toByteArray(), this.v3Cert)) {
            this.fail("failed v3 cert generation");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.v3Cert));
        DERObject dERObject = aSN1InputStream.readObject();
        byteArrayOutputStream = new ByteArrayOutputStream();
        aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(dERObject);
        if (!Arrays.areEqual(byteArrayOutputStream.toByteArray(), this.v3Cert)) {
            this.fail("failed v3 cert read back test");
        }
    }

    private void tbsV3CertGenWithNullSubject() throws IOException {
        V3TBSCertificateGenerator v3TBSCertificateGenerator;
        block4: {
            v3TBSCertificateGenerator = new V3TBSCertificateGenerator();
            Date date = new Date(1000L);
            Date date2 = new Date(2000L);
            v3TBSCertificateGenerator.setSerialNumber(new DERInteger(2));
            v3TBSCertificateGenerator.setStartDate(new Time(date));
            v3TBSCertificateGenerator.setEndDate(new Time(date2));
            v3TBSCertificateGenerator.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            v3TBSCertificateGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, new DERNull()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new DERInteger(3));
            v3TBSCertificateGenerator.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
            try {
                v3TBSCertificateGenerator.generateTBSCertificate();
                this.fail("null subject not caught!");
            }
            catch (IllegalStateException illegalStateException) {
                if (illegalStateException.getMessage().equals("not all mandatory fields set in V3 TBScertificate generator")) break block4;
                this.fail("unexpected exception", illegalStateException);
            }
        }
        Vector<ASN1ObjectIdentifier> vector = new Vector<ASN1ObjectIdentifier>();
        Hashtable<ASN1ObjectIdentifier, X509Extension> hashtable = new Hashtable<ASN1ObjectIdentifier, X509Extension>();
        vector.addElement(X509Extensions.SubjectAlternativeName);
        hashtable.put(X509Extensions.SubjectAlternativeName, new X509Extension(true, (ASN1OctetString)new DEROctetString(new GeneralNames(new GeneralName(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"))))));
        X509Extensions x509Extensions = new X509Extensions(vector, hashtable);
        v3TBSCertificateGenerator.setExtensions(x509Extensions);
        TBSCertificateStructure tBSCertificateStructure = v3TBSCertificateGenerator.generateTBSCertificate();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(tBSCertificateStructure);
        if (!Arrays.areEqual(byteArrayOutputStream.toByteArray(), this.v3CertNullSubject)) {
            this.fail("failed v3 null sub cert generation");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.v3CertNullSubject));
        DERObject dERObject = aSN1InputStream.readObject();
        byteArrayOutputStream = new ByteArrayOutputStream();
        aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(dERObject);
        if (!Arrays.areEqual(byteArrayOutputStream.toByteArray(), this.v3CertNullSubject)) {
            this.fail("failed v3 null sub cert read back test");
        }
    }

    private void tbsV2CertListGen() throws IOException {
        V2TBSCertListGenerator v2TBSCertListGenerator = new V2TBSCertListGenerator();
        v2TBSCertListGenerator.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
        v2TBSCertListGenerator.addCRLEntry(new DERInteger(1), new Time(new Date(1000L)), 32768);
        v2TBSCertListGenerator.setNextUpdate(new Time(new Date(2000L)));
        v2TBSCertListGenerator.setThisUpdate(new Time(new Date(500L)));
        v2TBSCertListGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, new DERNull()));
        Vector<ASN1ObjectIdentifier> vector = new Vector<ASN1ObjectIdentifier>();
        Hashtable<ASN1ObjectIdentifier, X509Extension> hashtable = new Hashtable<ASN1ObjectIdentifier, X509Extension>();
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new DERInteger(3));
        vector.addElement(X509Extensions.AuthorityKeyIdentifier);
        vector.addElement(X509Extensions.IssuerAlternativeName);
        vector.addElement(X509Extensions.CRLNumber);
        vector.addElement(X509Extensions.IssuingDistributionPoint);
        hashtable.put(X509Extensions.AuthorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(this.createAuthorityKeyId(subjectPublicKeyInfo, new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
        hashtable.put(X509Extensions.IssuerAlternativeName, new X509Extension(false, (ASN1OctetString)new DEROctetString(new GeneralNames(new DERSequence(new GeneralName(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 3")))))));
        hashtable.put(X509Extensions.CRLNumber, new X509Extension(false, (ASN1OctetString)new DEROctetString(new DERInteger(1))));
        hashtable.put(X509Extensions.IssuingDistributionPoint, new X509Extension(true, (ASN1OctetString)new DEROctetString(new IssuingDistributionPoint(new DERSequence()))));
        X509Extensions x509Extensions = new X509Extensions(vector, hashtable);
        v2TBSCertListGenerator.setExtensions(x509Extensions);
        TBSCertList tBSCertList = v2TBSCertListGenerator.generateTBSCertList();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(tBSCertList);
        if (!Arrays.areEqual(byteArrayOutputStream.toByteArray(), this.v2CertList)) {
            this.fail("failed v2 cert list generation");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.v2CertList));
        DERObject dERObject = aSN1InputStream.readObject();
        byteArrayOutputStream = new ByteArrayOutputStream();
        aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(dERObject);
        if (!Arrays.areEqual(byteArrayOutputStream.toByteArray(), this.v2CertList)) {
            this.fail("failed v2 cert list read back test");
        }
    }

    public void performTest() throws Exception {
        this.tbsV1CertGen();
        this.tbsV3CertGen();
        this.tbsV3CertGenWithNullSubject();
        this.tbsV2CertListGen();
    }

    public String getName() {
        return "Generation";
    }

    public static void main(String[] stringArray) {
        GenerationTest.runTest(new GenerationTest());
    }
}

