/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERGeneralizedTime;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x500.DirectoryString;
import edu.illinois.ncsa.bouncycastle.asn1.x509.sigi.NameOrPseudonym;
import edu.illinois.ncsa.bouncycastle.asn1.x509.sigi.PersonalData;
import java.io.IOException;
import java.math.BigInteger;

public class PersonalDataUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "PersonalData";
    }

    public void performTest() throws Exception {
        NameOrPseudonym nameOrPseudonym = new NameOrPseudonym("pseudonym");
        BigInteger bigInteger = BigInteger.valueOf(10L);
        DERGeneralizedTime dERGeneralizedTime = new DERGeneralizedTime("20070315173729Z");
        DirectoryString directoryString = new DirectoryString("placeOfBirth");
        String string = "M";
        DirectoryString directoryString2 = new DirectoryString("address");
        PersonalData personalData = new PersonalData(nameOrPseudonym, bigInteger, dERGeneralizedTime, directoryString, string, directoryString2);
        this.checkConstruction(personalData, nameOrPseudonym, bigInteger, dERGeneralizedTime, directoryString, string, directoryString2);
        personalData = new PersonalData(nameOrPseudonym, null, dERGeneralizedTime, directoryString, string, directoryString2);
        this.checkConstruction(personalData, nameOrPseudonym, null, dERGeneralizedTime, directoryString, string, directoryString2);
        personalData = new PersonalData(nameOrPseudonym, bigInteger, null, directoryString, string, directoryString2);
        this.checkConstruction(personalData, nameOrPseudonym, bigInteger, null, directoryString, string, directoryString2);
        personalData = new PersonalData(nameOrPseudonym, bigInteger, dERGeneralizedTime, null, string, directoryString2);
        this.checkConstruction(personalData, nameOrPseudonym, bigInteger, dERGeneralizedTime, null, string, directoryString2);
        personalData = new PersonalData(nameOrPseudonym, bigInteger, dERGeneralizedTime, directoryString, null, directoryString2);
        this.checkConstruction(personalData, nameOrPseudonym, bigInteger, dERGeneralizedTime, directoryString, null, directoryString2);
        personalData = new PersonalData(nameOrPseudonym, bigInteger, dERGeneralizedTime, directoryString, string, null);
        this.checkConstruction(personalData, nameOrPseudonym, bigInteger, dERGeneralizedTime, directoryString, string, null);
        personalData = PersonalData.getInstance(null);
        if (personalData != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            PersonalData.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(PersonalData personalData, NameOrPseudonym nameOrPseudonym, BigInteger bigInteger, DERGeneralizedTime dERGeneralizedTime, DirectoryString directoryString, String string, DirectoryString directoryString2) throws IOException {
        this.checkValues(personalData, nameOrPseudonym, bigInteger, dERGeneralizedTime, directoryString, string, directoryString2);
        personalData = PersonalData.getInstance(personalData);
        this.checkValues(personalData, nameOrPseudonym, bigInteger, dERGeneralizedTime, directoryString, string, directoryString2);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(personalData.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        personalData = PersonalData.getInstance(aSN1Sequence);
        this.checkValues(personalData, nameOrPseudonym, bigInteger, dERGeneralizedTime, directoryString, string, directoryString2);
    }

    private void checkValues(PersonalData personalData, NameOrPseudonym nameOrPseudonym, BigInteger bigInteger, DERGeneralizedTime dERGeneralizedTime, DirectoryString directoryString, String string, DirectoryString directoryString2) {
        this.checkMandatoryField("nameOrPseudonym", nameOrPseudonym, personalData.getNameOrPseudonym());
        this.checkOptionalField("nameDistinguisher", bigInteger, personalData.getNameDistinguisher());
        this.checkOptionalField("dateOfBirth", dERGeneralizedTime, personalData.getDateOfBirth());
        this.checkOptionalField("placeOfBirth", directoryString, personalData.getPlaceOfBirth());
        this.checkOptionalField("gender", string, personalData.getGender());
        this.checkOptionalField("postalAddress", directoryString2, personalData.getPostalAddress());
    }

    public static void main(String[] stringArray) {
        PersonalDataUnitTest.runTest(new PersonalDataUnitTest());
    }
}

