/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.Digest;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public abstract class DigestTest
extends SimpleTest {
    private Digest digest;
    private String[] input;
    private String[] results;

    DigestTest(Digest digest, String[] stringArray, String[] stringArray2) {
        this.digest = digest;
        this.input = stringArray;
        this.results = stringArray2;
    }

    public String getName() {
        return this.digest.getAlgorithmName();
    }

    public void performTest() {
        byte[] byArray;
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        for (int i = 0; i < this.input.length - 1; ++i) {
            byArray = this.toByteArray(this.input[i]);
            this.vectorTest(this.digest, i, byArray2, byArray, Hex.decode(this.results[i]));
        }
        byte[] byArray3 = this.toByteArray(this.input[this.input.length - 1]);
        byArray = Hex.decode(this.results[this.input.length - 1]);
        this.vectorTest(this.digest, this.input.length - 1, byArray2, byArray3, Hex.decode(this.results[this.input.length - 1]));
        this.digest.update(byArray3, 0, byArray3.length / 2);
        Digest digest = this.cloneDigest(this.digest);
        this.digest.update(byArray3, byArray3.length / 2, byArray3.length - byArray3.length / 2);
        this.digest.doFinal(byArray2, 0);
        if (!this.areEqual(byArray, byArray2)) {
            this.fail("failing clone vector test", this.results[this.results.length - 1], new String(Hex.encode(byArray2)));
        }
        digest.update(byArray3, byArray3.length / 2, byArray3.length - byArray3.length / 2);
        digest.doFinal(byArray2, 0);
        if (!this.areEqual(byArray, byArray2)) {
            this.fail("failing second clone vector test", this.results[this.results.length - 1], new String(Hex.encode(byArray2)));
        }
    }

    private byte[] toByteArray(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    private void vectorTest(Digest digest, int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        digest.update(byArray2, 0, byArray2.length);
        digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray, byArray3)) {
            this.fail("Vector " + n + " failed got " + new String(Hex.encode(byArray)));
        }
    }

    protected abstract Digest cloneDigest(Digest var1);

    protected void millionATest(String string) {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        for (int i = 0; i < 1000000; ++i) {
            this.digest.update((byte)97);
        }
        this.digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray, Hex.decode(string))) {
            this.fail("Million a's failed");
        }
    }

    protected void sixtyFourKTest(String string) {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        for (int i = 0; i < 65536; ++i) {
            this.digest.update((byte)(i & 0xFF));
        }
        this.digest.doFinal(byArray, 0);
        if (!this.areEqual(byArray, Hex.decode(string))) {
            this.fail("64k test failed");
        }
    }
}

