/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsFatalAlert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TlsProtocolVersion {
    SSLv3(768),
    TLSv10(769),
    TLSv11(770),
    TLSv12(771);

    int version;

    private TlsProtocolVersion(int n2) {
        this.version = n2;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.version >> 8;
    }

    public int getMinorVersion() {
        return this.version & 0xFF;
    }

    public static TlsProtocolVersion get(String string) throws TlsFatalAlert {
        if ("SSLv3".equals(string)) {
            return SSLv3;
        }
        if ("TLSv1".equals(string)) {
            return TLSv10;
        }
        if ("TLSv10".equals(string)) {
            return TLSv10;
        }
        if ("TLSv11".equals(string)) {
            return TLSv11;
        }
        if ("TLSv12".equals(string)) {
            return TLSv12;
        }
        throw new TlsFatalAlert(70);
    }

    public static TlsProtocolVersion get(int n, int n2) throws TlsFatalAlert {
        for (TlsProtocolVersion tlsProtocolVersion : TlsProtocolVersion.values()) {
            if (tlsProtocolVersion.getMajorVersion() != n || tlsProtocolVersion.getMinorVersion() != n2) continue;
            return tlsProtocolVersion;
        }
        throw new TlsFatalAlert(70);
    }
}

