/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.math.ec.test;

import edu.illinois.ncsa.bouncycastle.asn1.sec.SECNamedCurves;
import edu.illinois.ncsa.bouncycastle.asn1.x9.X9ECParameters;
import edu.illinois.ncsa.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;
import junit.framework.TestCase;

public class ECPointPerformanceTest
extends TestCase {
    public static final int NUM_ROUNDS = 100;

    private void randMult(String string) throws Exception {
        X9ECParameters x9ECParameters = SECNamedCurves.getByName(string);
        BigInteger bigInteger = x9ECParameters.getN();
        ECPoint eCPoint = x9ECParameters.getG();
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
        BigInteger bigInteger2 = new BigInteger(bigInteger.bitLength() - 1, secureRandom);
        ECPoint eCPoint2 = null;
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            eCPoint2 = eCPoint.multiply(bigInteger2);
        }
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 100.0;
        System.out.println(string);
        System.out.print("Millis   : ");
        System.out.println(d);
        System.out.println();
    }

    public void testMultiply() throws Exception {
        this.randMult("sect163k1");
        this.randMult("sect163r2");
        this.randMult("sect233k1");
        this.randMult("sect233r1");
        this.randMult("sect283k1");
        this.randMult("sect283r1");
        this.randMult("sect409k1");
        this.randMult("sect409r1");
        this.randMult("sect571k1");
        this.randMult("sect571r1");
        this.randMult("secp224k1");
        this.randMult("secp224r1");
        this.randMult("secp256k1");
        this.randMult("secp256r1");
        this.randMult("secp521r1");
    }
}

