/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTServer;
import lia.util.net.copy.FDTSessionManager;
import lia.util.net.copy.transport.ControlChannel;
import lia.util.net.copy.transport.gui.ServerSessionManager;

public final class AcceptableTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(AcceptableTask.class.getName());
    private static final Config config = Config.getInstance();
    private static final FDTSessionManager fdtSessionManager = FDTSessionManager.getInstance();
    final SocketChannel sc;
    final Socket s;

    public AcceptableTask(SocketChannel sc) throws IOException {
        if (sc == null) {
            throw new NullPointerException("SocketChannel cannot be null in AcceptableTask");
        }
        if (sc.socket() == null) {
            throw new NullPointerException("Null Socket for SocketChannel in AcceptableTask");
        }
        this.sc = sc;
        this.s = sc.socket();
        this.s.setTcpNoDelay(true);
    }

    @Override
    public void run() {
        String sdpConfFlag;
        boolean bSDP;
        if (!FDTServer.filterSourceAddress(this.s)) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, " AcceptableTask for " + this.sc + " STARTED!");
        }
        boolean bl = bSDP = (sdpConfFlag = System.getProperty("com.sun.sdp.conf")) != null && !sdpConfFlag.isEmpty();
        if (!bSDP) {
            try {
                this.s.setKeepAlive(true);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "[ FDTServer ] [ AcceptableTask ] Cannot set KEEP_ALIVE for " + this.sc + ". Will ignore the error. Contact your sys admin.", t);
            }
            try {
                this.s.setTrafficClass(28);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "[ FDTServer ] [ AcceptableTask ] Cannot set traffic class for " + this.sc + "[ IPTOS_RELIABILITY (0x04) | IPTOS_THROUGHPUT (0x08) | IPTOS_LOWDELAY (0x10) ] Will ignore the error. Contact your sys admin.", t);
            }
        }
        ByteBuffer firstByte = ByteBuffer.allocate(1);
        ByteBuffer clientIDBuff = ByteBuffer.allocate(16);
        Selector tmpSelector = null;
        SelectionKey sk = null;
        this.configureSocket(firstByte, clientIDBuff, tmpSelector, sk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureSocket(ByteBuffer firstByte, ByteBuffer clientIDBuff, Selector tmpSelector, SelectionKey sk) {
        try {
            int count = -1;
            while (firstByte.hasRemaining()) {
                count = this.sc.read(firstByte);
                if (count < 0) {
                    logger.log(Level.WARNING, "[ FDTServer ] [ AcceptableTask ] Unable to read header for socket [ " + this.s + " ] The stream will be closed.");
                    try {
                        this.sc.close();
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
                if (!firstByte.hasRemaining()) continue;
                tmpSelector = Selector.open();
                sk = this.sc.register(tmpSelector, 1);
                tmpSelector.select();
            }
            if (sk != null) {
                sk.cancel();
                sk = null;
            }
            firstByte.flip();
            byte firstB = firstByte.get();
            switch (firstB) {
                case 0: {
                    if (config.isGSIModeEnabled() || config.isGSISSHModeEnabled()) {
                        logger.log(Level.WARNING, "[ FDTServer ] [ AcceptableTask ] Got a remote control channel [ " + this.s + " ] but in GSI mode ... will be rejected.");
                        try {
                            byte[] key = new byte[]{0};
                            this.sc.write(ByteBuffer.wrap(key));
                            this.sc.close();
                            return;
                        }
                        catch (Throwable key) {
                            // empty catch block
                        }
                        return;
                    }
                    this.sc.configureBlocking(true);
                    ControlChannel ct = null;
                    try {
                        ct = new ControlChannel(this.s, fdtSessionManager);
                        fdtSessionManager.addFDTClientSession(ct);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "[ FDTServer ] [ AcceptableTask ] Cannot instantiate ControlChannel", t);
                        ct = null;
                    }
                    if (ct == null) return;
                    new Thread((Runnable)ct, "ControlChannel thread for [ " + this.s.getInetAddress() + ":" + this.s.getPort() + " ]").start();
                    return;
                }
                case 1: {
                    if (config.isBlocking()) {
                        this.sc.configureBlocking(true);
                    } else {
                        this.sc.configureBlocking(false);
                    }
                    while (clientIDBuff.hasRemaining()) {
                        count = this.sc.read(clientIDBuff);
                        if (count < 0) {
                            logger.log(Level.WARNING, "[ FDTServer ] [ AcceptableTask ] Unable to read clientID. The stream will be closed");
                            Utils.closeIgnoringExceptions(this.sc);
                            return;
                        }
                        if (!clientIDBuff.hasRemaining()) break;
                        if (config.isBlocking()) {
                            logger.log(Level.WARNING, "[ FDTServer ] [ AcceptableTask ] Blocking mode ... unable to read clientID. The stream will be closed");
                            Utils.closeIgnoringExceptions(this.sc);
                            return;
                        }
                        if (tmpSelector == null) {
                            tmpSelector = Selector.open();
                        }
                        if (config.isBlocking()) continue;
                        sk = this.sc.register(tmpSelector, 1);
                        tmpSelector.select();
                    }
                    if (sk != null) {
                        sk.cancel();
                    }
                    clientIDBuff.flip();
                    UUID clientSessionID = new UUID(clientIDBuff.getLong(), clientIDBuff.getLong());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "[ FDTServer ] [ AcceptableTask ] New socket from clientID: " + clientSessionID);
                    }
                    fdtSessionManager.addWorker(clientSessionID, this.sc);
                    return;
                }
                case 2: {
                    return;
                }
                case 3: {
                    this.sc.configureBlocking(true);
                    ServerSessionManager sm = null;
                    try {
                        sm = new ServerSessionManager(this.s);
                        new Thread((Runnable)sm, "GUIControlChannel thread for [ " + this.s.getInetAddress() + ":" + this.s.getPort() + " ]").start();
                        return;
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "[ FDTServer ] [ AcceptableTask ] Cannot instantiate GUI ControlChannel", t);
                        return;
                    }
                }
                default: {
                    logger.log(Level.WARNING, "[ FDTServer ] [ AcceptableTask ] Unable to understand initial cookie: " + firstB);
                    Utils.closeIgnoringExceptions(this.s);
                    return;
                }
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "[ FDTServer ] [ AcceptableTask ] Exception: ", t);
            Utils.closeIgnoringExceptions(this.sc);
            return;
        }
        finally {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, " AcceptableTask for " + this.s + " FINISHED!");
            }
            Utils.closeIgnoringExceptions(tmpSelector);
        }
    }
}

