/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.copy.FDT;
import lia.util.net.copy.FDTSession;
import org.opentsdb.client.ExpectResponse;
import org.opentsdb.client.HttpClient;
import org.opentsdb.client.builder.Metric;
import org.opentsdb.client.builder.MetricBuilder;
import org.opentsdb.client.response.Response;

public class MonitoringUtils {
    private static Logger logger = Logger.getLogger(MonitoringUtils.class.getName());
    private Config config;
    private HttpClient client;
    private String hostName;
    private FDTSession session;

    public MonitoringUtils(Config config, FDTSession session) {
        this.session = session;
        this.config = config;
        this.client = config.getOpenTSDBMonitorClient();
        this.hostName = this.getHostName();
    }

    public MonitoringUtils(Config config) {
        this.config = config;
        this.client = config.getOpenTSDBMonitorClient();
        this.hostName = this.getHostName();
    }

    public void monitorStart(long timeRequested, String clusterName) {
        MetricBuilder builder = MetricBuilder.getInstance();
        Metric metric = builder.addMetric("fdt.transferstatus.timeStarted").setDataPoint(timeRequested, timeRequested);
        this.addTags(metric, clusterName, null);
        this.monitorStartSession(builder, timeRequested, clusterName);
        this.sendMetricsToServer(builder);
    }

    public void monitorFinish(long timeRequested, String clusterName) {
        MetricBuilder builder = MetricBuilder.getInstance();
        Metric metric = builder.addMetric("fdt.transferstatus.timeFinished").setDataPoint(timeRequested, timeRequested);
        this.addTags(metric, clusterName, null);
        this.monitorFinishSession(builder, timeRequested, clusterName);
        this.sendMetricsToServer(builder);
    }

    private synchronized void sendMetricsToServer(MetricBuilder builder) {
        if (builder.getMetrics().size() > 0) {
            if (logger.isLoggable(Level.FINE)) {
                ListIterator<Metric> iterator = builder.getMetrics().listIterator();
                while (iterator.hasNext()) {
                    try {
                        Metric metric = (Metric)iterator.next();
                        logger.log(Level.FINE, "metric    " + metric.getName() + " " + metric.stringValue());
                        logger.log(Level.FINE, "metric tag names: " + builder.getMetrics().listIterator().next().getTags().keySet().toString());
                        logger.log(Level.FINE, "metric tag values: " + builder.getMetrics().listIterator().next().getTags().values().toString());
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                if (this.client != null) {
                    Response response = this.client.pushMetrics(builder, ExpectResponse.SUMMARY);
                    logger.log(Level.FINE, "Response from OpenTSDB server: " + response.toString());
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to send metrics to OpenTSDB server", e);
            }
        }
    }

    private void monitorStartSession(MetricBuilder builder, long timeStarted, String clusterName) {
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "debugLevel", Level.parse(this.config.getLogLevel()).intValue());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "bio", this.config.isBlocking() ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "notmp", this.config.isNoTmpFlagSet() ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "nolock", this.config.isNoLockFlagSet() ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "nolocks", this.config.getConfigMap().get("-nolocks") != null ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "nettest", this.config.isNetTest() ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "bs", this.config.getByteBufferSize());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "P", this.config.getSockNum());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "ss", this.config.getSockBufSize());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "limit", this.config.getRateLimit());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "iof", this.config.getRetryIOCount());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "rCount", this.config.getReadersCount());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "wCount", this.config.getWritersCount());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "pCount", this.config.getMaxPartitionCount());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "sourcePort", this.config.getPort());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "destPort", this.session.getRemotePort());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "transferPort", this.session.getTransferPort());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "totalBytes", this.session.getTotalBytes());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "status", 1L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "recursive", this.config.isRecursive() ? 1L : 0L);
    }

    private void monitorFinishSession(MetricBuilder builder, long timeStarted, String clusterName) {
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "debugLevel", Level.parse(this.config.getLogLevel()).intValue());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "bio", this.config.isBlocking() ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "notmp", this.config.isNoTmpFlagSet() ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "nolock", this.config.isNoLockFlagSet() ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "nolocks", this.config.getConfigMap().get("-nolocks") != null ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "nettest", this.config.isNetTest() ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "bs", this.config.getByteBufferSize());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "P", this.config.getSockNum());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "ss", this.config.getSockBufSize());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "limit", this.config.getRateLimit());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "iof", this.config.getRetryIOCount());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "rCount", this.config.getReadersCount());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "wCount", this.config.getWritersCount());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "pCount", this.config.getMaxPartitionCount());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "sourcePort", this.config.getPort());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "destPort", this.session.getRemotePort());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "transferPort", this.session.getTransferPort());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "totalBytes", this.session.getTotalBytes());
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "status", 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "recursive", this.config.isRecursive() ? 1L : 0L);
        this.monitorStartConfiguration(builder, timeStarted, clusterName, "exitStatus", this.session.getCurrentStatus());
    }

    public void monitorStartConfiguration(MetricBuilder builder, long timeStarted, String clusterName, String configParam, long configValue) {
        Metric metric = builder.addMetric("fdt.transferstatus." + configParam).setDataPoint(timeStarted, configValue);
        this.addTags(metric, clusterName, null);
    }

    private void addTags(Metric metric, String clusterName, String destIP) {
        metric.addTag("fdthost", this.hostName != null ? this.hostName : "none").addTag("fdtversion", FDT.FDT_FULL_VERSION).addTag("fdtsourceIP", this.getHostIP()).addTag("fdtdestIP", destIP == null ? (this.session != null ? this.session.getRemoteAddress().getHostAddress() : "0.0.0.0") : destIP).addTag("fdtclusterName", clusterName).addTag("fdtcustomFDTTag", this.config.getFDTTag());
    }

    public synchronized void shareMetrics(String clusterName, String nodeName, Vector paramNames, Vector paramValues) {
        String hostName = this.getHostName();
        MetricBuilder builder = MetricBuilder.getInstance();
        Iterator nameIterator = paramNames.iterator();
        Iterator valueIterator = paramValues.iterator();
        String[] node = nodeName.split(":");
        while (nameIterator.hasNext() && valueIterator.hasNext() && paramNames.size() == paramValues.size()) {
            try {
                Object nameObject = nameIterator.next();
                Object valueObject = valueIterator.next();
                double value = Double.valueOf(valueObject.toString());
                Metric metric = builder.addMetric("fdt.transferstatus." + String.valueOf(nameObject)).setDataPoint(System.currentTimeMillis(), value);
                this.addTags(metric, clusterName, node[0]);
                logger.log(Level.FINE, "metric    " + metric.getName() + " " + metric.stringValue());
                logger.log(Level.FINE, "metric tag names: " + metric.getTags().keySet().toString());
                logger.log(Level.FINE, "metric tag values: " + metric.getTags().values().toString());
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "Failed to parse metric value ", e);
            }
        }
        this.sendMetricsToServer(builder);
    }

    private String getHostName() {
        String host = null;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            host = localhost.getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (host == null) {
            host = System.getenv("HOSTNAME");
        }
        return host;
    }

    private String getHostIP() {
        String ip = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr instanceof Inet6Address) continue;
                    ip = addr.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        return ip != null ? ip : "0.0.0.0";
    }

    public void monitorEndStats(boolean finishStatus, long totalBytes, long utilBytes, long startTimeMillis, long endTime, long period, String clusterName) {
        MetricBuilder builder = MetricBuilder.getInstance();
        this.monitorStartConfiguration(builder, endTime, clusterName, "destPort", this.session.getRemotePort());
        this.monitorStartConfiguration(builder, endTime, clusterName, "transferTime", period);
        this.monitorStartConfiguration(builder, endTime, clusterName, "totalFileBytes", totalBytes);
        this.monitorStartConfiguration(builder, endTime, clusterName, "totalNetworkBytes", utilBytes);
        this.monitorStartConfiguration(builder, endTime, clusterName, "finishStatus", finishStatus ? 1L : 0L);
        this.monitorStartConfiguration(builder, endTime, clusterName, "startTime", startTimeMillis);
        this.monitorStartConfiguration(builder, endTime, clusterName, "endTime", endTime);
        this.sendMetricsToServer(builder);
    }
}

