/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.DirectByteBufferPool;
import lia.util.net.common.FileChannelProvider;
import lia.util.net.common.MonitoringUtils;
import lia.util.net.common.NetloggerRecord;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.FDTSessionManager;
import lia.util.net.copy.FileBlock;
import lia.util.net.copy.FileBlockProducer;
import lia.util.net.copy.FileReaderSession;
import lia.util.net.copy.FileSession;
import lia.util.net.copy.disk.DiskReaderManager;
import lia.util.net.copy.disk.DiskReaderTask;
import lia.util.net.copy.filters.Postprocessor;
import lia.util.net.copy.filters.Preprocessor;
import lia.util.net.copy.filters.ProcessorInfo;
import lia.util.net.copy.transport.ControlChannel;
import lia.util.net.copy.transport.CtrlMsg;
import lia.util.net.copy.transport.FDTProcolException;
import lia.util.net.copy.transport.FDTSessionConfigMsg;
import lia.util.net.copy.transport.TCPSessionWriter;

public class FDTReaderSession
extends FDTSession
implements FileBlockProducer {
    public static final long END_RCV_WAIT_DELAY = TimeUnit.SECONDS.toNanos(120L);
    private static final Logger logger = Logger.getLogger(FDTReaderSession.class.getName());
    private static final DiskReaderManager diskManager = DiskReaderManager.getInstance();
    private static final Config config = Config.getInstance();
    private static final int MAX_TAKE_POLL_ITER = Config.getMaxTakePollIter();
    public final BlockingQueue<FileBlock> fileBlockQueue;
    private final TreeMap<Integer, ArrayList<DiskReaderTask>> readersMap;
    private final boolean isFileList;
    private final AtomicBoolean finalCleaupExecuted = new AtomicBoolean(false);
    private final AtomicBoolean finishNotifiedExecuted = new AtomicBoolean(false);
    private volatile ExecutorService execService;
    private String remoteDir;
    private boolean recursive;
    private int totalFileBlocks = 0;
    private ProcessorInfo processorInfo;
    private int readersCount = 1;

    public FDTReaderSession(int transferPort) throws Exception {
        super((short)1, transferPort);
        Utils.initLogger(config.getLogLevel(), new File("/tmp/" + this.sessionID + ".log"), new Properties());
        int rMul = Integer.getInteger("fdt.rQueueM", 2);
        int avProcProp = Integer.getInteger("fdt.avProc", 1);
        int avProcMax = Math.max(avProcProp, Utils.availableProcessors());
        this.fileBlockQueue = new ArrayBlockingQueue<FileBlock>(avProcMax * rMul);
        this.readersMap = new TreeMap();
        diskManager.addSession(this);
        this.remoteDir = config.getDestinationDir();
        this.recursive = config.isRecursive();
        this.isFileList = config.getConfigMap().get("-fl") != null;
        this.monID = config.getMonID();
        this.readersCount = config.getReadersCount();
        if (this.readersCount <= 0) {
            this.readersCount = 1;
        }
        this.localInit();
    }

    public FDTReaderSession(ControlChannel ctrlChannel) throws Exception {
        super(ctrlChannel, (short)0);
        Utils.initLogger(config.getLogLevel(), new File("/tmp/" + this.sessionID + ".log"), new Properties());
        this.fileBlockQueue = new ArrayBlockingQueue<FileBlock>(Utils.availableProcessors() * 2);
        this.readersMap = new TreeMap();
        this.remoteDir = (String)ctrlChannel.remoteConf.get("-d");
        this.recursive = ctrlChannel.remoteConf.get("-r") != null;
        this.isFileList = ctrlChannel.remoteConf.get("-fl") != null;
        this.monID = (String)this.controlChannel.remoteConf.get("-monID");
        this.readersCount = config.getReadersCount();
        if (this.readersCount <= 0) {
            this.readersCount = 1;
        }
        String srReadersCount = (String)ctrlChannel.remoteConf.get("-rCount");
        int rReadersCount = this.readersCount;
        if (srReadersCount != null) {
            try {
                rReadersCount = Integer.parseInt(srReadersCount);
            }
            catch (Throwable t) {
                rReadersCount = this.readersCount;
            }
        }
        this.readersCount = rReadersCount;
        diskManager.addSession(this);
    }

    private void localInit() throws Exception {
        String[] fileList = config.getFileList();
        String[] remappedFileList = config.getRemappedFileList();
        this.recursive = config.isRecursive();
        this.internalInit(fileList, remappedFileList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalInit(String[] fileList, String[] remappedFileList) throws Exception {
        boolean isFine;
        boolean isFiner = logger.isLoggable(Level.FINER);
        boolean bl = isFine = isFiner || logger.isLoggable(Level.FINE);
        if (isFiner) {
            logger.log(Level.FINER, "\n\n FDTReaderSession - internalInit ENTER \n\n FileList:\n" + Arrays.toString(fileList) + "\n\nRemappedFileList:\n" + Arrays.toString(remappedFileList));
        }
        int filtersCount = 0;
        ProcessorInfo info = new ProcessorInfo();
        long sTime = System.nanoTime();
        try {
            String preProcessFiltersProp = config.getPreFilters();
            if (preProcessFiltersProp == null || preProcessFiltersProp.length() == 0) {
                if (isFine) {
                    logger.log(Level.FINE, "No FDT Preprocess Filters defined");
                }
            } else {
                String[] preProcessFilters = preProcessFiltersProp.split(",");
                if (preProcessFilters == null || preProcessFilters.length == 0) {
                    logger.log(Level.WARNING, "Cannot understand -preFilters option!");
                } else {
                    filtersCount = preProcessFilters.length;
                    info.fileList = new String[fileList.length];
                    info.destinationDir = this.remoteDir == null ? config.getDestinationDir() : this.remoteDir;
                    info.remoteAddress = this.controlChannel.remoteAddress;
                    info.remotePort = this.controlChannel.remotePort;
                    info.recursive = this.recursive;
                    System.arraycopy(fileList, 0, info.fileList, 0, fileList.length);
                    for (String string : preProcessFilters) {
                        this.preProcess(info, string);
                    }
                }
            }
        }
        finally {
            StringBuilder sb = new StringBuilder();
            if (filtersCount > 0) {
                sb.append("[ FDTReaderSession ] Preprocessing: ").append(filtersCount).append(" filters in ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - sTime)).append(" ms");
            } else {
                sb.append("[ FDTReaderSession ] No pre processing filters defined/processed.");
            }
            logger.log(Level.INFO, sb.toString());
        }
        HashMap<String, String> initialMapping = new HashMap<String, String>();
        List<Object> newFileList = new ArrayList();
        HashMap<String, String> newRemappedFileList = new HashMap<String, String>();
        if (filtersCount > 0) {
            this.processorInfo = info;
            this.remoteDir = info.destinationDir;
            newFileList = new ArrayList(info.fileList.length);
            newFileList.addAll(Arrays.asList(info.fileList));
        } else if (this.recursive) {
            int len = fileList.length;
            for (int iter = 0; iter < len; ++iter) {
                String string = fileList[iter];
                String remappedFName = remappedFileList == null ? null : remappedFileList[iter];
                ArrayList<String> tmpFL = new ArrayList<String>();
                ArrayList<String> tmpRFL = new ArrayList<String>();
                Utils.getRecursiveFiles(string, remappedFName, tmpFL, tmpRFL);
                if (!this.isFileList) {
                    for (String ffName : tmpFL) {
                        String parent = (String)initialMapping.get(ffName);
                        if (parent != null) {
                            if (string.length() > parent.length()) {
                                parent = string;
                            }
                        } else {
                            parent = string;
                        }
                        if (!new File(parent).isDirectory()) continue;
                        initialMapping.put(new File(ffName).getAbsolutePath(), new File(parent).getAbsolutePath());
                    }
                }
                newFileList.addAll(tmpFL);
                int c = 0;
                for (String fname : tmpFL) {
                    newRemappedFileList.put(new File(fname).getAbsolutePath(), (String)tmpRFL.get(c++));
                }
            }
        } else {
            newFileList = Arrays.asList(fileList);
            int c = 0;
            if (remappedFileList != null) {
                for (String string : newFileList) {
                    if (!new File(string).isFile()) continue;
                    newRemappedFileList.put(new File(string).getAbsolutePath(), remappedFileList[c++]);
                }
            } else {
                newRemappedFileList = null;
            }
        }
        FileChannelProvider fcp = Config.getInstance().getFileChannelProviderFactory().newReaderFileChannelProvider(this);
        for (String string : newFileList) {
            if (!new File(string).exists()) {
                logger.warning("File listed in file list does not exist! " + string);
                this.controlChannel.sendCtrlMessage(new CtrlMsg(16, string));
                this.controlChannel.emptyMsgQueue();
                throw new FileNotFoundException("File does not exist! " + string);
            }
            FileReaderSession frs = new FileReaderSession(string, this, this.isLoop, fcp);
            this.fileSessions.put(frs.sessionID, frs);
            this.setSessionSize(this.sessionSize() + frs.sessionSize());
        }
        this.buildPartitionMap();
        int size = this.partitionsMap.size();
        if (size == 0) {
            throw new FDTProcolException("\n\nERROR: Cannot identify partition map for the specified fileList: " + Arrays.toString(fileList) + " No such file or directory ??");
        }
        if (isFiner) {
            logger.log(Level.FINER, "\n\n FDTReaderSession - internalInit FINISHED - sendingRemoteSessions \n\n initialMapping:\n" + initialMapping + "\n\n newRemappedFileList:\n" + newRemappedFileList);
        }
        this.sendRemoteSessions(initialMapping, newRemappedFileList);
    }

    private void preProcess(ProcessorInfo processorInfo, String filterName) throws Exception {
        boolean searchElsewhere = false;
        Preprocessor preprocessor = null;
        try {
            preprocessor = (Preprocessor)Class.forName("lia.util.net.copy.filters.examples." + filterName).newInstance();
        }
        catch (ClassNotFoundException e) {
            searchElsewhere = true;
        }
        if (searchElsewhere) {
            try {
                String userDirectory = System.getProperty("user.dir");
                File filter = new File(userDirectory + File.separator + "plugins" + File.separator);
                logger.log(Level.FINER, "Trying to load plugin from 'plugins' directory. " + filter.toString());
                URL url = filter.toURL();
                URL[] urls = new URL[]{url};
                URLClassLoader cl = new URLClassLoader(urls);
                Class<?> cls = cl.loadClass(filterName);
                preprocessor = (Preprocessor)cls.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.FINER, "Failed to load filter from external plugins directory. " + e);
                preprocessor = (Preprocessor)Class.forName(filterName).newInstance();
            }
        }
        if (preprocessor != null) {
            preprocessor.preProcessFileList(processorInfo, this.controlChannel.subject);
        }
    }

    @Override
    public long getSize() {
        return this.sessionSize();
    }

    private void sendRemoteSessions(Map<String, String> initialMapping, Map<String, String> newRemappedFileList) throws Exception {
        FDTSessionConfigMsg sccm = new FDTSessionConfigMsg();
        sccm.destinationDir = this.remoteDir;
        sccm.recursive = this.recursive;
        int count = this.fileSessions.size();
        sccm.fileIDs = new UUID[count];
        sccm.fileLists = new String[count];
        sccm.remappedFileLists = new String[count];
        sccm.fileSizes = new long[count];
        sccm.lastModifTimes = new long[count];
        count = 0;
        for (Map.Entry entry : this.fileSessions.entrySet()) {
            FileSession fs = (FileSession)entry.getValue();
            sccm.fileIDs[count] = fs.sessionID;
            if (this.isFileList) {
                sccm.fileLists[count] = fs.fileName;
                sccm.remappedFileLists[count] = newRemappedFileList == null ? null : newRemappedFileList.get(fs.fileName);
            } else if (initialMapping.size() == 0) {
                sccm.fileLists[count] = fs.getFile().getName();
            } else {
                String parent = initialMapping.get(fs.fileName);
                String name = fs.fileName;
                if (parent != null && parent.length() < name.length()) {
                    name = name.substring(parent.length() - new File(parent).getName().length());
                }
                if (parent == null) {
                    name = fs.getFile().getName();
                }
                sccm.fileLists[count] = name;
            }
            sccm.fileSizes[count] = fs.sessionSize;
            sccm.lastModifTimes[count] = fs.lastModified;
            ++count;
        }
        this.controlChannel.sendCtrlMessage(new CtrlMsg(7, sccm));
        this.setCurrentState(8);
    }

    public void setControlChannel(ControlChannel controlChannel) {
        this.controlChannel = controlChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishReader(int partitionID, DiskReaderTask drt) {
        boolean bRet = true;
        TreeMap<Integer, ArrayList<DiskReaderTask>> treeMap = this.readersMap;
        synchronized (treeMap) {
            ArrayList<DiskReaderTask> readersList = this.readersMap.get(partitionID);
            if (readersList != null && !readersList.remove(drt)) {
                bRet = false;
                logger.log(Level.WARNING, " The DiskReaderTask ");
            }
        }
        return bRet;
    }

    public void notifyReaderDown(int partitionID) {
    }

    @Override
    public void finishFileSession(UUID sessionID, Throwable dCause) {
        super.finishFileSession(sessionID, dCause);
        if (this.finishedSessions.size() == this.fileSessions.size()) {
            this.notifySessionFinished();
        }
    }

    public void startReading() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Started DiskReaderTasks for the following partions [ ");
        int idx = 0;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, " partitionsMap is: " + this.partitionsMap);
        }
        for (Map.Entry entry : this.partitionsMap.entrySet()) {
            int partitionID = (Integer)entry.getKey();
            LinkedList files = (LinkedList)entry.getValue();
            int realReadersCount = this.readersCount < files.size() ? this.readersCount : files.size();
            ArrayList<DiskReaderTask> readersTasks = new ArrayList<DiskReaderTask>(realReadersCount);
            ArrayList<LinkedList> fileSessionsReaders = new ArrayList<LinkedList>(realReadersCount);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, " realReadersCount = " + realReadersCount + " for partitionID: " + partitionID);
            }
            if (realReadersCount > 1) {
                Object[] filesArray = files.toArray(new FileSession[files.size()]);
                Arrays.sort(filesArray, new FileSessionComparator());
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Sorted FileSession-s array: " + Arrays.toString(filesArray));
                }
                int ci = 0;
                for (Object fs : filesArray) {
                    LinkedList<Object> fsessions;
                    LinkedList<Object> linkedList = fsessions = ci >= fileSessionsReaders.size() ? null : (LinkedList<Object>)fileSessionsReaders.get(ci);
                    if (fsessions == null) {
                        fsessions = new LinkedList<Object>();
                        fileSessionsReaders.add(fsessions);
                    }
                    fsessions.add(fs);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, " Added FileSession: " + fs + " for DiskReaderTask idx =  " + ci);
                    }
                    ci = (ci + 1) % realReadersCount;
                }
            } else {
                fileSessionsReaders.add(files);
            }
            this.execService = Utils.getStandardExecService("DiskReaderTask for " + this.toString(), this.partitionsMap.size(), this.partitionsMap.size() * realReadersCount + 5, 5);
            for (int i = 0; i < realReadersCount; ++i) {
                DiskReaderTask drTask = new DiskReaderTask(partitionID, idx++, (List)fileSessionsReaders.get(i), this);
                readersTasks.add(drTask);
                this.execService.submit(drTask);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, " ReadersTasks for partitionID: " + partitionID + ": " + readersTasks);
            }
            this.readersMap.put(partitionID, readersTasks);
            sb.append(partitionID).append(" ");
        }
        sb.append("] for FDTSession: ").append(this.sessionID);
        logger.log(Level.INFO, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPostProcessing() throws Exception {
        if (!this.postProcessingDone.compareAndSet(false, true)) {
            return false;
        }
        long sTime = System.nanoTime();
        int filtersCount = 0;
        try {
            logger.log(Level.INFO, "[ FDTReaderSession ] Post Processing started");
            String postProcessFiltersProp = config.getPostFilters();
            if (postProcessFiltersProp == null || postProcessFiltersProp.length() == 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, " [ FDTReaderSession ] No FDT PostProcessor Filters defined");
                }
            } else {
                String[] postProcessFilters = postProcessFiltersProp.split(",");
                if (postProcessFilters == null || postProcessFilters.length == 0) {
                    logger.log(Level.WARNING, "Cannot understand -postFilters");
                } else {
                    filtersCount = postProcessFilters.length;
                    for (String filterName : postProcessFilters) {
                        Postprocessor preprocessor = (Postprocessor)Class.forName(filterName).newInstance();
                        preprocessor.postProcessFileList(this.processorInfo, this.controlChannel.subject, this.downCause(), this.downMessage());
                    }
                }
            }
        }
        finally {
            StringBuffer sb = new StringBuffer();
            if (filtersCount > 0) {
                sb.append("[ FDTReaderSession ] Postprocessing: ").append(filtersCount).append(" filters in ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - sTime)).append(" ms");
            } else {
                sb.append("[ FDTReaderSession ] No post processing filters defined/processed.");
            }
            logger.log(Level.INFO, sb.toString());
        }
        return filtersCount > 0;
    }

    private void notifySessionFinished() {
        if (this.finishNotifiedExecuted.compareAndSet(false, true)) {
            StringBuilder downNotif;
            block8: {
                downNotif = null;
                try {
                    if (this.downMessage() != null && this.downCause() != null) {
                        downNotif = new StringBuilder();
                        if (this.downMessage() != null) {
                            downNotif.append("Down message: ").append(this.downMessage()).append("\n");
                        }
                        if (this.downCause() != null) {
                            downNotif.append("Down cause:\n").append(Utils.getStackTrace(this.downCause())).append("\n");
                        }
                    }
                }
                catch (Throwable t1) {
                    if (!logger.isLoggable(Level.FINE)) break block8;
                    logger.log(Level.FINE, "[ FDTReaderSession ] [ notifySessionFinished ]  Got exception building the remote notify message", t1);
                }
            }
            try {
                this.controlChannel.sendCtrlMessage(new CtrlMsg(10, downNotif == null ? this.md5Sums : downNotif.toString()));
            }
            catch (Throwable t1) {
                logger.log(Level.WARNING, " [ FDTReaderSession ] [ notifySessionFinished ] got exception sending END_SESSION message", t1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void finalCleanup() {
        block55: {
            if (this.finalCleaupExecuted.compareAndSet(false, true)) {
                block54: {
                    block52: {
                        block51: {
                            block50: {
                                isFiner = FDTReaderSession.logger.isLoggable(Level.FINER);
                                isFine = isFiner != false || FDTReaderSession.logger.isLoggable(Level.FINE) != false;
                                try {
                                    sTime = System.nanoTime();
                                    while ((this.currentState() & 256) != 256) {
                                        block49: {
                                            try {
                                                Thread.sleep(1000L);
                                                this.notifySessionFinished();
                                            }
                                            catch (InterruptedException ie) {
                                                Thread.interrupted();
                                            }
                                            catch (Throwable t) {
                                                if (!isFine) break block49;
                                                FDTReaderSession.logger.log(Level.FINE, "[finalCleanup] exception notifying sessionFinished. Cause", t);
                                            }
                                        }
                                        if (!this.controlChannel.isSocketClosed()) {
                                            if (System.nanoTime() - sTime <= FDTReaderSession.END_RCV_WAIT_DELAY) continue;
                                            FDTReaderSession.logger.log(Level.WARNING, " Remote FDT Writer session went down since we finished reading. The session will finish");
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable t) {
                                    if (!isFine) break block50;
                                    FDTReaderSession.logger.log(Level.FINE, "[finalCleanup] exception notifying sessionFinished. Cause", t);
                                }
                            }
                            if (isFiner) {
                                FDTReaderSession.logger.log(Level.FINER, "\n\n\n [ FDTReaderSession ]  [ finalCleanup ]   EXECUTING !!!!!!!!!!! \n\n");
                            }
                            endDate = new Date();
                            nlrec = new NetloggerRecord();
                            nlrec.setBlock(DirectByteBufferPool.getInstance().getBufferSize());
                            nlrec.setBuffer(Math.max(0, FDTReaderSession.config.getSockBufSize()));
                            if (this.downCause() == null && this.downMessage() == null) {
                                nlrec.setCode("226");
                            } else {
                                nlrec.setCode("426");
                            }
                            nlrec.setCompleted(endDate);
                            nlrec.setDestination(this.controlChannel.remoteAddress);
                            try {
                                nlrec.setHost(InetAddress.getLocalHost());
                            }
                            catch (UnknownHostException t) {
                                // empty catch block
                            }
                            nlrec.setNbytes(this.getTotalBytes());
                            nlrec.setStart(new Date(this.startTimeMillis));
                            if (this.getTransportProvider() != null) {
                                nlrec.setStreams(this.getTransportProvider().getNumberOfStreams());
                            }
                            nlrec.setType("RETR");
                            FDTReaderSession.logger.info(nlrec.toULMString());
                            try {
                                sb = new StringBuilder();
                                sb.append("\n\nFDTReaderSession ( ").append(this.sessionID);
                                if (this.monID != null) {
                                    sb.append(" / ").append(this.monID);
                                }
                                sb.append(" ) final stats:");
                                sb.append("\n Started: ").append(new Date(this.startTimeMillis));
                                sb.append("\n Ended:   ").append(endDate);
                                period = System.nanoTime() - this.startTimeNanos;
                                sb.append("\n Transfer period:   ").append(Utils.getETA(TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.startTimeNanos)));
                                sb.append("\n TotalBytes: ").append(this.getTotalBytes());
                                if (this.transportProvider != null) {
                                    sb.append("\n TotalNetworkBytes: ").append(this.transportProvider.getUtilBytes());
                                    try {
                                        if (Utils.updateTotalReadCounter(this.transportProvider.getUtilBytes()) || !FDTReaderSession.logger.isLoggable(Level.FINEST)) ** GOTO lbl86
                                        FDTReaderSession.logger.log(Level.FINEST, " [ FDTReaderSession ] Unable to update the contor in the update file.");
                                    }
                                    catch (Throwable tu) {
                                        if (!FDTReaderSession.logger.isLoggable(Level.FINEST)) ** GOTO lbl86
                                        FDTReaderSession.logger.log(Level.FINEST, " [ FDTReaderSession ] Unable to update the contor in the update file. Cause: ", tu);
                                    }
                                    finally {
                                        this.transportProvider.close(this.downMessage(), this.downCause());
                                    }
                                } else {
                                    sb.append("\n TotalNetworkBytes: 0");
                                }
lbl86:
                                // 5 sources

                                sb.append("\n Exit Status: ").append(this.downCause() == null && this.downMessage() == null ? "OK" : "Not OK");
                                sb.append("\n");
                                FDTReaderSession.logger.info(sb.toString());
                                System.out.println(sb.toString());
                                if (FDTReaderSession.config.getMonitor().equals("OPENTSDB")) {
                                    monUtils = new MonitoringUtils(FDTReaderSession.config, this);
                                    monUtils.monitorEndStats(this.downCause() == null && this.downMessage() == null, this.getTotalBytes(), this.transportProvider.getUtilBytes(), this.startTimeMillis, endDate.getTime(), period, "Readers");
                                }
                            }
                            catch (Throwable t) {
                                FDTReaderSession.logger.log(Level.WARNING, "[ FDTReaderSession ] [ finalCleanup ] [ HANDLED ] Exception getting final statistics. Smth went dreadfully wrong!", t);
                            }
                            try {
                                for (FileSession fileSession : this.fileSessions.values()) {
                                    try {
                                        fileSession.close(this.downMessage(), this.downCause());
                                    }
                                    catch (Throwable ign) {
                                        if (!isFiner) continue;
                                        FDTReaderSession.logger.log(Level.FINER, "finalCleanup - exception closing file. Cause: ", ign);
                                    }
                                }
                            }
                            catch (Throwable ignore) {
                                if (!isFiner) break block51;
                                FDTReaderSession.logger.log(Level.FINER, "finalCleanup - exception closing files. Cause: ", ignore);
                            }
                        }
                        try {
                            this.doPostProcessing();
                        }
                        catch (Throwable t) {
                            FDTReaderSession.logger.log(Level.WARNING, "\n [ FDTReaderSession ] Got exception in postProcessing", t);
                        }
                        try {
                            controlChannel = this.controlChannel;
                            if (controlChannel != null) {
                                controlChannel.close(this.downMessage(), this.downCause());
                            }
                        }
                        catch (Throwable ignore) {
                            if (!isFiner) break block52;
                            FDTReaderSession.logger.log(Level.FINER, "finalCleanup - exception closing control channel. Cause: ", ignore);
                        }
                    }
                    execService = this.execService;
                    if (execService != null) {
                        try {
                            execService.shutdown();
                            execService.awaitTermination(10L, TimeUnit.SECONDS);
                        }
                        catch (Throwable ignore) {
                            if (isFiner) {
                                FDTReaderSession.logger.log(Level.FINER, "finalCleanup - exception closing executor service. Cause: ", ignore);
                            }
                        }
                        finally {
                            execService.shutdownNow();
                        }
                    }
                    try {
                        FDTReaderSession.diskManager.removeSession(this, this.downMessage(), this.downCause());
                    }
                    catch (Throwable ignore) {
                        if (!isFiner) break block54;
                        FDTReaderSession.logger.log(Level.FINER, "finalCleanup - exception removing session from diskManager. Cause: ", ignore);
                    }
                }
                try {
                    retBufs = Utils.drainFileBlockQueue(this.fileBlockQueue);
                    if (isFiner) {
                        FDTReaderSession.logger.log(Level.FINER, "finalCleanup - recovered " + retBufs + " buffers");
                    }
                }
                catch (Throwable t) {
                    FDTReaderSession.logger.log(Level.WARNING, "\n\n [ FDTReaderSession ] [ HANDLED ] exception returning buffers to pool \n\n ", t);
                }
                try {
                    FDTSessionManager.getInstance().finishSession(this.sessionID, this.downMessage(), this.downCause());
                }
                catch (Throwable ignore) {
                    if (!isFiner) break block55;
                    FDTReaderSession.logger.log(Level.FINER, "finalCleanup - exception closing session in FDTSessionManager. Cause: ", ignore);
                }
            }
        }
    }

    @Override
    protected void internalClose() throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, " [ FDTReaderSession ] enters internalClose downMsg: " + this.downMessage() + " ,  downCause: " + this.downCause());
        }
        try {
            super.internalClose();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, " [ FDTReaderSession ] [ HANDLED ] internalClose exception in base class.", t);
        }
        String downMessage = this.downMessage();
        Throwable downCause = this.downCause();
        if (downMessage != null || downCause != null) {
            String downLogMsg = downMessage == null ? "N/A" : downMessage;
            logger.log(Level.INFO, "\nThe FDTReaderSession ( " + this.sessionID + " ) finished with error(s). downMsg: " + downLogMsg + " downCause:", this.downCause());
            try {
                this.finalCleanup();
            }
            catch (Throwable t) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "[internalClose] Exception in finalCleanup. Cause: ", t);
                }
            }
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    FDTReaderSession.this.finalCleanup();
                }
            };
            Utils.getMonitoringExecService().schedule(r, 3L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void handleInitFDTSessionConf(CtrlMsg ctrlMsg) throws Exception {
        FDTSessionConfigMsg sccm = (FDTSessionConfigMsg)ctrlMsg.message;
        this.remoteDir = sccm.destinationDir;
        this.recursive = sccm.recursive;
        this.internalInit(sccm.fileLists, sccm.remappedFileLists);
    }

    @Override
    public void handleFinalFDTSessionConf(CtrlMsg ctrlMsg) throws Exception {
        UUID[] finishedSessions;
        if (!(ctrlMsg.message instanceof UUID[])) {
            FDTProcolException fpe = new FDTProcolException("Illegal message FINAL_FDT_CONF in ReaderSesssion without UUID[] as atttach. " + ctrlMsg.message);
            fpe.fillInStackTrace();
            throw fpe;
        }
        for (UUID fSession : finishedSessions = (UUID[])ctrlMsg.message) {
            FileSession fs = (FileSession)this.fileSessions.get(fSession);
            if (fs != null) {
                this.addAndGetUtilBytes(fs.sessionSize);
                this.addAndGetTotalBytes(fs.sessionSize);
            } else {
                logger.log(Level.WARNING, " No such UUID: " + fSession + " received from remote FDTWriterSession in local fileSessions list");
            }
            this.finishFileSession(fSession, null);
        }
    }

    @Override
    public void handleEndFDTSession(CtrlMsg ctrlMsg) throws Exception {
        String string;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\n\n\n\n\n\n ---------------- [ FDTReaderSession ] handleEndFDTSession. Msg: " + ctrlMsg.message);
        }
        String remoteDownMsg = null;
        try {
            if (ctrlMsg.message != null && ctrlMsg.message instanceof String) {
                remoteDownMsg = (String)ctrlMsg.message;
                this.close(remoteDownMsg, null);
                logger.log(Level.WARNING, "\n\n [ FDTReaderSession ] Remote FDTWriterSession for session [ " + this.sessionID + " ] finished with errors:\n" + remoteDownMsg + "\n");
            } else {
                logger.log(Level.INFO, "[ FDTReaderSession ] Remote FDTWriterSession for session [ " + this.sessionID + " ] finished OK!");
                this.close(null, null);
            }
            string = remoteDownMsg != null ? remoteDownMsg : this.downMessage();
        }
        catch (Throwable throwable) {
            this.close(remoteDownMsg != null ? remoteDownMsg : this.downMessage(), this.downCause());
            throw throwable;
        }
        this.close(string, this.downCause());
    }

    @Override
    public void handleStartFDTSession(CtrlMsg ctrlMsg) throws Exception {
        if (ctrlMsg.tag == 15) {
            this.transferPort = (Integer)ctrlMsg.message;
        }
        boolean sendCookie = true;
        if (this.role == 1) {
            sendCookie = false;
            this.transportProvider = new TCPSessionWriter(this, InetAddress.getByName(config.getHostName()), this.transferPort, config.getSockNum());
        } else {
            this.transportProvider = new TCPSessionWriter(this);
        }
        config.registerTransferPortForSession(this.transferPort, this.sessionID.toString());
        this.controlChannel.sendCtrlMessage(new CtrlMsg(9, this.transferPort));
        this.setCurrentState(32);
        if (config.getMonitor().equals("OPENTSDB")) {
            MonitoringUtils monUtils = new MonitoringUtils(config, this);
            monUtils.monitorStart(System.currentTimeMillis(), "Readers");
        }
        this.startReading();
        this.setCurrentState(128);
        this.transportProvider.startTransport(sendCookie);
    }

    @Override
    public void transportWorkerDown() throws Exception {
        this.close("wroker down", null);
    }

    @Override
    public FileBlock take() throws InterruptedException {
        FileBlock fb = null;
        for (int i = 0; i < MAX_TAKE_POLL_ITER; ++i) {
            fb = (FileBlock)this.fileBlockQueue.poll();
            if (fb == null) continue;
            return fb;
        }
        fb = this.fileBlockQueue.take();
        if (fb != null) {
            ++this.totalFileBlocks;
        }
        return fb;
    }

    @Override
    public FileBlock poll() {
        FileBlock fb = (FileBlock)this.fileBlockQueue.poll();
        if (fb != null) {
            ++this.totalFileBlocks;
        }
        return fb;
    }

    @Override
    public FileBlock poll(long delay, TimeUnit unit) throws InterruptedException {
        FileBlock fb = null;
        fb = this.fileBlockQueue.poll(delay, unit);
        if (fb != null) {
            ++this.totalFileBlocks;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, " Polling for FileBlock qSize: " + this.fileBlockQueue.size() + " processedFBS: " + this.totalFileBlocks);
        }
        return fb;
    }

    private static class FileSessionComparator
    implements Comparator<FileSession> {
        private FileSessionComparator() {
        }

        @Override
        public int compare(FileSession fileSession1, FileSession fileSession2) {
            logger.log(Level.FINEST, "[ FileSessionComparator ] Comparing " + fileSession1.fileName + " and " + fileSession2.fileName);
            if (fileSession1.fileName.equals(fileSession2.fileName)) {
                if (fileSession1.sessionSize < fileSession2.sessionSize) {
                    logger.log(Level.FINEST, "[ FileSessionComparator ] Comparing session  size " + fileSession1.sessionSize + " and " + fileSession2.sessionSize);
                    return -1;
                }
                if (fileSession1.file.length() < fileSession2.file.length()) {
                    logger.log(Level.FINEST, "[ FileSessionComparator ] Comparing file size " + fileSession1.file.length() + " and " + fileSession2.file.length());
                    return -1;
                }
            }
            logger.log(Level.FINEST, "[ FileSessionComparator ] Return 1");
            return 1;
        }
    }
}

