/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.AbstractFDTCloseable;
import lia.util.net.common.Config;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTReaderSession;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.FDTWriterSession;
import lia.util.net.copy.transport.ControlChannel;
import lia.util.net.copy.transport.ControlChannelNotifier;
import lia.util.net.copy.transport.FDTProcolException;

public class FDTSessionManager
extends AbstractFDTCloseable
implements ControlChannelNotifier {
    private static final Logger logger = Logger.getLogger(FDTSessionManager.class.getName());
    private static final FDTSessionManager _thisInstanceManager = new FDTSessionManager();
    private static final Config config = Config.getInstance();
    private final Map<UUID, FDTSession> fdtSessionMap;
    private final Lock lock = new ReentrantLock();
    private final Condition isSessionMapEmpty = this.lock.newCondition();
    private final AtomicBoolean inited;
    private volatile String lastDownMsg;
    private volatile Throwable lastDownCause;

    private FDTSessionManager() {
        this.fdtSessionMap = new ConcurrentHashMap<UUID, FDTSession>();
        this.inited = new AtomicBoolean(false);
    }

    public static FDTSessionManager getInstance() {
        return _thisInstanceManager;
    }

    public void addFDTClientSession(ControlChannel controlChannel) throws Exception {
        FDTSession fdtSession = null;
        try {
            if (controlChannel.remoteConf.get("-pull") != null) {
                fdtSession = new FDTReaderSession(controlChannel);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, " Adding FDTReaderSession ( " + fdtSession.sessionID + " ) to the FDTSessionManager");
                }
            } else {
                fdtSession = new FDTWriterSession(controlChannel);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, " Adding FDTWriterSession ( " + fdtSession.sessionID + " ) to the FDTSessionManager");
                }
            }
            this.fdtSessionMap.put(fdtSession.sessionID(), fdtSession);
            this.inited.set(true);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, " Got exception instantiate Session/RemoteConn ", t);
            Utils.closeIgnoringExceptions(fdtSession, "Exception instantiate Session/RemoteConn", t);
            Utils.closeIgnoringExceptions(controlChannel, "Exception instantiate Session/RemoteConn", t);
            throw new Exception(t);
        }
    }

    public FDTSession addFDTClientSession(int transferPort) throws Exception {
        FDTSession fdtSession = null;
        try {
            fdtSession = config.isPullMode() ? new FDTWriterSession(transferPort) : new FDTReaderSession(transferPort);
            this.fdtSessionMap.put(fdtSession.sessionID(), fdtSession);
            this.inited.set(true);
            fdtSession.startControlThread();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Got exception initiation Session/RemoteConn ", t);
            Utils.closeIgnoringExceptions(fdtSession, "Got exception initiation Session/RemoteConn ", t);
            throw new Exception(t);
        }
        return fdtSession;
    }

    public int sessionsNumber() {
        return this.fdtSessionMap.size();
    }

    public boolean isInited() {
        return this.inited.get();
    }

    public FDTSession getSession(UUID fdtSessionID) {
        return this.fdtSessionMap.get(fdtSessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishSession(UUID fdtSessionID, String downMessage, Throwable downCause) {
        FDTSession fdtSession = this.fdtSessionMap.remove(fdtSessionID);
        logger.log(Level.FINER, " FDTSessionManager removed sessionID " + fdtSessionID + "; removed == " + (fdtSession != null) + " new size: " + this.fdtSessionMap.size());
        if (this.fdtSessionMap.size() == 0) {
            this.lock.lock();
            try {
                this.lastDownMsg = downMessage;
                this.lastDownCause = downCause;
                this.isSessionMapEmpty.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        if (fdtSession == null) {
            return false;
        }
        return fdtSession.close(downMessage, downCause);
    }

    public void addWorker(UUID fdtSessionID, SocketChannel sc) throws Exception {
        FDTSession fdtSession = this.fdtSessionMap.get(fdtSessionID);
        if (fdtSession != null) {
            fdtSession.transportProvider.addWorkerStream(sc, true);
        } else {
            logger.log(Level.WARNING, "\n\n [ FDTSessionManager ] No such session " + fdtSessionID + " for worker: " + sc + ". The channel will be closed");
            Utils.closeIgnoringExceptions(sc);
        }
    }

    @Override
    public void notifyCtrlMsg(ControlChannel controlChannel, Object o) throws FDTProcolException {
        if (controlChannel == null) {
            throw new NullPointerException("ControlChannel cannot be null in notifier!");
        }
        FDTSession fdtSession = this.fdtSessionMap.get(controlChannel.fdtSessionID());
        if (fdtSession == null) {
            throw new FDTProcolException("No FDTSession for ID: " + controlChannel.fdtSessionID());
        }
        fdtSession.notifyCtrlMsg(controlChannel, o);
    }

    public void awaitTermination() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.fdtSessionMap.size() > 0) {
                this.isSessionMapEmpty.await(5L, TimeUnit.SECONDS);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, " waiting for [ " + this.fdtSessionMap.size() + " ] sessions to finish. -> " + Arrays.toString(this.fdtSessionMap.keySet().toArray(new UUID[0])));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Throwable getLasDownCause() {
        this.lock.lock();
        try {
            Throwable throwable = this.lastDownCause;
            return throwable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getLasDownMessage() {
        this.lock.lock();
        try {
            String string = this.lastDownMsg;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void notifyCtrlSessionDown(ControlChannel controlChannel, Throwable cause) {
        FDTSession fdtSession = this.fdtSessionMap.get(controlChannel.fdtSessionID());
        if (fdtSession != null) {
            fdtSession.notifyCtrlSessionDown(controlChannel, cause);
        }
    }

    @Override
    protected void internalClose() throws Exception {
    }
}

