/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import lia.util.net.common.FileChannelProvider;
import lia.util.net.common.FileChannelProviderFactory;
import lia.util.net.copy.FDTReaderSession;
import lia.util.net.copy.FDTWriterSession;
import lia.util.net.copy.PartitionMap;

public class PosixFSFileChannelProviderFactory
implements FileChannelProviderFactory {
    private final FileChannelProvider readerFileChannelProvider = new PosixFSReaderFileChannelProvider();
    private final FileChannelProvider writerFileChannelProvider = new PosixFSWriterFileChannelProvider();
    private final FileChannelProvider coordinatorChannelProvider = new PosixFSCoordinatorChannelProvider();

    @Override
    public FileChannelProvider newReaderFileChannelProvider(FDTReaderSession readerSession) {
        return this.readerFileChannelProvider;
    }

    @Override
    public FileChannelProvider newWriterFileChannelProvider(FDTWriterSession writerSession) {
        return this.writerFileChannelProvider;
    }

    private static final class PosixFSCoordinatorChannelProvider
    implements FileChannelProvider {
        private PosixFSCoordinatorChannelProvider() {
        }

        @Override
        public File getFile(String fileName) throws IOException {
            return new File(fileName);
        }

        @Override
        public int getPartitionID(File file) throws IOException {
            if (file.exists()) {
                return PartitionMap.getPartitionFromCache(file);
            }
            return PartitionMap.getPartitionFromCache(file.getParentFile());
        }

        @Override
        public FileChannel getFileChannel(File file, String openMode) throws IOException {
            if (openMode != null) {
                return new RandomAccessFile(file, openMode).getChannel();
            }
            return new FileOutputStream(file).getChannel();
        }
    }

    private static final class PosixFSWriterFileChannelProvider
    implements FileChannelProvider {
        private PosixFSWriterFileChannelProvider() {
        }

        @Override
        public File getFile(String fileName) throws IOException {
            return new File(fileName);
        }

        @Override
        public int getPartitionID(File file) throws IOException {
            if (file.exists()) {
                return PartitionMap.getPartitionFromCache(file);
            }
            return PartitionMap.getPartitionFromCache(file.getParentFile());
        }

        @Override
        public FileChannel getFileChannel(File file, String openMode) throws IOException {
            if (openMode != null) {
                return new RandomAccessFile(file, openMode).getChannel();
            }
            return new FileOutputStream(file).getChannel();
        }
    }

    private static final class PosixFSReaderFileChannelProvider
    implements FileChannelProvider,
    Serializable {
        private PosixFSReaderFileChannelProvider() {
        }

        @Override
        public File getFile(String fileName) throws IOException {
            return new File(fileName);
        }

        @Override
        public int getPartitionID(File file) throws IOException {
            return PartitionMap.getPartitionFromCache(file);
        }

        @Override
        public FileChannel getFileChannel(File file, String openMode) throws IOException {
            return new FileInputStream(file).getChannel();
        }
    }
}

