/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.HeaderBufferPool;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.FDTSessionManager;
import lia.util.net.copy.gui.FDTPropsDialog;
import lia.util.net.copy.monitoring.ConsoleReportingTask;
import lia.util.net.copy.monitoring.FDTInternalMonitoringTask;
import lia.util.net.copy.monitoring.FDTSessionMonitoringTask;
import lia.util.net.copy.transport.TCPTransportProvider;

public class ClientSessionManager {
    static final transient Logger logger = Logger.getLogger(ClientSessionManager.class.getCanonicalName());
    private static final long KILO_BIT = 1000L;
    private static final long MEGA_BIT = 1000000L;
    private static final long GIGA_BIT = 1000000000L;
    private static final long TERA_BIT = 1000000000000L;
    private static final long PETA_BIT = 1000000000000000L;
    private static final NumberFormat nf = NumberFormat.getInstance();
    private FDTSession currentSession;
    private FDTSessionMonitoringTask fdtSessionMTask;
    private RunnableScheduledFuture fdtInternalMonitoringTask = null;
    private RunnableScheduledFuture consoleReporting = null;

    private static final String formatNetSpeed(double number, String append) {
        String appendUM;
        double fNo = number;
        if (number > 1.0E15) {
            fNo /= 1.0E15;
            appendUM = "P" + append;
        } else if (number > 1.0E12) {
            fNo /= 1.0E12;
            appendUM = "T" + append;
        } else if (number > 1.0E9) {
            fNo /= 1.0E9;
            appendUM = "G" + append;
        } else if (number > 1000000.0) {
            fNo /= 1000000.0;
            appendUM = "M" + append;
        } else if (number > 1000.0) {
            fNo /= 1000.0;
            appendUM = "K" + append;
        } else {
            appendUM = append;
        }
        return nf.format(fNo) + " " + appendUM;
    }

    public String initTransfer(String host, int port, boolean isPullMode, String[] fileList, String destDir, FDTPropsDialog d, boolean isRecursive) {
        this.constructConfig(host, port, isPullMode, fileList, destDir, d, isRecursive);
        HeaderBufferPool.initInstance();
        this.fdtInternalMonitoringTask = (RunnableScheduledFuture)Utils.getMonitoringExecService().scheduleWithFixedDelay(FDTInternalMonitoringTask.getInstance(), 1L, 5L, TimeUnit.SECONDS);
        this.consoleReporting = (RunnableScheduledFuture)Utils.getMonitoringExecService().scheduleWithFixedDelay(ConsoleReportingTask.getInstance(), 1L, 2L, TimeUnit.SECONDS);
        try {
            this.currentSession = FDTSessionManager.getInstance().addFDTClientSession(port);
            this.fdtSessionMTask = this.currentSession.getMonitoringTask();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Got exception when initiating transfer", t);
            return t.getLocalizedMessage();
        }
        return null;
    }

    public FDTSession currentSession() {
        return this.currentSession;
    }

    public void cancelTransfer() {
        if (this.currentSession == null) {
            return;
        }
        this.currentSession.close("User pressed cancel", new Exception("User pressed cancel"));
        this.currentSession = null;
        this.fdtSessionMTask = null;
    }

    public void end() {
        if (this.fdtInternalMonitoringTask != null) {
            Utils.getMonitoringExecService().remove(this.fdtInternalMonitoringTask);
            this.fdtInternalMonitoringTask = null;
        }
        if (this.consoleReporting != null) {
            Utils.getMonitoringExecService().remove(this.consoleReporting);
            this.consoleReporting = null;
        }
        Utils.getMonitoringExecService().purge();
    }

    public double transferProgress() {
        if (this.currentSession == null) {
            return 100.0;
        }
        TCPTransportProvider tcpTransportProvider = this.currentSession.getTransportProvider();
        if (tcpTransportProvider == null) {
            return 0.0;
        }
        if (tcpTransportProvider.isClosed()) {
            logger.warning("Transport is closed");
            return 100.0;
        }
        double tSize = this.currentSession.getSize();
        long tcpSize = tcpTransportProvider.getUtilBytes();
        double cSize = tcpSize <= 0L ? 0.0 : (double)tcpSize;
        double percent = 100.0;
        try {
            percent = Math.min(cSize * 100.0 / tSize, 100.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Double.isNaN(percent) && !Double.isInfinite(percent) && percent >= 100.0) {
            try {
                boolean endSnt;
                int state = this.currentSession.currentState();
                boolean endRcv = (state & 0x100) == 256;
                boolean bl = endSnt = (state & 0x100) == 256;
                if ((state & 0x80) == 128 || !endRcv && !endSnt) {
                    return 99.99;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return percent;
    }

    public String currentSpeed() {
        if (this.currentSession == null) {
            return "0.0 b/s";
        }
        try {
            if (this.currentSession.getTransportProvider() != null && this.currentSession.getTransportProvider().isClosed()) {
                logger.warning("Transport is closed");
                return "0.0 b/s";
            }
            double rate = this.currentSession.getTransportProvider().monitoringTask.getTotalRate() * 8.0;
            return ClientSessionManager.formatNetSpeed(rate, "b/s");
        }
        catch (Throwable t) {
            return "0.0 b/s";
        }
    }

    private final void constructConfig(String host, int port, boolean isPullMode, String[] fileList, String destDir, FDTPropsDialog d, boolean isRecursive) {
        Field f5;
        Field f22;
        Class<Config> c = Config.class;
        try {
            Config.initInstance(new HashMap<String, Object>());
        }
        catch (Throwable t1) {
            t1.printStackTrace();
        }
        Config conf = Config.getInstance();
        try {
            conf.setHostName(host);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            f22 = c.getDeclaredField("portNo");
            f22.setAccessible(true);
            f22.set(conf, port);
        }
        catch (Throwable f22) {
            // empty catch block
        }
        try {
            conf.setPullMode(isPullMode);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            f22 = c.getDeclaredField("fileList");
            f22.setAccessible(true);
            f22.set(conf, fileList);
        }
        catch (Throwable f3) {
            // empty catch block
        }
        try {
            f22 = c.getDeclaredField("destDir");
            f22.setAccessible(true);
            f22.set(conf, destDir);
        }
        catch (Throwable f4) {
            // empty catch block
        }
        System.out.println("hostname = " + conf.getHostName());
        System.out.println("port = " + conf.getPort());
        String[] files = conf.getFileList();
        for (int i = 0; i < files.length; ++i) {
            System.out.println(files[i]);
        }
        System.out.println("dest = " + conf.getDestinationDir());
        System.out.println("isPull=" + conf.isPullMode());
        if (d == null) {
            return;
        }
        try {
            f5 = c.getDeclaredField("sockBufSize");
            f5.setAccessible(true);
            f5.set(conf, d.getSockBufSize());
        }
        catch (Throwable f5) {
            // empty catch block
        }
        try {
            f5 = c.getDeclaredField("sockNum");
            f5.setAccessible(true);
            f5.set(conf, d.getSockNum());
        }
        catch (Throwable f6) {
            // empty catch block
        }
        try {
            f5 = c.getDeclaredField("rateLimit");
            f5.setAccessible(true);
            f5.set(conf, d.getRateLimit());
        }
        catch (Throwable f7) {
            // empty catch block
        }
        try {
            f5 = c.getDeclaredField("readersCount");
            f5.setAccessible(true);
            f5.set(conf, d.getReadersCount());
        }
        catch (Throwable f8) {
            // empty catch block
        }
        try {
            f5 = c.getDeclaredField("writersCount");
            f5.setAccessible(true);
            f5.set(conf, d.getWritersCount());
        }
        catch (Throwable f9) {
            // empty catch block
        }
        try {
            f5 = c.getDeclaredField("maxPartitionsCount");
            f5.setAccessible(true);
            f5.set(conf, d.getMaxPartitionsCount());
        }
        catch (Throwable f10) {
            // empty catch block
        }
        try {
            f5 = c.getDeclaredField("bComputeMD5");
            f5.setAccessible(true);
            f5.set(conf, d.isBComputeMD5());
        }
        catch (Throwable f11) {
            // empty catch block
        }
        try {
            f5 = c.getDeclaredField("bRecursive");
            f5.setAccessible(true);
            f5.set(conf, isRecursive);
        }
        catch (Throwable f12) {
            // empty catch block
        }
        try {
            f5 = c.getDeclaredField("bUseFixedBlocks");
            f5.setAccessible(true);
            f5.set(conf, d.isBUseFixedBlocks());
        }
        catch (Throwable f13) {
            // empty catch block
        }
        try {
            f5 = c.getDeclaredField("transferLimit");
            f5.setAccessible(true);
            f5.set(conf, d.getTransferLimit());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        nf.setMaximumFractionDigits(2);
    }
}

