/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.disk.DiskReaderManager;
import lia.util.net.copy.disk.DiskWriterManager;
import lia.util.net.copy.monitoring.base.AbstractAccountableMonitoringTask;
import lia.util.net.copy.transport.TCPTransportProvider;

public class ConsoleReportingTask
extends AbstractAccountableMonitoringTask {
    private static final Logger logger = Logger.getLogger(ConsoleReportingTask.class.getName());
    private static final DiskWriterManager diskWriterManager = DiskWriterManager.getInstance();
    private static final DiskReaderManager diskReaderManager = DiskReaderManager.getInstance();
    private static final ConsoleReportingTask thisInstace = new ConsoleReportingTask();
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM HH:mm:ss");
    private final Set<FDTSession> oldReaderSessions = new TreeSet<FDTSession>();
    private final Set<FDTSession> oldWriterSessions = new TreeSet<FDTSession>();
    private final boolean customLog;

    private ConsoleReportingTask() {
        super(null);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\n\n  [ ConsoleReportingTask ] initiated !!!! \n\n");
        }
        this.customLog = Utils.isCustomLog();
    }

    public static final ConsoleReportingTask getInstance() {
        return thisInstace;
    }

    private final boolean reportStatus(Set<FDTSession> currentSessionSet, Set<FDTSession> oldSessionSet, String tag, StringBuilder sb) {
        boolean shouldReport = false;
        if (oldSessionSet.size() > 0) {
            double totalReadRate = 0.0;
            boolean reportMultipleSessions = false;
            if (oldSessionSet.size() > 1) {
                reportMultipleSessions = true;
                sb.append(oldSessionSet.size()).append(" active sessions:");
            }
            Iterator<FDTSession> it = oldSessionSet.iterator();
            while (it.hasNext()) {
                FDTSession fdtSession = it.next();
                TCPTransportProvider tcpTransportProvider = fdtSession.getTransportProvider();
                if (!currentSessionSet.contains(fdtSession)) {
                    if (tcpTransportProvider == null) {
                        logger.log(Level.WARNING, " [ ConsoleReportingTask ] The session: " + fdtSession.sessionID() + " is no longer available, but canot remove trasport provider from monitoring queue. It's probably a BUG in FDT");
                        continue;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, " [ ConsoleReportingTask ]  Removing tcpTransportProvider " + tcpTransportProvider + " for session: " + fdtSession.sessionID());
                    }
                    this.remove(tcpTransportProvider);
                    it.remove();
                    continue;
                }
                if (tcpTransportProvider == null || this.getMonCount(tcpTransportProvider) == 0L) continue;
                double totalRate = this.getTotalRate(tcpTransportProvider);
                double avgTotalRate = this.getAvgTotalRate(tcpTransportProvider);
                shouldReport = true;
                totalReadRate += totalRate;
                if (reportMultipleSessions) {
                    sb.append("\n").append(fdtSession.sessionID());
                }
                sb.append(tag).append(Utils.formatWithBitFactor(8.0 * totalRate, 0L, "/s")).append("\tAvg: ").append(Utils.formatWithBitFactor(8.0 * avgTotalRate, 0L, "/s"));
                long dtMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - fdtSession.startTimeNanos);
                if (fdtSession.getSize() <= 0L || dtMillis <= 20000L) continue;
                long tcpSize = tcpTransportProvider.getUtilBytes();
                double d = tcpSize <= 0L ? 0.0 : (double)tcpSize;
                double cSize = d;
                if (!(cSize > 0.0)) continue;
                double tSize = fdtSession.getSize() <= 0L ? 0.0 : (double)fdtSession.getSize();
                sb.append(" ").append(Utils.percentDecimalFormat(cSize * 100.0 / tSize)).append("%");
                double remainingSeconds = ((double)fdtSession.getSize() - cSize) / avgTotalRate;
                sb.append(" ( ").append(Utils.getETA((long)remainingSeconds)).append(" )");
            }
            if (reportMultipleSessions) {
                sb.append("\nTotal ").append(tag).append(Utils.formatWithBitFactor(totalReadRate *= 8.0, 0L, "/s"));
            }
        }
        for (FDTSession fdtSession : currentSessionSet) {
            TCPTransportProvider tcpTransportProvider;
            if (oldSessionSet.contains(fdtSession) || (tcpTransportProvider = fdtSession.getTransportProvider()) == null) continue;
            if (this.addIfAbsent(tcpTransportProvider, logger.isLoggable(Level.FINER))) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, " [ ConsoleReportingTask ]  Adding tcpTransportProvider " + tcpTransportProvider + " for session: " + fdtSession.sessionID());
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, " [ ConsoleReportingTask ]  Unable to add tcpTransportProvider " + tcpTransportProvider + " for session: " + fdtSession.sessionID());
            }
            oldSessionSet.add(fdtSession);
        }
        return shouldReport;
    }

    private void reportStatus() {
        boolean shouldReport;
        StringBuilder sb = new StringBuilder(8192);
        boolean bl = shouldReport = this.reportStatus(diskWriterManager.getSessions(), this.oldWriterSessions, "Net In: ", sb) || this.reportStatus(diskReaderManager.getSessions(), this.oldReaderSessions, "Net Out: ", sb);
        if (shouldReport) {
            logger.info(sb.toString());
        }
    }

    @Override
    public void rateComputed() {
        try {
            this.reportStatus();
        }
        catch (Throwable t1) {
            logger.log(Level.WARNING, " [ ConsoleReportingTask ] Got exception while reporting", t1);
        }
    }
}

