/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lia.util.net.common.Config;
import lia.util.net.common.Utils;
import lia.util.net.copy.Accountable;
import lia.util.net.copy.disk.DiskReaderManager;
import lia.util.net.copy.monitoring.ClientTransportMonitorTask;
import lia.util.net.copy.monitoring.base.AbstractAccountableMonitoringTask;

public class DiskReaderManagerMonitoringTask
extends AbstractAccountableMonitoringTask {
    private static AtomicBoolean inited = new AtomicBoolean(false);
    Config config = Config.getInstance();

    public DiskReaderManagerMonitoringTask(DiskReaderManager drm) {
        super(new Accountable[]{drm});
    }

    @Override
    public void rateComputed() {
        if (inited.compareAndSet(false, true) && this.config.getHostName() != null && this.config.isLisaRestartEnabled() && !this.config.isLisaDisabled()) {
            Utils.getMonitoringExecService().scheduleWithFixedDelay(new ClientTransportMonitorTask(this), 6L, 6L, TimeUnit.SECONDS);
        }
        if (DiskReaderManager.getInstance().sessionsSize() == 0) {
            this.resetAllCounters();
        }
    }

    public double getTotalRate() {
        return this.getTotalRate(DiskReaderManager.getInstance());
    }
}

