/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport.gui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ConcurrentLinkedQueue;
import lia.util.net.common.AbstractFDTCloseable;
import lia.util.net.copy.transport.CtrlMsg;
import lia.util.net.copy.transport.FDTProcolException;
import lia.util.net.copy.transport.gui.GUIControlChannelNotifier;

public class GUIControlChannel
extends AbstractFDTCloseable
implements Runnable {
    public static final int CONNECT_TIMEOUT = 20000;
    private static final CtrlMsg versionMsg = new CtrlMsg(1, "0.26.3-2021-03-31");
    public final InetAddress remoteAddress;
    public final int remotePort;
    public final int localPort;
    private GUIControlChannelNotifier notifier;
    private Socket controlSocket;
    private ObjectOutputStream oos = null;
    private ObjectInputStream ois = null;
    private ConcurrentLinkedQueue<Object> qToSend = new ConcurrentLinkedQueue();

    public GUIControlChannel(String address, int port, GUIControlChannelNotifier notifier) throws Exception {
        this(InetAddress.getByName(address), port, notifier);
    }

    public GUIControlChannel(InetAddress inetAddress, int port, GUIControlChannelNotifier notifier) throws Exception {
        try {
            this.notifier = notifier;
            this.controlSocket = new Socket();
            this.controlSocket.connect(new InetSocketAddress(inetAddress, port), 20000);
            this.remoteAddress = inetAddress;
            this.remotePort = port;
            this.localPort = this.controlSocket.getLocalPort();
            this.controlSocket.setTcpNoDelay(true);
            this.controlSocket.getOutputStream().write(new byte[]{3});
            this.initStreams();
            this.controlSocket.setSoTimeout(1000);
        }
        catch (Throwable t) {
            this.close("Cannot instantiate ControlChannel", t);
            throw new Exception(t);
        }
    }

    public String toString() {
        return this.controlSocket == null ? "null" : this.controlSocket.toString();
    }

    private void initStreams() throws Exception {
        this.oos = new ObjectOutputStream(new BufferedOutputStream(this.controlSocket.getOutputStream()));
        this.sendMsgImpl(versionMsg);
        this.ois = new ObjectInputStream(new BufferedInputStream(this.controlSocket.getInputStream()));
        CtrlMsg ctrlMsg = (CtrlMsg)this.ois.readObject();
        if (ctrlMsg.tag != 1) {
            throw new FDTProcolException("Unexpected remote control message. Expected PROTOCOL_VERSION tag [ 1 ] Received tag: " + ctrlMsg.tag);
        }
        Object o = this.ois.readObject();
        this.notifier.notifyCtrlMsg(this, o);
        o = this.ois.readObject();
        this.notifier.notifyCtrlMsg(this, o);
        o = this.ois.readObject();
        this.notifier.notifyCtrlMsg(this, o);
        o = this.ois.readObject();
        this.notifier.notifyCtrlMsg(this, o);
        o = this.ois.readObject();
        this.notifier.notifyCtrlMsg(this, o);
    }

    private void cleanup() {
        if (this.ois != null) {
            try {
                this.ois.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.ois = null;
        }
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.oos = null;
        }
        if (this.controlSocket != null) {
            try {
                this.controlSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.controlSocket = null;
        }
    }

    public void sendCtrlMessage(Object ctrlMsg) throws IOException, FDTProcolException {
        if (this.isClosed() && this.controlSocket != null && !this.controlSocket.isClosed()) {
            throw new FDTProcolException("Control channel already closed");
        }
        this.qToSend.add(ctrlMsg);
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this.controlSocket == null || this.controlSocket.isClosed();
    }

    private void sendAllMsgs() throws Exception {
        Object ctrlMsg;
        while ((ctrlMsg = this.qToSend.poll()) != null) {
            this.sendMsgImpl(ctrlMsg);
        }
    }

    private void sendMsgImpl(Object o) throws Exception {
        try {
            this.oos.writeObject(o);
            this.oos.reset();
            this.oos.flush();
        }
        catch (Throwable t) {
            this.close("Exception sending control data", t);
            throw new IOException(" Cannot send ctrl message ( " + t.getCause() + " ) ");
        }
    }

    @Override
    public void run() {
        try {
            while (!this.isClosed()) {
                try {
                    this.sendAllMsgs();
                    Object o = this.ois.readObject();
                    if (o == null) continue;
                    this.notifier.notifyCtrlMsg(this, o);
                }
                catch (SocketTimeoutException o) {
                }
                catch (FDTProcolException fdte) {
                    this.close("FDTProtocolException", fdte);
                }
            }
        }
        catch (Throwable t) {
            this.close(null, t);
        }
    }

    @Override
    protected void internalClose() {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.notifier != null) {
                this.notifier.notifyCtrlSessionDown(this, this.downCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

