/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport.internal;

import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import lia.util.net.common.Utils;
import lia.util.net.copy.transport.FDTKeyAttachement;
import lia.util.net.copy.transport.internal.SelectionHandler;
import lia.util.net.copy.transport.internal.SelectionManager;

public class FDTSelectionKey {
    private static final SelectionManager selectionManager = SelectionManager.getInstance();
    protected final Selector selector;
    protected final SelectionManager.SelectionTask selectionTask;
    protected final SocketChannel channel;
    protected final UUID fdtSessionID;
    final SelectionHandler handler;
    final int interests;
    final AtomicBoolean canceled;
    final AtomicBoolean registered;
    final AtomicBoolean renewed;
    public int opCount;
    volatile SelectionKey selectionKey;
    int MSS = -1;
    private volatile FDTKeyAttachement attachment;

    FDTSelectionKey(UUID fdtSessionID, SocketChannel channel, int interests, SelectionHandler handler, FDTKeyAttachement attachement, Selector selector, SelectionManager.SelectionTask selectionTask) {
        this.channel = channel;
        this.interests = interests;
        this.handler = handler;
        this.renewed = new AtomicBoolean(false);
        this.canceled = new AtomicBoolean(false);
        this.registered = new AtomicBoolean(false);
        this.fdtSessionID = fdtSessionID;
        this.attachment = attachement;
        this.selector = selector;
        this.selectionTask = selectionTask;
    }

    public FDTSelectionKey(UUID fdtSessionID, SocketChannel channel, int interests, SelectionHandler handler, FDTKeyAttachement attachement, Selector selector) {
        this(fdtSessionID, channel, interests, handler, null, selector, null);
    }

    public FDTSelectionKey(UUID fdtSessionID, SocketChannel channel, int interests, SelectionHandler handler, Selector selector) {
        this(fdtSessionID, channel, interests, handler, null, selector);
    }

    public boolean registerInterest() {
        if (this.registered.compareAndSet(false, true)) {
            selectionManager.initialKeyRegister(this);
            return true;
        }
        return false;
    }

    public boolean renewInterest() {
        if (this.renewed.compareAndSet(false, true)) {
            this.opCount = 0;
            selectionManager.renewInterest(this);
            return true;
        }
        return false;
    }

    public boolean cancel() {
        if (this.canceled.compareAndSet(false, true)) {
            FDTKeyAttachement attach;
            SelectionKey selectionKey;
            try {
                this.channel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.handler != null) {
                try {
                    this.handler.canceled(this);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if ((selectionKey = this.selectionKey) != null) {
                try {
                    selectionKey.cancel();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (selectionKey.selector() != null) {
                        this.renewInterest();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((attach = this.attachment()) != null) {
                try {
                    attach.recycleBuffers();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return !this.canceled.get();
    }

    public SocketChannel channel() {
        return this.channel;
    }

    public final FDTKeyAttachement attach(FDTKeyAttachement attachement) {
        FDTKeyAttachement ret = this.attachment;
        this.attachment = attachement;
        return ret;
    }

    public UUID fdtSessionID() {
        return this.fdtSessionID;
    }

    public final FDTKeyAttachement attachment() {
        return this.attachment;
    }

    public int getMSS() {
        return this.MSS;
    }

    public void setMSS(int MSS) {
        this.MSS = MSS;
    }

    public Selector selector() {
        return this.selector;
    }

    public String toString() {
        return Utils.toStringSelectionKey(this);
    }
}

