/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.jsse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jsse.GlobusSSLConfigurationException;
import org.globus.gsi.stores.Stores;

public final class GlobusSSLHelper {
    private GlobusSSLHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore buildTrustStore(String provider, String trustAnchorStoreType, String trustAnchorStoreLocation, String trustAnchorStorePassword) throws GlobusSSLConfigurationException {
        try {
            KeyStore trustAnchorStore = provider == null ? KeyStore.getInstance(trustAnchorStoreType) : KeyStore.getInstance(trustAnchorStoreType, provider);
            InputStream keyStoreInput = GlobusSSLHelper.getStream(trustAnchorStoreLocation);
            try {
                trustAnchorStore.load(new BufferedInputStream(keyStoreInput), trustAnchorStorePassword == null ? null : trustAnchorStorePassword.toCharArray());
            }
            finally {
                keyStoreInput.close();
            }
            return trustAnchorStore;
        }
        catch (KeyStoreException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (IOException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (CertificateException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchProviderException e) {
            throw new GlobusSSLConfigurationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore findCredentialStore(String provider, String credentialStoreType, String credentialStoreLocation, String credentialStorePassword) throws GlobusSSLConfigurationException {
        try {
            KeyStore credentialStore = provider == null ? KeyStore.getInstance(credentialStoreType) : KeyStore.getInstance(credentialStoreType, provider);
            InputStream keyStoreInput = GlobusSSLHelper.getStream(credentialStoreLocation);
            try {
                credentialStore.load(new BufferedInputStream(keyStoreInput), credentialStorePassword == null ? null : credentialStorePassword.toCharArray());
            }
            finally {
                keyStoreInput.close();
            }
            return credentialStore;
        }
        catch (KeyStoreException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (IOException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (CertificateException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchProviderException e) {
            throw new GlobusSSLConfigurationException(e);
        }
    }

    private static InputStream getStream(String url) throws MalformedURLException, IOException {
        if (url.startsWith("classpath:")) {
            String resource = url.substring(10);
            URL u = ClassLoader.class.getResource(resource);
            if (u == null) {
                throw new MalformedURLException();
            }
            return u.openStream();
        }
        if (url.startsWith("file:")) {
            File f;
            URL u = new URL(url);
            try {
                f = new File(u.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(u.getPath());
            }
            return new FileInputStream(f);
        }
        return new URL(url).openStream();
    }

    public static CertStore findCRLStore(String crlPattern) throws GlobusSSLConfigurationException {
        try {
            return Stores.getCRLStore(crlPattern);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new GlobusSSLConfigurationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            Log logger = LogFactory.getLog(GlobusSSLHelper.class.getCanonicalName());
            logger.warn("Error Loading CRL store", e);
            throw new GlobusSSLConfigurationException(e);
        }
        catch (GeneralSecurityException e) {
            Log logger = LogFactory.getLog(GlobusSSLHelper.class.getCanonicalName());
            logger.warn("Error Loading CRL store", e);
            throw new GlobusSSLConfigurationException(e);
        }
    }
}

