/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.stores.SecurityObjectWrapper;
import org.globus.gsi.stores.Storable;
import org.globus.util.GlobusPathMatchingResourcePatternResolver;
import org.globus.util.GlobusResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceSecurityWrapper<T>
implements SecurityObjectWrapper<T>,
Storable {
    protected GlobusPathMatchingResourcePatternResolver globusResolver = new GlobusPathMatchingResourcePatternResolver();
    protected GlobusResource globusResource;
    private Log logger = LogFactory.getLog(this.getClass().getCanonicalName());
    private boolean changed;
    private T securityObject;
    private long lastModified = -1L;
    private long lastRefresh;
    private final long cacheLifetime;
    private String alias;
    private boolean inMemory = false;

    protected AbstractResourceSecurityWrapper(boolean inMemory) {
        this.inMemory = inMemory;
        this.cacheLifetime = CoGProperties.getDefault().getCertCacheLifetime();
    }

    protected void init(String locationPattern) throws ResourceStoreException {
        this.init(this.globusResolver.getResource(locationPattern));
    }

    protected void init(GlobusResource initialResource) throws ResourceStoreException {
        this.init(initialResource, this.create(initialResource));
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    protected void init(String locationPattern, T initialSecurityObject) throws ResourceStoreException {
        this.init(this.globusResolver.getResource(locationPattern), initialSecurityObject);
    }

    protected void init(GlobusResource initialResource, T initialSecurityObject) throws ResourceStoreException {
        if (initialSecurityObject == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        this.securityObject = initialSecurityObject;
        this.globusResource = initialResource;
        this.logger.debug(String.format("Loading initialResource: %s", this.globusResource.toString()));
        try {
            this.alias = this.globusResource.getURL().toExternalForm();
            if (!this.inMemory) {
                this.lastModified = this.globusResource.lastModified();
                this.lastRefresh = System.currentTimeMillis();
            }
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }

    public GlobusResource getGlobusResource() {
        return this.globusResource;
    }

    public URL getResourceURL() {
        try {
            return this.globusResource.getURL();
        }
        catch (IOException e) {
            this.logger.warn("Unable to extract url", e);
            return null;
        }
    }

    public File getFile() {
        try {
            return this.globusResource.getFile();
        }
        catch (IOException e) {
            this.logger.debug("Resource is not a file", e);
            return null;
        }
    }

    @Override
    public void refresh() throws ResourceStoreException {
        long now;
        if (!this.inMemory && this.lastRefresh + this.cacheLifetime < (now = System.currentTimeMillis())) {
            long latestLastModified;
            this.changed = false;
            try {
                latestLastModified = this.globusResource.lastModified();
            }
            catch (IOException e) {
                throw new ResourceStoreException(e);
            }
            if (this.lastModified < latestLastModified) {
                this.securityObject = this.create(this.globusResource);
                this.lastModified = latestLastModified;
                this.changed = true;
            }
            this.lastRefresh = now;
        }
    }

    protected abstract T create(GlobusResource var1) throws ResourceStoreException;

    @Override
    public T getSecurityObject() throws ResourceStoreException {
        this.refresh();
        return this.securityObject;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

