/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rl.esc.browser;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.encoders.Base64;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.X509Credential;
import org.globus.gsi.X509ExtensionSet;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.util.PEMUtils;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import uk.ac.rl.esc.browser.BouncyCastleCertProcessingFactoryProvider;
import uk.ac.rl.esc.browser.IECertificateInterface;

public class Browser {
    private static int idNumPKCS11 = 0;
    private static CertInfo theProfile = null;
    private static CertInfo[] lastset = null;
    private static String[] displayDNs = null;
    private static String[] realDNs = null;
    private static Log log = LogFactory.getLog(Browser.class);

    private Browser() {
    }

    private static CertInfo[] getProfiles() throws IOException, IllegalStateException {
        if (theProfile != null) {
            throw new IllegalStateException("You cannot change the browser profile once you have set it (within the life of the JVM).");
        }
        boolean windows = System.getProperty("os.name").startsWith("Windows");
        boolean linux = System.getProperty("os.name").startsWith("Linux");
        boolean mac = System.getProperty("os.name").startsWith("Mac OS");
        String homedir = System.getProperty("user.home");
        LinkedList<CertInfo> profiles = new LinkedList<CertInfo>();
        if (mac) {
            profiles.addFirst(new MacCertInfo());
        }
        if (linux) {
            File mozillaConfigDir;
            File libraryFirefox = null;
            File libraryMozilla = null;
            String firefoxPath = Browser.exec("which firefox");
            String mozillaPath = Browser.exec("which mozilla");
            String libBitwise = "lib";
            if (mozillaPath != null) {
                File mozillaLib;
                String realPath = Browser.exec("readlink /usr/bin/firefox");
                if (realPath.contains("lib64")) {
                    libBitwise = "lib64";
                }
                File mozillaBin = new File(mozillaPath);
                if ((mozillaBin = mozillaBin.getParentFile()) != null && mozillaBin.exists() && mozillaBin.getName().equals("bin") && (mozillaLib = new File(mozillaBin.getParent(), libBitwise)) != null && mozillaLib.exists()) {
                    File tmp = new File(mozillaLib, "libsoftokn3.so");
                    if (tmp != null && tmp.exists()) {
                        libraryMozilla = tmp;
                    } else {
                        mozillaLib = new File(mozillaBin.getParent(), String.valueOf(libBitwise) + "/nss");
                        tmp = new File(mozillaLib, "libsoftokn3.so");
                        if (tmp != null && tmp.exists()) {
                            libraryMozilla = tmp;
                        }
                    }
                }
            }
            FilenameFilter fnf = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("firefox");
                }
            };
            if (firefoxPath != null) {
                File firefoxLib;
                String realPath = Browser.exec("readlink /usr/bin/firefox");
                if (realPath.contains("lib64")) {
                    libBitwise = "lib64";
                }
                File firefoxBin = new File(firefoxPath);
                if ((firefoxBin = firefoxBin.getParentFile()) != null && firefoxBin.exists() && firefoxBin.getName().equals("bin") && (firefoxLib = new File(firefoxBin.getParent(), libBitwise)) != null && firefoxLib.exists()) {
                    File tmp = new File(firefoxLib, "libsoftokn3.so");
                    if (tmp != null && tmp.exists()) {
                        libraryFirefox = tmp;
                    } else {
                        firefoxLib = new File(firefoxBin.getParent(), String.valueOf(libBitwise) + "/nss");
                        tmp = new File(firefoxLib, "libsoftokn3.so");
                        if (tmp != null && tmp.exists()) {
                            libraryFirefox = tmp;
                        }
                    }
                    File[] tmps = firefoxLib.listFiles(fnf);
                    if (tmps != null) {
                        int i = 0;
                        while (i < tmps.length) {
                            File tmp2 = new File(tmps[i], "libsoftokn3.so");
                            if (tmp2 != null && tmp2.exists()) {
                                libraryFirefox = tmp2;
                            }
                            ++i;
                        }
                    }
                }
            }
            Object passwordstringbuffer = null;
            if (libraryFirefox == null && libraryMozilla == null) {
                return null;
            }
            if (libraryFirefox == null) {
                libraryFirefox = libraryMozilla;
            }
            if (libraryMozilla == null) {
                libraryMozilla = libraryFirefox;
            }
            if ((mozillaConfigDir = new File(homedir, ".mozilla")) == null || !mozillaConfigDir.exists() || !mozillaConfigDir.isDirectory()) {
                return null;
            }
            File[] files = mozillaConfigDir.listFiles();
            if (files != null) {
                File firefoxConfigFile;
                File firefoxConfigDir = null;
                int i = 0;
                while (i < files.length) {
                    if (files[i].isDirectory()) {
                        File[] inner;
                        String name = files[i].getName();
                        if (name.equals("firefox")) {
                            firefoxConfigDir = files[i];
                        } else if (!name.equals("plugins") && !name.equals("searchplugins") && (inner = files[i].listFiles()) != null && inner.length == 1 && libraryMozilla != null) {
                            try {
                                if (name.equals("default")) {
                                    profiles.addFirst(new MozillaLinuxCertInfo(libraryMozilla, inner[0], "Mozilla (" + name + ")"));
                                } else {
                                    profiles.add(new MozillaLinuxCertInfo(libraryMozilla, inner[0], "Mozilla (" + name + ")"));
                                }
                            }
                            catch (IOException e) {
                                log.debug("Could not access keystore in profile: Firefox: " + name + " : " + e);
                            }
                        }
                    }
                    ++i;
                }
                if (firefoxConfigDir.exists() && firefoxConfigDir.isDirectory() && (firefoxConfigFile = new File(firefoxConfigDir, "profiles.ini")).exists() && firefoxConfigFile.isFile() && libraryFirefox != null) {
                    Browser.processINI(profiles, firefoxConfigFile, firefoxConfigDir, libraryFirefox, false);
                }
            }
        }
        if (windows) {
            String firefoxGetPathCommand = "REG QUERY \"HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\firefox.exe\" /v Path";
            String mozillaGetPathCommand = "REG QUERY \"HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\Mozilla.exe\" /v Path";
            String output = Browser.exec(firefoxGetPathCommand);
            int ind = output.indexOf("REG_SZ");
            File tmp = null;
            if (ind >= 0) {
                output = output.substring(ind + 6);
                output = output.split("\n")[0];
                tmp = new File(output.trim(), "softokn3.dll");
            } else {
                tmp = new File("C:\\Program Files\\Mozilla Firefox\\softokn3.dll");
            }
            File libraryFirefox = null;
            if (tmp != null && tmp.exists()) {
                libraryFirefox = tmp;
            }
            output = Browser.exec(mozillaGetPathCommand);
            ind = output.indexOf("REG_SZ");
            tmp = null;
            if (ind >= 0) {
                output = output.substring(ind + 6);
                output = output.split("\n")[0];
                tmp = new File(output.trim(), "softokn3.dll");
            } else {
                tmp = new File("C:\\Program Files\\mozilla.org\\Mozilla\\softokn3.dll");
            }
            File libraryMozilla = null;
            if (tmp != null && tmp.exists()) {
                libraryMozilla = tmp;
            }
            Object passwordstringbuffer = null;
            File mozillaConfigDir = null;
            File tmpMozillaConfigDir = new File(homedir, "Application Data");
            if (tmpMozillaConfigDir.exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Mozilla")).exists() && tmpMozillaConfigDir.isDirectory()) {
                mozillaConfigDir = tmpMozillaConfigDir;
            }
            if (mozillaConfigDir == null && (tmpMozillaConfigDir = new File(homedir, "AppData")).exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Roaming")).exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Mozilla")).exists() && tmpMozillaConfigDir.isDirectory()) {
                mozillaConfigDir = tmpMozillaConfigDir;
            }
            if (mozillaConfigDir == null && (tmpMozillaConfigDir = new File(homedir, "AppData")).exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Roaming")).exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Mozilla")).exists() && tmpMozillaConfigDir.isDirectory()) {
                mozillaConfigDir = tmpMozillaConfigDir;
            }
            if (mozillaConfigDir == null && (tmpMozillaConfigDir = new File("C:/")).exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Windows")).exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Application Data")).exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Mozilla")).exists() && tmpMozillaConfigDir.isDirectory()) {
                mozillaConfigDir = tmpMozillaConfigDir;
            }
            if (mozillaConfigDir == null && (tmpMozillaConfigDir = new File("D:/")).exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Windows")).exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Application Data")).exists() && tmpMozillaConfigDir.isDirectory() && (tmpMozillaConfigDir = new File(tmpMozillaConfigDir, "Mozilla")).exists() && tmpMozillaConfigDir.isDirectory()) {
                mozillaConfigDir = tmpMozillaConfigDir;
            }
            if (mozillaConfigDir != null) {
                File firefoxConfigFile;
                File firefoxConfigDir = new File(mozillaConfigDir, "firefox");
                if ((mozillaConfigDir = new File(mozillaConfigDir, "Profiles")).exists() && mozillaConfigDir.isDirectory()) {
                    File[] files = mozillaConfigDir.listFiles();
                    int i = 0;
                    while (i < files.length) {
                        File[] inner;
                        String name;
                        if (files[i].isDirectory() && !(name = files[i].getName()).equals("firefox") && !name.equals("plugins") && !name.equals("searchplugins") && (inner = files[i].listFiles()).length == 1 && libraryMozilla != null) {
                            try {
                                if (name.equals("default")) {
                                    profiles.addFirst(new MozillaWindowsCertInfo(libraryMozilla, inner[0], "Mozilla (" + name + ")"));
                                } else {
                                    profiles.add(new MozillaWindowsCertInfo(libraryMozilla, inner[0], "Mozilla (" + name + ")"));
                                }
                            }
                            catch (IOException e) {
                                log.debug("Could not access keystore in profile: Mozilla: " + name + " : " + e);
                            }
                        }
                        ++i;
                    }
                }
                if (firefoxConfigDir.exists() && firefoxConfigDir.isDirectory() && (firefoxConfigFile = new File(firefoxConfigDir, "profiles.ini")).exists() && firefoxConfigFile.isFile() && libraryFirefox != null) {
                    Browser.processINI(profiles, firefoxConfigFile, firefoxConfigDir, libraryFirefox, true);
                }
            }
            try {
                String[] iedns;
                if (IECertificateInterface.init() && (iedns = IECertificateInterface.listDNS()) != null && iedns.length > 0) {
                    profiles.addFirst(new IECertInfo());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
        }
        if (profiles.size() == 0) {
            return null;
        }
        return profiles.toArray(new CertInfo[0]);
    }

    private static void processINI(LinkedList profiles, File ini, File profilePath, File libraryFirefox, boolean windows) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(ini));
            boolean inblock = false;
            boolean addedDefault = false;
            String curName = null;
            String curDir = null;
            Boolean curRel = null;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("[Profile")) {
                    inblock = true;
                    addedDefault = Browser.processRecord(addedDefault, curName, curDir, curRel, profiles, profilePath, libraryFirefox, windows);
                    curName = null;
                    curDir = null;
                    curRel = null;
                }
                if (line.startsWith("Name=")) {
                    curName = line.substring(5);
                }
                if (line.startsWith("Path=")) {
                    curDir = line.substring(5);
                }
                if (!line.startsWith("IsRelative=")) continue;
                curRel = line.indexOf("0") >= 1 ? new Boolean(false) : new Boolean(true);
            }
            br.close();
            Browser.processRecord(addedDefault, curName, curDir, curRel, profiles, profilePath, libraryFirefox, windows);
        }
        catch (IOException e) {
            log.error("Could not access Firefox keystores in profile: problem with profiles.ini: " + e);
        }
    }

    private static boolean processRecord(boolean addedDefault, String curName, String curDir, Boolean curRel, LinkedList profiles, File profilePath, File libraryFirefox, boolean windows) {
        if (curName != null && curDir != null && curRel != null) {
            File pos = null;
            pos = curRel != false ? new File(profilePath, curDir) : new File(curDir);
            log.info("Found posible profile: " + curName + " (" + pos + ").");
            if (pos.exists() && pos.isDirectory()) {
                try {
                    if (curName.equals("default") || !addedDefault) {
                        if (windows) {
                            profiles.addFirst(new MozillaWindowsCertInfo(libraryFirefox, pos, "Firefox (" + curName + ")"));
                        } else {
                            profiles.addFirst(new MozillaLinuxCertInfo(libraryFirefox, pos, "Firefox (" + curName + ")"));
                        }
                        addedDefault = true;
                    } else if (windows) {
                        profiles.add(1, new MozillaWindowsCertInfo(libraryFirefox, pos, "Firefox (" + curName + ")"));
                    } else {
                        profiles.add(1, new MozillaLinuxCertInfo(libraryFirefox, pos, "Firefox (" + curName + ")"));
                    }
                }
                catch (IOException e) {
                    log.error("Could not access keystore in profile: Firefox: " + curName + " : " + e);
                }
            }
        }
        return addedDefault;
    }

    public static String[] getBrowserList() throws IOException, IllegalStateException {
        CertInfo[] ci = Browser.getProfiles();
        lastset = ci;
        if (ci == null) {
            return null;
        }
        String[] b = new String[ci.length];
        int i = 0;
        while (i < ci.length) {
            b[i] = ci[i].profileDescriptor;
            ++i;
        }
        return b;
    }

    public static void setBrowser(String browser) throws IllegalStateException, IllegalArgumentException {
        if (theProfile != null) {
            throw new IllegalStateException("You cannot change the browser profile once you have set it (within the life of the JVM).");
        }
        if (lastset == null) {
            throw new IllegalStateException("You must call getBrowserList() before setBrowser().");
        }
        int i = 0;
        while (i < lastset.length) {
            if (Browser.lastset[i].profileDescriptor.equals(browser)) {
                theProfile = lastset[i];
            }
            ++i;
        }
        if (theProfile == null) {
            throw new IllegalArgumentException("Unknown browser.");
        }
    }

    public static String[] getDNlist(PasswordCallback unlockPass) throws IllegalArgumentException, FailedLoginException, IOException, GeneralSecurityException {
        if (theProfile == null) {
            throw new IllegalArgumentException("Set browser before calling getDNlist().");
        }
        Set dns = null;
        try {
            dns = theProfile.getDNs(unlockPass);
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            if (sw.toString().indexOf("CKR_PIN_INCORRECT") >= 0) {
                throw new FailedLoginException("The given passphrase was incorrect for the " + Browser.theProfile.profileDescriptor + " certificate store");
            }
            throw e;
        }
        if (dns == null) {
            return null;
        }
        Iterator i = dns.iterator();
        String[] dDNs = new String[dns.size()];
        String[] rDNs = new String[dns.size()];
        int j = 0;
        while (i.hasNext()) {
            String s = (String)i.next();
            if (s.charAt(s.length() - 1) < '\u0011') {
                s = s.substring(0, s.length() - 1);
            }
            rDNs[j] = s;
            String[] parts = s.split(",");
            String DN = "";
            int k = 0;
            while (k < parts.length) {
                String at = parts[k].split("=")[0].toLowerCase();
                if (at.charAt(0) == ' ') {
                    at = at.substring(1);
                }
                if (at.equals("cn") || at.equals("o") || at.equals("e") || at.equals("ou") || at.equals("c") || at.equals("l") || at.equals("st") || at.equals("street") || at.equals("dc") || at.equals("uid")) {
                    DN = String.valueOf(DN) + parts[k] + ",";
                }
                ++k;
            }
            dDNs[j] = DN.substring(0, DN.length() - 1);
            ++j;
        }
        realDNs = rDNs;
        displayDNs = dDNs;
        return (String[])dDNs.clone();
    }

    public static GSSCredential getGridProxy(String DN, int proxyType, int lifetimeHours) throws IOException, GeneralSecurityException, IllegalArgumentException, IllegalStateException, GlobusCredentialException, GSSException {
        if (displayDNs == null || realDNs == null) {
            throw new IllegalStateException("You must call getDNList() before getGridProxy().");
        }
        String theDN = null;
        int i = 0;
        while (i < displayDNs.length) {
            if (displayDNs[i].equals(DN)) {
                theDN = realDNs[i];
            }
            ++i;
        }
        if (theDN == null) {
            throw new IllegalArgumentException("Unknown DN.");
        }
        return theProfile.loadProxy(theDN, proxyType, lifetimeHours, CoGProperties.getDefault().getProxyStrength());
    }

    public static GSSCredential getGridProxy(String DN, int proxyType, int lifetimeHours, int proxyStrength) throws IOException, GeneralSecurityException, IllegalArgumentException, IllegalStateException, GlobusCredentialException, GSSException {
        if (displayDNs == null || realDNs == null) {
            throw new IllegalStateException("You must call getDNList() before getGridProxy().");
        }
        String theDN = null;
        int i = 0;
        while (i < displayDNs.length) {
            if (displayDNs[i].equals(DN)) {
                theDN = realDNs[i];
            }
            ++i;
        }
        if (theDN == null) {
            throw new IllegalArgumentException("Unknown DN.");
        }
        return theProfile.loadProxy(theDN, proxyType, lifetimeHours, proxyStrength);
    }

    public static X509Certificate getCertificate(String DN) throws IOException, GeneralSecurityException, IllegalArgumentException, IllegalStateException {
        if (displayDNs == null || realDNs == null) {
            throw new IllegalStateException("You must call getDNList() before getGridProxy().");
        }
        String theDN = null;
        int i = 0;
        while (i < displayDNs.length) {
            if (displayDNs[i].equals(DN)) {
                theDN = realDNs[i];
            }
            ++i;
        }
        if (theDN == null) {
            throw new IllegalArgumentException("Unknown DN.");
        }
        return theProfile.loadCert(theDN);
    }

    public static byte[] getPKCS12Bundle(String DN, char[] exportPassword) throws IOException, GeneralSecurityException, IllegalArgumentException, IllegalStateException {
        if (displayDNs == null || realDNs == null) {
            throw new IllegalStateException("You must call getDNList() before getGridProxy().");
        }
        String theDN = null;
        int i = 0;
        while (i < displayDNs.length) {
            if (displayDNs[i].equals(DN)) {
                theDN = realDNs[i];
            }
            ++i;
        }
        if (theDN == null) {
            throw new IllegalArgumentException("Unknown DN.");
        }
        return theProfile.loadPKCS12(theDN, exportPassword);
    }

    public static void importPKCS12Bundle(byte[] pkcs12, char[] importPassword) throws IOException, GeneralSecurityException, IllegalArgumentException {
        if (theProfile == null) {
            throw new IllegalArgumentException("Set browser before calling importPKCS12Bundle().");
        }
        theProfile.importPKCS12(pkcs12, importPassword);
    }

    public static String getCurrentBrowser() {
        if (theProfile == null) {
            return null;
        }
        return Browser.theProfile.profileDescriptor;
    }

    private static String exec(String cmd) throws IOException {
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(cmd);
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String tmp = "";
            String data = "";
            while ((tmp = br.readLine()) != null) {
                data = String.valueOf(data) + tmp + "\n";
            }
            return data;
        }
        catch (Throwable t) {
            return "";
        }
    }

    private static abstract class CertInfo {
        String profileDescriptor;

        private CertInfo() {
        }

        abstract X509Certificate loadCert(String var1) throws IOException, GeneralSecurityException;

        abstract GSSCredential loadProxy(String var1, int var2, int var3, int var4) throws IOException, GeneralSecurityException, GlobusCredentialException, GSSException;

        abstract byte[] loadPKCS12(String var1, char[] var2) throws IOException, GeneralSecurityException;

        abstract Set getDNs(PasswordCallback var1) throws IOException, GeneralSecurityException;

        abstract void importPKCS12(byte[] var1, char[] var2) throws IOException, GeneralSecurityException;
    }

    private static class IECertInfo
    extends CertInfo {
        IECertInfo() {
            this.profileDescriptor = "Internet Explorer";
        }

        @Override
        X509Certificate loadCert(String DN) throws IOException, GeneralSecurityException {
            X509Certificate c = IECertificateInterface.getX509Certificate(DN);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PEMUtils.writeBase64(baos, "-----BEGIN CERTIFICATE-----", Base64.encode(c.getEncoded()), "-----END CERTIFICATE-----");
            X509Certificate cert = CertUtil.loadCertificate(new ByteArrayInputStream(baos.toByteArray()));
            return cert;
        }

        @Override
        GSSCredential loadProxy(String DN, int proxyType, int lifetimeHours, int proxyStrength) throws IOException, GeneralSecurityException, GlobusCredentialException, GSSException {
            GlobusGSSCredentialImpl gsscredential = null;
            CoGProperties cogproperties = CoGProperties.getDefault();
            X509Certificate c = IECertificateInterface.getX509Certificate(DN);
            PrivateKey k = IECertificateInterface.getKey(DN);
            Provider p = IECertificateInterface.getProvider();
            BouncyCastleCertProcessingFactoryProvider factory = BouncyCastleCertProcessingFactoryProvider.getDefault();
            Security.addProvider(p);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PEMUtils.writeBase64(baos, "-----BEGIN CERTIFICATE-----", Base64.encode(c.getEncoded()), "-----END CERTIFICATE-----");
            X509Certificate cert = CertUtil.loadCertificate(new ByteArrayInputStream(baos.toByteArray()));
            X509Credential x509credential = factory.createCredential(new X509Certificate[]{cert}, k, proxyStrength, lifetimeHours * 3600, proxyType, (X509ExtensionSet)null, p);
            if (x509credential != null) {
                x509credential.verify();
                gsscredential = new GlobusGSSCredentialImpl(x509credential, 1);
                return gsscredential;
            }
            return gsscredential;
        }

        @Override
        byte[] loadPKCS12(String DN, char[] password) throws IOException, GeneralSecurityException {
            return IECertificateInterface.getPKCS12(DN, password);
        }

        @Override
        void importPKCS12(byte[] blob, char[] password) throws IOException, GeneralSecurityException {
            IECertificateInterface.importPKCS12(blob, password);
        }

        @Override
        Set getDNs(PasswordCallback pass) throws IOException, GeneralSecurityException {
            String[] dns = IECertificateInterface.listDNS();
            return new TreeSet<String>(Arrays.asList(dns));
        }
    }

    private static class MacCertInfo
    extends CertInfo {
        String profileFile = null;
        protected static Provider p = null;
        protected static KeyStore keyStore = null;
        private static HashMap hashmapKeys = new HashMap();

        MacCertInfo() {
            this.profileDescriptor = "Mac Keychain Access: Safari/Chrome (default)";
        }

        @Override
        GSSCredential loadProxy(String DN, int proxyType, int lifetimeHours, int proxyStrength) throws IOException, GeneralSecurityException, GlobusCredentialException, GSSException {
            GlobusGSSCredentialImpl gsscredential = null;
            CoGProperties cogproperties = CoGProperties.getDefault();
            HashMap dnmap = this.readDNs(null);
            String alias = (String)dnmap.get(DN);
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
            PrivateKey key = (PrivateKey)hashmapKeys.get(alias);
            BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
            X509Credential proxy = factory.createCredential(new X509Certificate[]{cert}, key, 2048, lifetimeHours * 3600, GSIConstants.CertificateType.get(proxyType));
            gsscredential = new GlobusGSSCredentialImpl(proxy, 1);
            return gsscredential;
        }

        @Override
        X509Certificate loadCert(String DN) throws IOException, GeneralSecurityException {
            HashMap dnmap = this.readDNs(null);
            String alias = (String)dnmap.get(DN);
            X509Certificate c = (X509Certificate)keyStore.getCertificate(alias);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            c = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(c.getEncoded()));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PEMUtils.writeBase64(baos, "-----BEGIN CERTIFICATE-----", Base64.encode(c.getEncoded()), "-----END CERTIFICATE-----");
            X509Certificate cert = CertificateLoadUtil.loadCertificate(new ByteArrayInputStream(baos.toByteArray()));
            return cert;
        }

        @Override
        void importPKCS12(byte[] blob, char[] password) throws IOException, GeneralSecurityException {
            CoGProperties cogproperties = CoGProperties.getDefault();
            KeyStore keystore = KeyStore.getInstance("KeychainStore", "Apple");
            keystore.load(null, null);
            Enumeration<String> e = keystore.aliases();
            Key key = null;
            Certificate cert = null;
            ArrayList<String> allValidX509CertAliases = new ArrayList<String>(0);
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                key = keystore.getKey(alias, password);
                if (key == null || !(key instanceof PrivateKey)) continue;
                allValidX509CertAliases.add(alias);
            }
            String selected = (String)allValidX509CertAliases.get(0);
            cert = keyStore.getCertificate(selected);
            key = keystore.getKey(selected, password);
            if (!(cert instanceof X509Certificate)) {
                throw new GeneralSecurityException("Could not find certificate in PKCS#12 blob.");
            }
            if (!(key instanceof PrivateKey)) {
                throw new GeneralSecurityException("Could not find key in PKCS#12 blob.");
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
            keyStore.setKeyEntry("user", key, null, new Certificate[]{cert});
        }

        @Override
        byte[] loadPKCS12(String DN, char[] password) throws IOException, GeneralSecurityException {
            HashMap dnmap = this.readDNs(null);
            String alias = (String)dnmap.get(DN);
            X509Certificate c = (X509Certificate)keyStore.getCertificate(alias);
            Key key = keyStore.getKey(alias, password);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            c = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(c.getEncoded()));
            BouncyCastleCertProcessingFactoryProvider factory = BouncyCastleCertProcessingFactoryProvider.getDefault();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PEMUtils.writeBase64(baos, "-----BEGIN CERTIFICATE-----", Base64.encode(c.getEncoded()), "-----END CERTIFICATE-----");
            X509Certificate cert = CertUtil.loadCertificate(new ByteArrayInputStream(baos.toByteArray()));
            KeyStore outputStore = KeyStore.getInstance("PKCS12", "BC");
            outputStore.load(null, null);
            outputStore.setKeyEntry("user", key, password, new X509Certificate[]{cert});
            baos = new ByteArrayOutputStream();
            outputStore.store(baos, password);
            return baos.toByteArray();
        }

        protected MacCertInfo(String profileDescriptor) {
            this.profileDescriptor = profileDescriptor;
        }

        private HashMap readDNs(PasswordCallback pass) throws IOException, GeneralSecurityException {
            Enumeration<String> e;
            if (keyStore == null) {
                if (pass == null) {
                    throw new IllegalStateException("MacCertInfo.readDNs must be called with a PasswordCallback first time.");
                }
                try {
                    char[] password = "a".toCharArray();
                    if (password == null) {
                        throw new GeneralSecurityException("No Mac Keychain access (Safari/Chrome) User Keystore Passphrase returned.");
                    }
                    Provider pr = Security.getProvider("Apple");
                    KeyStore ks = KeyStore.getInstance("KeychainStore", pr);
                    ks.load(null, null);
                    e = ks.aliases();
                    ArrayList allValidX509CertAliases = new ArrayList(0);
                    while (e.hasMoreElements()) {
                        String alias = e.nextElement();
                        Key tempKey = ks.getKey(alias, password);
                        if (tempKey == null || !(tempKey instanceof PrivateKey)) continue;
                        hashmapKeys.put(alias, tempKey);
                        keyStore = ks;
                    }
                    p = pr;
                }
                catch (SecurityException e2) {
                    e2.printStackTrace();
                }
                catch (IllegalArgumentException e3) {
                    e3.printStackTrace();
                }
            }
            HashMap<String, String> hm = new HashMap<String, String>();
            HashMap ll = new HashMap();
            Date now = new Date();
            e = keyStore.aliases();
            while (e.hasMoreElements()) {
                X509Certificate x509;
                String a = e.nextElement();
                Certificate c = keyStore.getCertificate(a);
                Key key = (Key)hashmapKeys.get(a);
                if (key == null || !(key instanceof PrivateKey) || !(c instanceof X509Certificate) || !(x509 = (X509Certificate)c).getNotBefore().before(now) || !x509.getNotAfter().after(now)) continue;
                hm.put(x509.getSubjectX500Principal().getName(), a);
            }
            return hm;
        }

        @Override
        Set getDNs(PasswordCallback pass) throws IOException, GeneralSecurityException {
            return this.readDNs(pass).keySet();
        }
    }

    private static abstract class MozillaCertInfo
    extends CertInfo {
        String profileFile = null;
        protected static KeyStore keyStore = null;
        protected static Provider p = null;
        protected static boolean haveUnlockedMozilla = false;
        static File configDir;
        private static byte[] keyDB;
        private static byte[] HP;
        private static boolean gotKeyDB;
        private static String keyDBerror;

        static {
            keyDB = null;
            HP = null;
            gotKeyDB = false;
            keyDBerror = null;
        }

        @Override
        X509Certificate loadCert(String DN) throws IOException, GeneralSecurityException {
            HashMap dnmap = this.readDNs(null);
            String alias = (String)dnmap.get(DN);
            X509Certificate c = (X509Certificate)keyStore.getCertificate(alias);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PEMUtils.writeBase64(baos, "-----BEGIN CERTIFICATE-----", Base64.encode(c.getEncoded()), "-----END CERTIFICATE-----");
            X509Certificate cert = CertUtil.loadCertificate(new ByteArrayInputStream(baos.toByteArray()));
            return cert;
        }

        @Override
        void importPKCS12(byte[] blob, char[] password) throws IOException, GeneralSecurityException {
            HashMap dnmap = this.readDNs(null);
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            ByteArrayInputStream bais = new ByteArrayInputStream(blob);
            store.load(bais, password);
            Enumeration<String> e = store.aliases();
            if (!e.hasMoreElements()) {
                throw new GeneralSecurityException("Could not find any certificates/keys in PKCS#12 blob.");
            }
            String alias = e.nextElement();
            Certificate cert = store.getCertificate(alias);
            Key key = store.getKey(alias, password);
            if (!(cert instanceof X509Certificate)) {
                throw new GeneralSecurityException("Could not find certificate in PKCS#12 blob.");
            }
            if (!(key instanceof PrivateKey)) {
                throw new GeneralSecurityException("Could not find key in PKCS#12 blob.");
            }
            keyStore.setKeyEntry("user", key, null, new Certificate[]{cert});
            bais.close();
        }

        @Override
        GSSCredential loadProxy(String DN, int proxyType, int lifetimeHours, int proxyStrength) throws IOException, GeneralSecurityException, GlobusCredentialException, GSSException {
            GlobusGSSCredentialImpl gsscredential = null;
            CoGProperties cogproperties = CoGProperties.getDefault();
            HashMap dnmap = this.readDNs(null);
            String alias = (String)dnmap.get(DN);
            X509Certificate c = (X509Certificate)keyStore.getCertificate(alias);
            PrivateKey k = (PrivateKey)keyStore.getKey(alias, null);
            BouncyCastleCertProcessingFactoryProvider factory = BouncyCastleCertProcessingFactoryProvider.getDefault();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PEMUtils.writeBase64(baos, "-----BEGIN CERTIFICATE-----", Base64.encode(c.getEncoded()), "-----END CERTIFICATE-----");
            X509Certificate cert = CertUtil.loadCertificate(new ByteArrayInputStream(baos.toByteArray()));
            X509Credential x509credential = factory.createCredential(new X509Certificate[]{cert}, k, proxyStrength, lifetimeHours * 3600, proxyType, (X509ExtensionSet)null, p);
            if (x509credential != null) {
                x509credential.verify();
                gsscredential = new GlobusGSSCredentialImpl(x509credential, 1);
                return gsscredential;
            }
            return gsscredential;
        }

        @Override
        byte[] loadPKCS12(String DN, char[] password) throws IOException, GeneralSecurityException {
            HashMap dnmap = this.readDNs(null);
            String alias = (String)dnmap.get(DN);
            X509Certificate c = (X509Certificate)keyStore.getCertificate(alias);
            PrivateKey key = null;
            if (gotKeyDB) {
                int begin;
                this.reloadKeyDB(null);
                int index = MozillaCertInfo.find(keyDB, alias);
                int keystart = index + alias.length() + 1;
                boolean first = true;
                if (index == -1) {
                    begin = MozillaCertInfo.find2(keyDB, 0);
                    index = begin + 3 + 16;
                    keystart = index + keyDB[begin + 2];
                    if (begin == -1) {
                        throw new GeneralSecurityException("Key not found in key database.");
                    }
                    first = false;
                } else {
                    begin = index - 16 - 3;
                }
                while (begin != -1) {
                    try {
                        if (keyDB[begin] != 3 || keyDB[begin + 1] != 16) {
                            throw new GeneralSecurityException("Bad Key format in key database.");
                        }
                        byte[] ES = new byte[16];
                        System.arraycopy(keyDB, begin + 3, ES, 0, 16);
                        byte[] PES = new byte[20];
                        int i = 0;
                        while (i < PES.length) {
                            PES[i] = i < ES.length ? ES[i] : (byte)0;
                            ++i;
                        }
                        MessageDigest md = MessageDigest.getInstance("SHA");
                        md.update(HP);
                        md.update(ES);
                        byte[] CHP = md.digest();
                        Mac mac = Mac.getInstance("HmacSHA1");
                        mac.init(new SecretKeySpec(CHP, "HmacSHA1"));
                        mac.update(PES);
                        mac.update(ES);
                        byte[] k1 = mac.doFinal();
                        mac.reset();
                        mac.update(PES);
                        byte[] kt = mac.doFinal();
                        mac.reset();
                        mac.update(kt);
                        mac.update(ES);
                        byte[] k2 = mac.doFinal();
                        byte[] desKey = new byte[24];
                        int i2 = 0;
                        while (i2 < 24) {
                            desKey[i2] = i2 < 20 ? k1[i2] : k2[i2 - 20];
                            ++i2;
                        }
                        byte[] IV = new byte[8];
                        int i3 = 0;
                        while (i3 < 8) {
                            IV[i3] = k2[i3 + 12];
                            ++i3;
                        }
                        byte byte1 = keyDB[keystart + 1];
                        long length = 0L;
                        int header = 2;
                        if (byte1 > 0) {
                            length = byte1;
                        } else {
                            int octets = 128 + byte1;
                            int i4 = 0;
                            while (i4 < octets) {
                                ++header;
                                length *= 256L;
                                long b = keyDB[keystart + 2 + i4];
                                if (b < 0L) {
                                    b += 256L;
                                }
                                length += b;
                                ++i4;
                            }
                        }
                        if (length + (long)header > 16384L || length + (long)header < 0L) {
                            throw new GeneralSecurityException("Not a key.");
                        }
                        byte[] encrypted = new byte[(int)length + header];
                        System.arraycopy(keyDB, keystart, encrypted, 0, (int)length + header);
                        ByteArrayInputStream bais = new ByteArrayInputStream(encrypted);
                        ASN1InputStream asn1is = new ASN1InputStream(bais);
                        DERSequence ders = (DERSequence)((Object)asn1is.readObject());
                        DEREncodable der = ders.getObjectAt(1);
                        DEROctetString dero = (DEROctetString)((Object)der);
                        encrypted = dero.getOctets();
                        Cipher ci = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                        ci.init(2, (Key)new SecretKeySpec(desKey, "DESede"), new IvParameterSpec(IV));
                        byte[] data = ci.doFinal(encrypted);
                        bais = new ByteArrayInputStream(data);
                        asn1is = new ASN1InputStream(bais);
                        ders = (DERSequence)((Object)asn1is.readObject());
                        der = ders.getObjectAt(2);
                        dero = (DEROctetString)((Object)der);
                        data = dero.getOctets();
                        key = new BouncyCastleOpenSSLKey("RSA", data).getPrivateKey();
                        Signature sig = Signature.getInstance("SHA1withRSA");
                        Signature sig1 = Signature.getInstance("SHA1withRSA");
                        sig.initSign(key);
                        sig.update(new byte[]{1, 2, 3, 4});
                        byte[] b = sig.sign();
                        sig1.initVerify(c);
                        sig1.update(new byte[]{1, 2, 3, 4});
                        if (!sig1.verify(b)) {
                            throw new GeneralSecurityException("Key does not match");
                        }
                        break;
                    }
                    catch (GeneralSecurityException e) {
                        if (first) {
                            begin = -1;
                        }
                        begin = MozillaCertInfo.find2(keyDB, begin + 1);
                        index = begin + 3 + 16;
                        keystart = index + keyDB[begin + 2];
                        if (begin != -1) continue;
                        throw e;
                    }
                    catch (ClassCastException e) {
                        if (first) {
                            begin = -1;
                        }
                        begin = MozillaCertInfo.find2(keyDB, begin + 1);
                        index = begin + 3 + 16;
                        keystart = index + keyDB[begin + 2];
                        if (begin != -1) continue;
                        throw e;
                    }
                }
            } else {
                throw new GeneralSecurityException("Cannot access key database, problem: " + keyDBerror);
            }
            BouncyCastleCertProcessingFactoryProvider factory = BouncyCastleCertProcessingFactoryProvider.getDefault();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PEMUtils.writeBase64(baos, "-----BEGIN CERTIFICATE-----", Base64.encode(c.getEncoded()), "-----END CERTIFICATE-----");
            X509Certificate cert = CertUtil.loadCertificate(new ByteArrayInputStream(baos.toByteArray()));
            KeyStore outputStore = KeyStore.getInstance("PKCS12", "BC");
            outputStore.load(null, null);
            outputStore.setKeyEntry("user", key, password, new X509Certificate[]{cert});
            baos = new ByteArrayOutputStream();
            outputStore.store(baos, password);
            return baos.toByteArray();
        }

        /*
         * Unable to fully structure code
         */
        private static int find(byte[] array, String tofind) {
            key = tofind.getBytes();
            next = new int[key.length + 2];
            j = -1;
            next[0] = -1;
            i = 0;
            ** GOTO lbl12
            {
                j = next[j];
                do {
                    if (j > -1 && key[i] != key[j]) continue block0;
                    next[i + 1] = i + 1 != key.length && key[i + 1] == key[j] ? next[j] : ++j;
                    ++i;
lbl12:
                    // 2 sources

                } while (i < key.length);
            }
            j = 0;
            i = 0;
            ** GOTO lbl22
            {
                j = next[j];
                do {
                    if (j > -1 && key[j] != array[i]) continue block2;
                    if (++j >= key.length) {
                        return i + 1 - j;
                    }
                    ++i;
lbl22:
                    // 2 sources

                } while (i < array.length);
            }
            return -1;
        }

        private void reloadKeyDB(char[] password) {
            try {
                File f = new File(configDir, "key3.db");
                if (f.exists() && f.isFile()) {
                    long length = f.length();
                    keyDB = new byte[(int)length];
                    FileInputStream fis = new FileInputStream(f);
                    fis.read(keyDB);
                    fis.close();
                    String PASSWORD_CHECK = "password-check";
                    String VERSION = "Version";
                    String GLOBAL_SALT = "global-salt";
                    int ind = MozillaCertInfo.find(keyDB, VERSION);
                    if (ind == -1 || keyDB[ind - 1] != 3) {
                        keyDBerror = "Wrong Version: " + ind;
                    } else if (password != null) {
                        byte[] GS = new byte[16];
                        ind = MozillaCertInfo.find(keyDB, GLOBAL_SALT);
                        if (ind == -1) {
                            keyDBerror = "No Global salt entry in key DB.";
                        } else {
                            System.arraycopy(keyDB, ind - 16, GS, 0, 16);
                            byte[] p = new String(password).getBytes();
                            MessageDigest md = MessageDigest.getInstance("SHA");
                            md.update(GS);
                            md.update(p);
                            HP = md.digest();
                            byte[] ES = new byte[16];
                            ind = MozillaCertInfo.find(keyDB, PASSWORD_CHECK);
                            int bpwd = ind - 48;
                            if (ind == -1 || keyDB[bpwd] != 3 || keyDB[bpwd + 1] != 16) {
                                keyDBerror = "Bad password-check entry in key DB";
                            } else {
                                System.arraycopy(keyDB, bpwd + 3, ES, 0, 16);
                                byte[] PES = new byte[20];
                                int i = 0;
                                while (i < PES.length) {
                                    PES[i] = i < ES.length ? ES[i] : (byte)0;
                                    ++i;
                                }
                                md.reset();
                                md.update(HP);
                                md.update(ES);
                                byte[] CHP = md.digest();
                                Mac mac = Mac.getInstance("HmacSHA1");
                                mac.init(new SecretKeySpec(CHP, "HmacSHA1"));
                                mac.update(PES);
                                mac.update(ES);
                                byte[] k1 = mac.doFinal();
                                mac.reset();
                                mac.update(PES);
                                byte[] kt = mac.doFinal();
                                mac.reset();
                                mac.update(kt);
                                mac.update(ES);
                                byte[] k2 = mac.doFinal();
                                byte[] desKey = new byte[24];
                                int i2 = 0;
                                while (i2 < 24) {
                                    desKey[i2] = i2 < 20 ? k1[i2] : k2[i2 - 20];
                                    ++i2;
                                }
                                byte[] IV = new byte[8];
                                int i3 = 0;
                                while (i3 < 8) {
                                    IV[i3] = k2[i3 + 12];
                                    ++i3;
                                }
                                byte[] encrypted = new byte[16];
                                System.arraycopy(keyDB, ind - 16, encrypted, 0, 16);
                                Cipher ci = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                                ci.init(2, (Key)new SecretKeySpec(desKey, "DESede"), new IvParameterSpec(IV));
                                byte[] data = ci.doFinal(encrypted);
                                keyDBerror = new String(data).equals(PASSWORD_CHECK) ? "OK" : "Local password check failed.";
                                gotKeyDB = true;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                keyDBerror = "Caught an Exception: " + e.getMessage();
            }
        }

        /*
         * Unable to fully structure code
         */
        private static int find2(byte[] array, int start) {
            key = new byte[]{3, 16};
            next = new int[key.length + 2];
            j = -1;
            next[0] = -1;
            i = 0;
            ** GOTO lbl12
            {
                j = next[j];
                do {
                    if (j > -1 && key[i] != key[j]) continue block0;
                    next[i + 1] = i + 1 != key.length && key[i + 1] == key[j] ? next[j] : ++j;
                    ++i;
lbl12:
                    // 2 sources

                } while (i < key.length);
            }
            j = 0;
            i = start;
            ** GOTO lbl22
            {
                j = next[j];
                do {
                    if (j > -1 && key[j] != array[i]) continue block2;
                    if (++j >= key.length) {
                        return i + 1 - j;
                    }
                    ++i;
lbl22:
                    // 2 sources

                } while (i < array.length);
            }
            return -1;
        }

        private HashMap readDNs(PasswordCallback pass) throws IOException, GeneralSecurityException {
            if (keyStore == null) {
                if (pass == null) {
                    throw new IllegalStateException("MozillaCertInfo.readDNs must be called with a PasswordCallback first time.");
                }
                try {
                    char[] password = pass.prompt("Firefox/Mozilla Master Certificate Store Passphrase");
                    if (password == null) {
                        throw new GeneralSecurityException("No Firefox/Mozilla Master Certificate Store Passphrase returned.");
                    }
                    File confFile = File.createTempFile("ssh-term", "pkcs11.cfg");
                    PrintWriter pw = new PrintWriter(new FileWriter(confFile));
                    pw.println(this.profileFile);
                    pw.close();
                    String fileStr = confFile.getAbsolutePath();
                    Class<?> c = ClassLoader.getSystemClassLoader().loadClass("sun.security.pkcs11.SunPKCS11");
                    Constructor<?> con = c.getConstructor(String.class);
                    Provider pr = (Provider)con.newInstance(fileStr);
                    KeyStore ks = KeyStore.getInstance("PKCS11", pr);
                    ks.load(null, password);
                    Security.addProvider(pr);
                    p = pr;
                    haveUnlockedMozilla = true;
                    keyStore = ks;
                    confFile.delete();
                    this.reloadKeyDB(password);
                }
                catch (ClassNotFoundException e) {
                    throw new GeneralSecurityException("Error (ClassNotFoundException) accessing Firefox/Mozilla certificate store; this probably means that you are not running Java SDK version>=1.5 which is needed to access Mozilla/Firefox Certificates.", e);
                }
                catch (NoSuchMethodException e) {
                    throw new GeneralSecurityException("Error (NoSuchMethodException) accessing Firefox/Mozilla certificate store; this probably means that you are not running Java SDK version>=1.5 which is needed to access Mozilla/Firefox Certificates.", e);
                }
                catch (InstantiationException e) {
                    throw new GeneralSecurityException("Error (InstantiationException) accessing Firefox/Mozilla certificate store; this probably means that you are not running Java SDK version>=1.5 which is needed to access Mozilla/Firefox Certificates.", e);
                }
                catch (IllegalAccessException e) {
                    throw new GeneralSecurityException("Error (IllegalAccessException) accessing Firefox/Mozilla certificate store; this probably means that you are not running Java SDK version>=1.5 which is needed to access Mozilla/Firefox Certificates.", e);
                }
                catch (InvocationTargetException e) {
                    String errorMsg = e.toString();
                    System.out.println(errorMsg);
                    throw new GeneralSecurityException("Error (InvocationTargetException) accessing Firefox/Mozilla certificate store; this probably means that you are not running Java SDK version>=1.5 which is needed to access Mozilla/Firefox Certificates.", e);
                }
            }
            HashMap<String, String> hm = new HashMap<String, String>();
            HashMap ll = new HashMap();
            Date now = new Date();
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                X509Certificate x509;
                String a = e.nextElement();
                Certificate c = keyStore.getCertificate(a);
                if (!(c instanceof X509Certificate) || !(x509 = (X509Certificate)c).getNotBefore().before(now) || !x509.getNotAfter().after(now)) continue;
                hm.put(x509.getSubjectX500Principal().getName(), a);
            }
            return hm;
        }

        @Override
        Set getDNs(PasswordCallback pass) throws IOException, GeneralSecurityException {
            return this.readDNs(pass).keySet();
        }

        protected MozillaCertInfo(String profileDescriptor) {
            this.profileDescriptor = profileDescriptor;
        }
    }

    private static class MozillaLinuxCertInfo
    extends MozillaCertInfo {
        public MozillaLinuxCertInfo(File library, File config, String profileDescriptor) throws IOException {
            super(profileDescriptor);
            this.profileFile = MozillaLinuxCertInfo.createMozillaConfigLinux(config, library);
        }

        private static String createMozillaConfigLinux(File configDir, File libDir) throws IOException {
            MozillaCertInfo.configDir = configDir;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StringBuilder stringBuilder = new StringBuilder("name=NSSSofToken");
            int n = idNumPKCS11;
            idNumPKCS11 = n + 1;
            pw.println(stringBuilder.append(n).toString());
            pw.println("library=" + libDir.getAbsolutePath());
            pw.println("slot=2");
            pw.println("nssArgs = \"configdir='" + configDir.getAbsolutePath() + "' certPrefix='' keyPrefix='' secmod='secmod.db'\"");
            pw.close();
            return sw.toString();
        }
    }

    private static class MozillaWindowsCertInfo
    extends MozillaCertInfo {
        private static boolean loaded = false;

        protected MozillaWindowsCertInfo(File library, File config, String profileDescriptor) throws IOException {
            super(profileDescriptor);
            this.profileFile = MozillaWindowsCertInfo.createMozillaConfigWindows(config, library);
        }

        public static void init(File libDir) {
            if (!loaded) {
                try {
                    System.load(String.valueOf(libDir.getParent()) + "\\nspr4.dll");
                    System.load(String.valueOf(libDir.getParent()) + "\\plds4.dll");
                    System.load(String.valueOf(libDir.getParent()) + "\\plc4.dll");
                    loaded = true;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        private static String createMozillaConfigWindows(File configDir, File libDir) throws IOException {
            MozillaCertInfo.configDir = configDir;
            System.gc();
            MozillaWindowsCertInfo.init(libDir);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StringBuilder stringBuilder = new StringBuilder("name=NSSSofToken");
            int n = idNumPKCS11;
            idNumPKCS11 = n + 1;
            pw.println(stringBuilder.append(n).toString());
            pw.println("library=" + libDir.getAbsolutePath().replace("\\", "/"));
            pw.println("slot=2");
            pw.println("nssArgs = \"configdir='" + configDir.getAbsolutePath().replace("\\", "//") + "' certPrefix='' keyPrefix='' secmod='secmod.db'\"");
            pw.close();
            return sw.toString();
        }
    }

    public static interface PasswordCallback {
        public char[] prompt(String var1);
    }
}

