/*
 * Decompiled with CFR 0.152.
 */
package apmon;

import apmon.ApMon;
import apmon.ApMonMonitoringConstants;
import apmon.host.cmdExec;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitoredJob {
    private static Logger logger = Logger.getLogger("apmon");
    int pid;
    String workDir;
    String clusterName;
    String nodeName;
    cmdExec exec = null;

    public MonitoredJob(int _pid, String _workDir, String _clusterName, String _nodeName) {
        this.pid = _pid;
        this.workDir = _workDir;
        this.clusterName = _clusterName;
        this.nodeName = _nodeName;
        this.exec = new cmdExec();
    }

    public static long parsePSTime(String s) {
        if (s.indexOf(45) > 0) {
            StringTokenizer st = new StringTokenizer(s, "-:");
            long days = Long.parseLong(st.nextToken());
            long hours = Long.parseLong(st.nextToken());
            long mins = Long.parseLong(st.nextToken());
            long secs = Long.parseLong(st.nextToken());
            return 86400L * days + 3600L * hours + 60L * mins + secs;
        }
        if (s.indexOf(58) > 0 && s.indexOf(58) != s.lastIndexOf(58)) {
            StringTokenizer st = new StringTokenizer(s, ":");
            long hours = Long.parseLong(st.nextToken());
            long mins = Long.parseLong(st.nextToken());
            long secs = Long.parseLong(st.nextToken());
            return 3600L * hours + 60L * mins + secs;
        }
        if (s.indexOf(58) > 0) {
            StringTokenizer st = new StringTokenizer(s, ":");
            long mins = Long.parseLong(st.nextToken());
            long secs = Long.parseLong(st.nextToken());
            return 60L * mins + secs;
        }
        return -1L;
    }

    public int getPid() {
        return this.pid;
    }

    public HashMap readJobDiskUsage() {
        HashMap<Long, Double> hm = new HashMap<Long, Double>();
        String cmd = null;
        String aux = null;
        Object line = null;
        String result = null;
        double workdir_size = 0.0;
        double disk_total = 0.0;
        double disk_used = 0.0;
        double disk_free = 0.0;
        double disk_usage = 0.0;
        if (this.workDir == null) {
            return null;
        }
        cmd = "du -Lscm " + this.workDir + " | tail -1 | cut -f 1";
        result = this.exec.executeCommandReality(cmd, "");
        workdir_size = Double.parseDouble(result);
        hm.put(ApMonMonitoringConstants.LJOB_WORKDIR_SIZE, new Double(workdir_size));
        cmd = "df -m " + this.workDir + " | tail -1";
        result = this.exec.executeCommand(cmd, "");
        StringTokenizer st = new StringTokenizer(result, " %");
        st.nextToken();
        aux = st.nextToken();
        disk_total = Double.parseDouble(aux);
        hm.put(ApMonMonitoringConstants.LJOB_DISK_TOTAL, new Double(workdir_size));
        aux = st.nextToken();
        disk_used = Double.parseDouble(aux);
        hm.put(ApMonMonitoringConstants.LJOB_DISK_USED, new Double(workdir_size));
        aux = st.nextToken();
        disk_free = Double.parseDouble(aux);
        hm.put(ApMonMonitoringConstants.LJOB_DISK_FREE, new Double(workdir_size));
        aux = st.nextToken();
        disk_usage = Double.parseDouble(aux);
        hm.put(ApMonMonitoringConstants.LJOB_DISK_USAGE, new Double(workdir_size));
        return hm;
    }

    public Vector getChildren() {
        int j;
        int i;
        String cmd = null;
        String result = null;
        int nProcesses = 0;
        int nChildren = 1;
        cmd = "ps --no-headers -eo ppid,pid";
        result = this.exec.executeCommandReality(cmd, "");
        boolean pidFound = false;
        if (result == null) {
            logger.warning("The child processes could not be determined");
            return null;
        }
        StringTokenizer st = new StringTokenizer(result, " \n");
        nProcesses = st.countTokens() / 2;
        Vector<Integer> pids = new Vector<Integer>();
        Vector<Integer> ppids = new Vector<Integer>();
        Vector<Integer> children = new Vector<Integer>();
        children.add(new Integer(this.pid));
        while (st.hasMoreTokens()) {
            i = Integer.parseInt(st.nextToken());
            j = Integer.parseInt(st.nextToken());
            if (j == this.pid) {
                pidFound = true;
            }
            ppids.add(new Integer(i));
            pids.add(new Integer(j));
            if (i != (Integer)children.elementAt(0)) continue;
            children.add(new Integer(j));
            ++nChildren;
        }
        if (!pidFound) {
            return null;
        }
        for (i = 1; i < nChildren; ++i) {
            for (j = 0; j < nProcesses; ++j) {
                if (!ppids.elementAt(j).equals(children.elementAt(i))) continue;
                children.add((Integer)pids.elementAt(j));
                ++nChildren;
            }
        }
        return children;
    }

    public HashMap readJobInfo() throws IOException {
        HashMap<Long, Double> ret = new HashMap<Long, Double>();
        String cmd = null;
        String result = null;
        String line = null;
        double rsz = 0.0;
        double vsz = 0.0;
        double etime = 0.0;
        double cputime = 0.0;
        double pcpu = 0.0;
        double pmem = 0.0;
        long fd = 0L;
        Vector<String> mem_cmd_list = new Vector<String>();
        Vector children = this.getChildren();
        if (children == null) {
            return null;
        }
        logger.fine("Number of children for process " + this.pid + ": " + children.size());
        cmd = "ps --no-headers --pid ";
        for (int i = 0; i < children.size() - 1; ++i) {
            cmd = cmd + children.elementAt(i) + ",";
        }
        cmd = cmd + children.elementAt(children.size() - 1);
        cmd = cmd + " -o pid,etime,time,%cpu,%mem,rsz,vsz,comm";
        result = this.exec.executeCommandReality(cmd, "");
        StringTokenizer rst = new StringTokenizer(result, "\n");
        while (rst.hasMoreTokens()) {
            line = rst.nextToken();
            StringTokenizer st = new StringTokenizer(line, " \t");
            long apid = Long.parseLong(st.nextToken());
            double _etime = MonitoredJob.parsePSTime(st.nextToken());
            double _cputime = MonitoredJob.parsePSTime(st.nextToken());
            double _pcpu = Double.parseDouble(st.nextToken());
            double _pmem = Double.parseDouble(st.nextToken());
            double _rsz = Double.parseDouble(st.nextToken());
            double _vsz = Double.parseDouble(st.nextToken());
            String cmdName = st.nextToken();
            etime = etime > _etime ? etime : _etime;
            cputime += _cputime;
            pcpu += _pcpu;
            String mem_cmd_s = "" + _rsz + "_" + _vsz + "_" + cmdName;
            if (mem_cmd_list.indexOf(mem_cmd_s) != -1) continue;
            pmem += _pmem;
            vsz += _vsz;
            rsz += _rsz;
            mem_cmd_list.add(mem_cmd_s);
            long _fd = this.countOpenFD(apid);
            if (_fd == -1L) continue;
            fd += _fd;
        }
        ret.put(ApMonMonitoringConstants.LJOB_RUN_TIME, new Double(etime));
        ret.put(ApMonMonitoringConstants.LJOB_CPU_TIME, new Double(cputime));
        ret.put(ApMonMonitoringConstants.LJOB_CPU_USAGE, new Double(pcpu));
        ret.put(ApMonMonitoringConstants.LJOB_MEM_USAGE, new Double(pmem));
        ret.put(ApMonMonitoringConstants.LJOB_RSS, new Double(rsz));
        ret.put(ApMonMonitoringConstants.LJOB_VIRTUALMEM, new Double(vsz));
        ret.put(ApMonMonitoringConstants.LJOB_OPEN_FILES, new Double(fd));
        return ret;
    }

    public long countOpenFD(long pid) {
        long open_files;
        int mypid = ApMon.getPID();
        String dir = "/proc/" + pid + "/fd";
        File f = new File(dir);
        if (f.exists()) {
            if (f.canRead()) {
                open_files = f.list().length - 2;
                if (pid == (long)mypid) {
                    open_files -= 2L;
                }
                logger.log(Level.FINE, "Counting open_files for process " + pid);
            } else {
                open_files = -1L;
                logger.log(Level.SEVERE, "ProcInfo: cannot count the number of opened files for job" + pid);
            }
        } else {
            open_files = -1L;
            logger.log(Level.SEVERE, "ProcInfo: job " + pid + "not exist.");
        }
        return open_files;
    }

    public String toString() {
        return new String("[" + this.pid + "] " + this.workDir + "  " + this.clusterName + " " + this.nodeName);
    }
}

