/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.globusonlinetool;

import com.sshtools.common.globusonlinetool.GOHelper;
import com.sshtools.common.globusonlinetool.myswingutils.DragDropTree;
import com.sshtools.common.globusonlinetool.myswingutils.JTreeNodeDynamic;
import com.sshtools.common.globusonlinetool.myswingutils.Java2sAutoComboBox;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class GlobusOnlineToolPanel
extends JPanel
implements ItemListener,
ActionListener {
    private Java2sAutoComboBox endpoint1;
    private Java2sAutoComboBox endpoint2;
    private JLabel myproxyServerLifetimeLabel;
    private JLabel directory1Label;
    private JLabel directory2Label;
    private DragDropTree fileDir1;
    private DragDropTree fileDir2;
    private JScrollPane fileDir1ScrollPane;
    private JScrollPane fileDir2ScrollPane;
    private JButton go1;
    private JButton go2;
    private XTextField directory1;
    private XTextField directory2;
    private JPasswordField localPassphrase;
    private NumericTextField port;
    private NumericTextField lifetime;
    private DefaultTreeModel treeModel1;
    private DefaultTreeModel treeModel2;
    private List<String> allEndPts = null;
    private static String ICON = "/com/sshtools/common/globusonlinetool/largego.png";

    public GlobusOnlineToolPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        Insets normalInsets = new Insets(0, 2, 4, 2);
        Insets indentedInsets = new Insets(0, 26, 4, 2);
        gbc.insets = normalInsets;
        gbc.weightx = 1.0;
        this.setLayout(new BorderLayout());
        JPanel goUsernamePanel = new JPanel(new GridBagLayout());
        goUsernamePanel.setBorder(BorderFactory.createTitledBorder("Globus Online Transfer"));
        JPanel firstEndptPanel = new JPanel(new GridBagLayout());
        firstEndptPanel.setBorder(BorderFactory.createTitledBorder("First Endpoint"));
        gbc.insets = indentedInsets;
        UIUtil.jGridBagAdd(firstEndptPanel, new JLabel("Endpoint 1:"), gbc, 1);
        try {
            this.allEndPts = GOHelper.getAllEndpoints();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.endpoint1 = new Java2sAutoComboBox(this.allEndPts);
        this.endpoint1.addItemListener(this);
        gbc.insets = normalInsets;
        gbc.weightx = 2.0;
        UIUtil.jGridBagAdd(firstEndptPanel, this.endpoint1, gbc, -1);
        UIUtil.jGridBagAdd(firstEndptPanel, new JLabel(), gbc, 0);
        gbc.insets = indentedInsets;
        this.directory1Label = new JLabel("Directory:");
        UIUtil.jGridBagAdd(firstEndptPanel, this.directory1Label, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 1.0;
        String defaultDir = GOHelper.retrieveEndPointDefaultDirectory(this.allEndPts.get(0));
        this.directory1 = new XTextField(defaultDir, 30);
        this.directory1Label.setLabelFor(this.directory1);
        UIUtil.jGridBagAdd(firstEndptPanel, this.directory1, gbc, -1);
        this.go1 = new JButton("GO");
        this.go1.addActionListener(this);
        UIUtil.jGridBagAdd(firstEndptPanel, this.go1, gbc, 0);
        gbc.insets = indentedInsets;
        this.fileDir1 = new DragDropTree(this.treeModel1);
        this.fileDir1.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                if (path.getLastPathComponent() instanceof JTreeNodeDynamic.MyTreeNode) {
                    JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)path.getLastPathComponent();
                    String currentDir = node.getFullPath();
                    node.loadChildren(GlobusOnlineToolPanel.this.treeModel1, GlobusOnlineToolPanel.this.getEndPoint1(), currentDir);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        this.fileDir1.setModel(this.treeModel1);
        this.fileDir1ScrollPane = new JScrollPane(this.fileDir1);
        this.fileDir1ScrollPane.setWheelScrollingEnabled(true);
        UIUtil.jGridBagAdd(firstEndptPanel, this.fileDir1ScrollPane, gbc, -1);
        this.add((Component)firstEndptPanel, "Center");
        JPanel secondEndptPanel = new JPanel(new GridBagLayout());
        secondEndptPanel.setBorder(BorderFactory.createTitledBorder("Second Endpoint"));
        gbc.insets = indentedInsets;
        UIUtil.jGridBagAdd(secondEndptPanel, new JLabel("Endpoint 2:"), gbc, 1);
        this.endpoint2 = new Java2sAutoComboBox(this.allEndPts);
        this.endpoint2.addItemListener(this);
        gbc.insets = normalInsets;
        gbc.weightx = 2.0;
        UIUtil.jGridBagAdd(secondEndptPanel, this.endpoint2, gbc, -1);
        UIUtil.jGridBagAdd(secondEndptPanel, new JLabel(), gbc, 0);
        gbc.insets = indentedInsets;
        this.directory2Label = new JLabel("Directory:");
        UIUtil.jGridBagAdd(secondEndptPanel, this.directory2Label, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 1.0;
        this.directory2 = new XTextField(defaultDir, 30);
        this.directory2Label.setLabelFor(this.directory1);
        UIUtil.jGridBagAdd(secondEndptPanel, this.directory2, gbc, -1);
        this.go2 = new JButton("GO");
        this.go2.addActionListener(this);
        UIUtil.jGridBagAdd(secondEndptPanel, this.go2, gbc, 0);
        gbc.insets = indentedInsets;
        this.fileDir2 = new DragDropTree(this.treeModel2);
        this.fileDir2.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                if (path.getLastPathComponent() instanceof JTreeNodeDynamic.MyTreeNode && !((JTreeNodeDynamic.MyTreeNode)path.getLastPathComponent()).isLeaf()) {
                    JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)path.getLastPathComponent();
                    String currentDir = node.getFullPath();
                    node.loadChildren(GlobusOnlineToolPanel.this.treeModel2, GlobusOnlineToolPanel.this.getEndPoint2(), currentDir);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        this.fileDir2.setModel(this.treeModel2);
        this.fileDir2ScrollPane = new JScrollPane(this.fileDir2);
        this.fileDir2ScrollPane.setWheelScrollingEnabled(true);
        UIUtil.jGridBagAdd(secondEndptPanel, this.fileDir2ScrollPane, gbc, -1);
        this.add((Component)secondEndptPanel, "East");
    }

    public DefaultMutableTreeNode addNode(DefaultMutableTreeNode curTop, String endpoint, String dir) {
        DefaultMutableTreeNode curDir = new DefaultMutableTreeNode(dir);
        if (curTop != null) {
            curTop.add(curDir);
        }
        Vector ol = new Vector();
        try {
            List<Map> allDir = GOHelper.displayLs(endpoint, dir);
            for (int i = 0; i < allDir.size(); ++i) {
                ol.addElement(allDir.get(i).get("name"));
            }
            Collections.sort(ol, String.CASE_INSENSITIVE_ORDER);
            Vector<String> files = new Vector<String>();
            for (int i = 0; i < ol.size(); ++i) {
                String thisObject;
                String newPath = thisObject = (String)ol.elementAt(i);
                if (allDir.get(i).get("type").equals("dir")) {
                    this.addNode(curDir, endpoint, dir + File.separator + allDir.get(i).get("name"));
                    continue;
                }
                files.addElement(thisObject);
            }
            for (int fnum = 0; fnum < files.size(); ++fnum) {
                curDir.add(new DefaultMutableTreeNode(files.elementAt(fnum)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curDir;
    }

    public void triggerLifetime(boolean isEnabled) {
        this.lifetime.setEnabled(isEnabled);
        this.myproxyServerLifetimeLabel.setEnabled(isEnabled);
    }

    public int getPort() {
        return (Integer)this.port.getValue();
    }

    public String getEndPoint1() {
        return (String)this.endpoint1.getSelectedItem();
    }

    public String getEndPoint2() {
        return (String)this.endpoint2.getSelectedItem();
    }

    public int getLifetime() {
        return (Integer)this.lifetime.getValue();
    }

    public String getDirectory1() {
        return this.directory1.getText().trim();
    }

    public String getDirectory2() {
        return this.directory2.getText().trim();
    }

    public void setDirectory1(String directory) {
        this.directory1.setText(directory);
    }

    public void setDirectory2(String directory) {
        this.directory2.setText(directory);
    }

    public char[] getLocalPassphrase() {
        return this.localPassphrase.getPassword();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        block13: {
            if (evt.getActionCommand().equals("GO")) {
                String endpoint = "";
                String directory = "";
                if (evt.getSource() == this.go1 || evt.getSource().equals(this.directory1)) {
                    endpoint = this.getEndPoint1();
                    directory = this.getDirectory1();
                    if (directory.equals("")) {
                        directory = GOHelper.retrieveEndPointDefaultDirectory(endpoint);
                    }
                    try {
                        if (!GOHelper.autoActivate(endpoint)) {
                            JOptionPane.showMessageDialog(null, "Cannot activate endpoint \"" + endpoint + "\". Please check if you have the permission to access this resource with the resource administrator.", "Globus Online Tool Error", 0);
                            break block13;
                        }
                        JTreeNodeDynamic.MyTreeNode root = new JTreeNodeDynamic.MyTreeNode(1, 0, this.getDirectory1(), this.getEndPoint1(), true);
                        this.treeModel1 = new DefaultTreeModel(root);
                        root.loadChildren(this.treeModel1, this.getEndPoint1(), this.getDirectory1());
                        this.fileDir1.setModel(this.treeModel1);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Cannot activate the endpoint. You might not have the required permission. Please check your configuration.\nDetail message:\n" + e.getMessage(), "Globus Online Tool Error", 0);
                    }
                } else {
                    endpoint = this.getEndPoint2();
                    directory = this.getDirectory2();
                    if (directory.equals("")) {
                        directory = GOHelper.retrieveEndPointDefaultDirectory(endpoint);
                    }
                    try {
                        if (!GOHelper.autoActivate(endpoint)) {
                            JOptionPane.showMessageDialog(null, "Cannot activate endpoint \"" + endpoint + "\". Please check if you have the permission to access this resource with the resource administrator.", "Globus Online Tool Error", 0);
                        } else {
                            JTreeNodeDynamic.MyTreeNode root = new JTreeNodeDynamic.MyTreeNode(1, 0, this.getDirectory2(), this.getEndPoint2(), true);
                            this.treeModel2 = new DefaultTreeModel(root);
                            root.loadChildren(this.treeModel2, this.getEndPoint2(), this.getDirectory2());
                            this.fileDir2.setModel(this.treeModel2);
                        }
                    }
                    catch (Exception e) {
                        String msg = "Cannot activate the endpoint. You might not have the required permission. Please check your configuration.";
                        if (e.getMessage() != null && !e.getMessage().trim().equals("null")) {
                            msg = msg + "\nDetail message:\n" + e.getMessage();
                        }
                        JOptionPane.showMessageDialog(null, msg, "Globus Online Tool Error", 0);
                    }
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.endpoint1 || evt.getSource() == this.endpoint2) {
            String endpoint = evt.getSource() == this.endpoint1 ? this.getEndPoint1() : this.getEndPoint2();
            String defaultDir = GOHelper.retrieveEndPointDefaultDirectory(endpoint);
            if (evt.getSource() == this.endpoint1) {
                this.setDirectory1(defaultDir);
            } else {
                this.setDirectory2(defaultDir);
            }
        }
    }
}

