/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.mru.MRUList;
import com.sshtools.common.mru.MRUListModel;
import com.sshtools.common.ui.MultilineLabel;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.util.BareBonesBrowserLaunch;
import com.sshtools.common.util.ShutdownHooks;
import com.sshtools.j2ssh.io.IOUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplication {
    public static final String PREF_CONNECTION_LAST_HOST = "apps.connection.lastHost";
    public static final String PREF_CONNECTION_LAST_USER = "apps.connection.lastUser";
    public static final String PREF_CONNECTION_LAST_PORT = "apps.connection.lastPort";
    public static final String PREF_CONNECTION_LAST_KEY = "apps.connection.lastKey";
    public static final String PREF_LAF = "apps.laf";
    public static final String CROSS_PLATFORM_LAF = "CROSS_PLATFORM";
    public static final String DEFAULT_LAF = "DEFAULT";
    public static final String SYSTEM_LAF = "SYSTEM";
    protected static Vector containers;
    protected static Log log;
    protected static MRUListModel mruModel;
    private static UIManager.LookAndFeelInfo[] allLookAndFeelInfo;
    protected Class panelClass;
    protected Class defaultContainerClass;
    protected List additionalOptionsTabs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SshToolsApplication(Class panelClass, Class defaultContainerClass) {
        this.panelClass = panelClass;
        this.defaultContainerClass = defaultContainerClass;
        this.additionalOptionsTabs = new ArrayList();
        try {
            File a;
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            if ((a = this.getApplicationPreferencesDirectory()) == null) {
                throw new AccessControlException("Application preferences directory not specified.");
            }
            FileInputStream in = null;
            MRUList mru = new MRUList();
            try {
                File f = new File(a, this.getApplicationName() + ".mru");
                if (f.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Loading MRU from " + f.getAbsolutePath());
                    }
                    in = new FileInputStream(f);
                    mru.reload(in);
                } else if (log.isDebugEnabled()) {
                    log.debug("MRU file " + f.getAbsolutePath() + " doesn't exist, creating empty list");
                }
            }
            catch (Exception e) {
                log.error("Could not load MRU list.", e);
            }
            finally {
                IOUtil.closeStream(in);
            }
            mruModel = new MRUListModel();
            mruModel.setMRUList(mru);
        }
        catch (AccessControlException ace) {
            log.error("Could not load MRU.", ace);
        }
    }

    public static UIManager.LookAndFeelInfo[] getAllLookAndFeelInfo() {
        return allLookAndFeelInfo;
    }

    public MRUListModel getMRUModel() {
        return mruModel;
    }

    public abstract String getApplicationName();

    public abstract String getApplicationVersion();

    public abstract Icon getApplicationLargeIcon();

    public abstract String getAboutLicenseDetails();

    public abstract String getAboutURL();

    public abstract String getAboutAuthors();

    public abstract File getApplicationPreferencesDirectory();

    public OptionsTab[] getAdditionalOptionsTabs() {
        OptionsTab[] t = new OptionsTab[this.additionalOptionsTabs.size()];
        this.additionalOptionsTabs.toArray(t);
        return t;
    }

    public void addAdditionalOptionsTab(OptionsTab tab) {
        if (!this.additionalOptionsTabs.contains(tab)) {
            this.additionalOptionsTabs.add(tab);
        }
    }

    public void removeAdditionalOptionsTab(OptionsTab tab) {
        this.additionalOptionsTabs.remove(tab);
    }

    public void removeAdditionalOptionsTab(String title) {
        OptionsTab t = this.getOptionsTab(title);
        if (t != null) {
            this.removeAdditionalOptionsTab(t);
        }
    }

    public OptionsTab getOptionsTab(String title) {
        for (OptionsTab t : this.additionalOptionsTabs) {
            if (!t.getTabTitle().equals(title)) continue;
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(boolean kill) {
        block7: {
            block8: {
                log.debug("Exiting application");
                PreferencesStore.savePreferences();
                FileOutputStream out = null;
                File a = this.getApplicationPreferencesDirectory();
                if (a == null) break block8;
                try {
                    File f = new File(this.getApplicationPreferencesDirectory(), this.getApplicationName() + ".mru");
                    if (log.isDebugEnabled()) {
                        log.debug("Saving MRU to " + f.getAbsolutePath());
                    }
                    out = new FileOutputStream(f);
                    PrintWriter w = new PrintWriter(out, true);
                    w.println(mruModel.getMRUList().toString());
                    IOUtil.closeStream(out);
                }
                catch (IOException ioe) {
                    log.error("Could not save MRU. ", ioe);
                    break block7;
                }
                finally {
                    IOUtil.closeStream(out);
                }
                break block7;
            }
            log.debug("Not saving preferences because no preferences directory is available.");
        }
        if (kill) {
            ShutdownHooks.exit(kill);
        }
    }

    public int getContainerCount() {
        return containers.size();
    }

    public SshToolsApplicationContainer getContainerAt(int idx) {
        return (SshToolsApplicationContainer)containers.elementAt(idx);
    }

    public SshToolsApplicationContainer getContainerForPanel(SshToolsApplicationPanel panel) {
        for (SshToolsApplicationContainer c : containers) {
            if (c.getApplicationPanel() != panel) continue;
            return c;
        }
        return null;
    }

    public void closeContainer(SshToolsApplicationContainer container) {
        if (log.isDebugEnabled()) {
            log.debug("Asking " + container + " if it can close");
        }
        if (container.getApplicationPanel().canClose()) {
            Iterator i;
            if (log.isDebugEnabled()) {
                log.debug("Closing");
                i = containers.iterator();
                while (i.hasNext()) {
                    log.debug(i.next() + " is currently open");
                }
            }
            container.getApplicationPanel().close();
            container.closeContainer();
            containers.removeElement(container);
            if (containers.size() == 0) {
                this.exit(true);
            } else {
                log.debug("Not closing completely because there are containers still open");
                i = containers.iterator();
                while (i.hasNext()) {
                    log.debug(i.next() + " is still open");
                }
            }
        }
    }

    public void showAbout(Component parent) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        GridBagConstraints gBC = new GridBagConstraints();
        gBC.anchor = 10;
        gBC.fill = 2;
        gBC.insets = new Insets(1, 1, 1, 1);
        JLabel a = new JLabel(this.getApplicationName());
        a.setFont(a.getFont().deriveFont(24.0f));
        UIUtil.jGridBagAdd(p, a, gBC, 0);
        MultilineLabel v = new MultilineLabel(this.getApplicationName() + " " + this.getApplicationVersion());
        v.setFont(v.getFont().deriveFont(10.0f));
        UIUtil.jGridBagAdd(p, v, gBC, 0);
        MultilineLabel x = new MultilineLabel(this.getAboutAuthors());
        x.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        x.setFont(x.getFont().deriveFont(12.0f));
        UIUtil.jGridBagAdd(p, x, gBC, 0);
        MultilineLabel c = new MultilineLabel(this.getAboutLicenseDetails());
        c.setFont(c.getFont().deriveFont(10.0f));
        UIUtil.jGridBagAdd(p, c, gBC, 0);
        JLabel h = new JLabel(this.getAboutURL());
        h.setForeground(Color.blue);
        h.setFont(new Font(h.getFont().getName(), 1, 10));
        h.setCursor(Cursor.getPredefinedCursor(12));
        h.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BareBonesBrowserLaunch.openURL(SshToolsApplication.this.getAboutURL());
            }
        });
        UIUtil.jGridBagAdd(p, h, gBC, 0);
        JOptionPane.showMessageDialog(parent, p, "About", -1, this.getApplicationLargeIcon());
    }

    public void openChangelog(Component parent) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        GridBagConstraints gBC = new GridBagConstraints();
        gBC.anchor = 10;
        gBC.fill = 2;
        gBC.insets = new Insets(1, 1, 1, 1);
        JLabel a = new JLabel(this.getApplicationName());
        a.setFont(a.getFont().deriveFont(24.0f));
        UIUtil.jGridBagAdd(p, a, gBC, 0);
        String changelog = "";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/changelog")));
            String line = br.readLine();
            while (line != null) {
                changelog = changelog + line + "\n";
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            changelog = "<Error opening changelog>\n";
        }
        JTextArea message = new JTextArea(changelog);
        message.setEditable(false);
        message.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JLabel jl = new JLabel();
        message.setFont(jl.getFont());
        message.setBackground(jl.getBackground());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(message);
        scrollPane.setSize(400, 200);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        UIUtil.jGridBagAdd(p, scrollPane, gBC, 0);
        JOptionPane.showMessageDialog(parent, p, "Change log", -1, this.getApplicationLargeIcon());
    }

    public SshToolsApplicationContainer newContainer() throws SshToolsApplicationException {
        SshToolsApplicationContainer container = null;
        try {
            container = (SshToolsApplicationContainer)this.defaultContainerClass.newInstance();
            this.newContainer(container);
            return container;
        }
        catch (Throwable t) {
            throw new SshToolsApplicationException(t);
        }
    }

    public void newContainer(SshToolsApplicationContainer container) throws SshToolsApplicationException {
        try {
            SshToolsApplicationPanel panel = (SshToolsApplicationPanel)this.panelClass.newInstance();
            panel.init(this);
            panel.rebuildActionComponents();
            panel.setAvailableActions();
            container.init(this, panel);
            panel.setContainer(container);
            if (!container.isContainerVisible()) {
                container.setContainerVisible(true);
            }
            containers.addElement(container);
        }
        catch (Throwable t) {
            throw new SshToolsApplicationException(t);
        }
    }

    public SshToolsApplicationContainer convertContainer(SshToolsApplicationContainer container, Class newContainerClass) throws SshToolsApplicationException {
        log.info("Converting container of class " + container.getClass().getName() + " to " + newContainerClass.getName());
        int idx = containers.indexOf(container);
        if (idx == -1) {
            throw new SshToolsApplicationException("Container is not being manager by the application.");
        }
        SshToolsApplicationContainer newContainer = null;
        try {
            container.closeContainer();
            SshToolsApplicationPanel panel = container.getApplicationPanel();
            newContainer = (SshToolsApplicationContainer)newContainerClass.newInstance();
            newContainer.init(this, panel);
            panel.setContainer(newContainer);
            if (!newContainer.isContainerVisible()) {
                newContainer.setContainerVisible(true);
            }
            containers.setElementAt(newContainer, idx);
            return newContainer;
        }
        catch (Throwable t) {
            throw new SshToolsApplicationException(t);
        }
    }

    public void init(String[] args) throws SshToolsApplicationException {
        File f = this.getApplicationPreferencesDirectory();
        if (f != null) {
            PreferencesStore.init(new File(f, this.getApplicationName() + ".properties"));
            log.info("Preferences will be saved to " + f.getAbsolutePath());
        } else {
            log.warn("No preferences can be saved.");
        }
        try {
            SshToolsApplication.setLookAndFeel(PreferencesStore.get(PREF_LAF, SYSTEM_LAF));
            UIManager.put("OptionPane.errorIcon", new ResourceIcon(SshToolsApplication.class, "dialog-error4.png"));
            UIManager.put("OptionPane.informationIcon", new ResourceIcon(SshToolsApplication.class, "dialog-information.png"));
            UIManager.put("OptionPane.warningIcon", new ResourceIcon(SshToolsApplication.class, "dialog-warning2.png"));
            UIManager.put("OptionPane.questionIcon", new ResourceIcon(SshToolsApplication.class, "dialog-question3.png"));
        }
        catch (Throwable t) {
            log.error(t);
        }
    }

    public static void setLookAndFeel(String className) throws Exception {
        LookAndFeel laf = null;
        if (!className.equals(DEFAULT_LAF)) {
            if (className.equals(SYSTEM_LAF)) {
                String systemLaf = UIManager.getSystemLookAndFeelClassName();
                log.debug("System Look And Feel is " + systemLaf);
                laf = (LookAndFeel)Class.forName(systemLaf).newInstance();
            } else if (className.equals(CROSS_PLATFORM_LAF)) {
                String crossPlatformLaf = UIManager.getCrossPlatformLookAndFeelClassName();
                log.debug("Cross Platform Look And Feel is " + crossPlatformLaf);
                laf = (LookAndFeel)Class.forName(crossPlatformLaf).newInstance();
            } else {
                laf = (LookAndFeel)Class.forName(className).newInstance();
            }
        }
        if (laf != null) {
            log.info("Setting look and feel " + laf.getName() + " (" + laf.getClass().getName() + ")");
            UIManager.setLookAndFeel(laf);
            UIManager.put("EditorPane.font", UIManager.getFont("TextArea.font"));
        }
    }

    static {
        UIManager.LookAndFeelInfo[] i;
        containers = new Vector();
        log = LogFactory.getLog(SshToolsApplication.class);
        try {
            i = UIManager.getInstalledLookAndFeels();
        }
        catch (Throwable t) {
            i = new UIManager.LookAndFeelInfo[]{};
        }
        allLookAndFeelInfo = new UIManager.LookAndFeelInfo[i.length + 3];
        System.arraycopy(i, 0, allLookAndFeelInfo, 0, i.length);
        SshToolsApplication.allLookAndFeelInfo[i.length] = new UIManager.LookAndFeelInfo("Default", DEFAULT_LAF);
        SshToolsApplication.allLookAndFeelInfo[i.length + 1] = new UIManager.LookAndFeelInfo("Cross Platform", CROSS_PLATFORM_LAF);
        SshToolsApplication.allLookAndFeelInfo[i.length + 2] = new UIManager.LookAndFeelInfo("System", SYSTEM_LAF);
    }
}

