/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JButton;

public class ToolButton
extends JButton {
    private static final Insets INSETS = new Insets(0, 0, 0, 0);
    private boolean hideText;

    public ToolButton(Action action) {
        super(action);
        this.setMargin(INSETS);
        this.setRequestFocusEnabled(false);
        this.setFocusPainted(false);
        if (action.getValue("hideToolbarText") != null) {
            this.setHideText(Boolean.TRUE.equals((Boolean)action.getValue("hideToolbarText")));
        } else {
            this.setHideText(true);
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public void setHideText(boolean hideText) {
        if (this.hideText != hideText) {
            this.firePropertyChange("hideText", this.hideText, hideText);
        }
        this.hideText = hideText;
        this.setHorizontalTextPosition(4);
        this.repaint();
    }

    @Override
    public String getText() {
        return this.hideText ? null : super.getText();
    }
}

