/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.vomanagementtool;

import com.sshtools.common.vomanagementtool.common.VOHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class JTreeNodeDynamic {

    public static class MyTreeNode
    extends DefaultMutableTreeNode
    implements PropertyChangeListener {
        private int depth;
        private final int index;
        private boolean isLeaf;
        private PropertyChangeListener progressListener;
        private JProgressBar bar;
        private List voDetails;

        public MyTreeNode(int index, int depth, String voName, boolean isLeaf) {
            this.index = index;
            this.depth = depth;
            this.isLeaf = isLeaf;
            this.setAllowsChildren(!isLeaf);
            this.setUserObject(voName);
            this.bar = new JProgressBar();
        }

        public MyTreeNode(Object userObject, boolean isLeaf) {
            super(new DefaultMutableTreeNode(userObject, false));
            this.isLeaf = isLeaf;
            this.index = 0;
        }

        public MyTreeNode(int index, int depth, String voName, List voDetails) {
            this.index = index;
            this.depth = depth;
            this.voDetails = voDetails;
            this.isLeaf = true;
            this.setAllowsChildren(false);
            this.setUserObject(voName);
            this.bar = new JProgressBar();
        }

        private void setChildren(List<DefaultMutableTreeNode> children) {
            this.removeAllChildren();
            this.setAllowsChildren(children.size() > 0);
            for (MutableTreeNode mutableTreeNode : children) {
                this.add(mutableTreeNode);
            }
        }

        @Override
        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void loadChildren(final DefaultTreeModel model, final String voGroup, boolean isLeaf) {
            SwingWorker<List<DefaultMutableTreeNode>, Void> worker = new SwingWorker<List<DefaultMutableTreeNode>, Void>(){

                @Override
                protected List<DefaultMutableTreeNode> doInBackground() throws Exception {
                    this.setProgress(0);
                    ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                    TreeMap groupVOs = VOHelper.getVOGroup(voGroup);
                    if (groupVOs != null && groupVOs.size() > 0) {
                        Iterator entries = groupVOs.entrySet().iterator();
                        int counter = 0;
                        while (entries.hasNext()) {
                            Map.Entry entry = entries.next();
                            String voname = (String)entry.getKey();
                            ArrayList voDetails = (ArrayList)groupVOs.get(voname);
                            if (voname != null && !voname.trim().equals("")) {
                                children.add(new MyTreeNode(counter + 1, MyTreeNode.this.depth + 1, voname.trim(), voDetails));
                            }
                            this.setProgress((counter + 1) * (100 / groupVOs.size()));
                            ++counter;
                        }
                    }
                    return children;
                }

                @Override
                protected void done() {
                    try {
                        MyTreeNode.this.setChildren((List)this.get());
                        model.nodeStructureChanged(MyTreeNode.this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    super.done();
                }
            };
            if (this.progressListener != null) {
                worker.getPropertyChangeSupport().addPropertyChangeListener("progress", this.progressListener);
            }
            worker.execute();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.bar.setValue((Integer)evt.getNewValue());
        }

        public List getNodeVODetails() {
            return this.voDetails;
        }
    }
}

