/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.ScpClient;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshEventAdapter;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventAdapter;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.net.TransportProvider;
import com.sshtools.j2ssh.net.TransportProviderFactory;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import com.sshtools.j2ssh.transport.ConsoleKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.TransportProtocolClient;
import com.sshtools.j2ssh.transport.TransportProtocolState;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshClient {
    private static Log log = LogFactory.getLog(SshClient.class);
    protected AuthenticationProtocolClient authentication;
    protected ConnectionProtocol connection;
    protected ForwardingClient forwarding;
    protected TransportProtocolClient transport;
    protected int authenticationState = 1;
    protected int socketTimeout = 0;
    protected SshEventAdapter eventHandler = null;
    protected Vector activeChannels = new Vector();
    protected ActiveChannelEventListener activeChannelListener = new ActiveChannelEventListener();
    protected boolean useDefaultForwarding = true;
    private Vector activeSftpClients = new Vector();

    public String getAuthenticationBanner(int timeout) throws IOException {
        if (this.authentication == null) {
            return "";
        }
        return this.authentication.getBannerMessage(timeout);
    }

    public List getAvailableAuthMethods(String username) throws IOException {
        if (this.authentication != null) {
            return this.authentication.getAvailableAuths(username, this.connection.getServiceName());
        }
        return null;
    }

    public boolean isConnected() {
        TransportProtocolState state = this.transport == null ? null : this.transport.getState();
        int value = state == null ? 5 : state.getValue();
        return value == 4 || value == 3;
    }

    public boolean isAuthenticated() {
        return this.authenticationState == 4;
    }

    public String getServerId() {
        return this.transport.getRemoteId();
    }

    public SshPublicKey getServerHostKey() {
        return this.transport.getServerHostKey();
    }

    public TransportProtocolState getConnectionState() {
        return this.transport.getState();
    }

    public ForwardingClient getForwardingClient() {
        return this.forwarding;
    }

    public int getRemoteEOL() {
        return this.transport.getRemoteEOL();
    }

    public void addEventHandler(SshEventAdapter eventHandler) {
        if (this.transport != null) {
            this.transport.addEventHandler(eventHandler);
            this.authentication.addEventListener(eventHandler);
        } else {
            this.eventHandler = eventHandler;
        }
    }

    public void setSocketTimeout(int milliseconds) {
        this.socketTimeout = milliseconds;
    }

    public String getRemoteEOLString() {
        return this.transport.getRemoteEOL() == 1 ? "\r\n" : "\n";
    }

    public SshConnectionProperties getConnectionProperties() {
        return this.transport.getProperties();
    }

    public int authenticate(SshAuthenticationClient auth, String hostname) throws IOException {
        this.authenticationState = this.authentication.authenticate(auth, this.connection, hostname);
        if (this.authenticationState == 4 && this.useDefaultForwarding) {
            this.forwarding.synchronizeConfiguration(this.transport.getProperties());
        }
        return this.authenticationState;
    }

    public boolean acceptsKey(String username, SshPublicKey key) throws IOException {
        if (this.authenticationState != 4) {
            PublicKeyAuthenticationClient pk = new PublicKeyAuthenticationClient();
            return pk.acceptsKey(this.authentication, username, this.connection.getServiceName(), key);
        }
        throw new SshException("Authentication has been completed!");
    }

    public void connect(String hostname) throws IOException {
        this.connect(hostname, 22, new ConsoleKnownHostsKeyVerification());
    }

    public void connect(String hostname, HostKeyVerification hosts) throws IOException {
        this.connect(hostname, 22, hosts);
    }

    public void connect(String hostname, int port) throws IOException {
        this.connect(hostname, port, new ConsoleKnownHostsKeyVerification());
    }

    public void connect(String hostname, int port, HostKeyVerification hosts) throws IOException {
        SshConnectionProperties properties = new SshConnectionProperties();
        properties.setHost(hostname);
        properties.setPort(port);
        this.connect(properties, hosts);
    }

    public void connect(SshConnectionProperties properties) throws IOException {
        this.connect(properties, (HostKeyVerification)new ConsoleKnownHostsKeyVerification());
    }

    public void connect(SshConnectionProperties properties, HostKeyVerification hostVerification) throws UnknownHostException, IOException {
        TransportProvider provider = TransportProviderFactory.connectTransportProvider(properties, this.socketTimeout);
        this.transport = new TransportProtocolClient(hostVerification);
        this.transport.addEventHandler(this.eventHandler);
        this.transport.startTransportProtocol(provider, properties);
        this.authentication = new AuthenticationProtocolClient();
        this.authentication.addEventListener(this.eventHandler);
        this.transport.requestService(this.authentication);
        this.connection = new ConnectionProtocol();
        if (this.useDefaultForwarding) {
            this.forwarding = new ForwardingClient(this.connection);
        }
    }

    public void setKexTimeout(long seconds) throws IOException {
        this.transport.setKexTimeout(seconds);
    }

    public void setKexTransferLimit(long kilobytes) throws IOException {
        this.transport.setKexTransferLimit(kilobytes);
    }

    public void setSendIgnore(boolean sendIgnore) {
        this.transport.setSendIgnore(sendIgnore);
    }

    public void setUseDefaultForwarding(boolean useDefaultForwarding) {
        this.useDefaultForwarding = useDefaultForwarding;
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.stop();
        }
        if (this.transport != null) {
            this.transport.disconnect("Terminating connection");
        }
    }

    public long getOutgoingByteCount() {
        return this.transport.getOutgoingByteCount();
    }

    public long getIncomingByteCount() {
        return this.transport.getIncomingByteCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveChannelCount() {
        Vector vector = this.activeChannels;
        synchronized (vector) {
            return this.activeChannels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveChannels() {
        Vector vector = this.activeChannels;
        synchronized (vector) {
            return (List)this.activeChannels.clone();
        }
    }

    public boolean hasActiveSession(String type) {
        for (Object obj : this.activeChannels) {
            if (!(obj instanceof SessionChannelClient) || !((SessionChannelClient)obj).getSessionType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public SessionChannelClient getActiveSession(String type) throws IOException {
        for (Object obj : this.activeChannels) {
            if (!(obj instanceof SessionChannelClient) || !((SessionChannelClient)obj).getSessionType().equals(type)) continue;
            return (SessionChannelClient)obj;
        }
        throw new IOException("There are no active " + type + " sessions");
    }

    public boolean isActiveChannel(Channel channel) {
        return this.activeChannels.contains(channel);
    }

    public SessionChannelClient openSessionChannel() throws IOException {
        return this.openSessionChannel(null);
    }

    public SessionChannelClient openSessionChannel(ChannelEventListener eventListener) throws IOException {
        if (this.authenticationState != 4) {
            throw new SshException("Authentication has not been completed!");
        }
        SessionChannelClient session = new SessionChannelClient();
        session.addEventListener(this.activeChannelListener);
        log.info("Opening Channel...");
        if (!this.connection.openChannel(session, eventListener)) {
            throw new SshException("The server refused to open a session");
        }
        log.info("Opened Channel.");
        return session;
    }

    public SftpClient openSftpClient() throws IOException {
        return this.openSftpClient(null);
    }

    public SftpClient openSftpClient(ChannelEventListener eventListener) throws IOException {
        SftpClient sftp = new SftpClient(this, eventListener);
        this.activeSftpClients.add(sftp);
        return sftp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveSftpClient() {
        Vector vector = this.activeSftpClients;
        synchronized (vector) {
            return this.activeSftpClients.size() > 0;
        }
    }

    public SftpClient getActiveSftpClient() throws IOException {
        Vector vector = this.activeSftpClients;
        synchronized (vector) {
            if (this.activeSftpClients.size() > 0) {
                return (SftpClient)this.activeSftpClients.get(0);
            }
            throw new SshException("There are no active SFTP clients");
        }
    }

    public ScpClient openScpClient() throws IOException {
        return new ScpClient(new File(System.getProperty("user.home")), this, false, this.activeChannelListener);
    }

    public ScpClient openScpClient(File cwd) throws IOException {
        return new ScpClient(cwd, this, false, this.activeChannelListener);
    }

    public SftpSubsystemClient openSftpChannel() throws IOException {
        return this.openSftpChannel(null);
    }

    public SftpSubsystemClient openSftpChannel(ChannelEventListener eventListener) throws IOException {
        SessionChannelClient session = this.openSessionChannel(eventListener);
        SftpSubsystemClient sftp = new SftpSubsystemClient();
        if (!this.openChannel(sftp)) {
            throw new SshException("The SFTP subsystem failed to start");
        }
        if (!sftp.initialize()) {
            throw new SshException("The SFTP Subsystem could not be initialized");
        }
        return sftp;
    }

    public boolean openChannel(Channel channel) throws IOException {
        if (this.authenticationState != 4) {
            throw new SshException("Authentication has not been completed!");
        }
        return this.connection.openChannel(channel, this.activeChannelListener);
    }

    public void allowChannelOpen(String channelName, ChannelFactory cf) throws IOException {
        this.connection.addChannelFactory(channelName, cf);
    }

    public void denyChannelOpen(String channelName) throws IOException {
        this.connection.removeChannelFactory(channelName);
    }

    public byte[] sendGlobalRequest(String requestName, boolean wantReply, byte[] requestData) throws IOException {
        return this.connection.sendGlobalRequest(requestName, wantReply, requestData);
    }

    class ActiveChannelEventListener
    extends ChannelEventAdapter {
        ActiveChannelEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChannelOpen(Channel channel) {
            Vector vector = SshClient.this.activeChannels;
            synchronized (vector) {
                SshClient.this.activeChannels.add(channel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChannelClose(Channel channel) {
            Vector vector = SshClient.this.activeChannels;
            synchronized (vector) {
                SshClient.this.activeChannels.remove(channel);
            }
        }
    }
}

