/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolListener;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationPrompt;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthBanner;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthFailure;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthSuccess;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;

public class AuthenticationProtocolClient
extends Service {
    private static Log log = LogFactory.getLog(AuthenticationProtocolClient.class);
    private int[] resultFilter = new int[2];
    private int[] singleIdFilter = new int[3];
    private Vector listeners = new Vector();

    public AuthenticationProtocolClient() {
        super("ssh-userauth");
        this.resultFilter[0] = 52;
        this.resultFilter[1] = 51;
        this.singleIdFilter[0] = 52;
        this.singleIdFilter[1] = 51;
    }

    @Override
    protected void onServiceAccept() throws IOException {
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected void onStop() {
    }

    @Override
    protected void onServiceInit(int startMode) throws IOException {
        if (startMode == 2) {
            throw new IOException("The Authentication Protocol client cannot be accepted");
        }
        this.transport.getMessageStore().registerMessage(51, SshMsgUserAuthFailure.class);
        this.transport.getMessageStore().registerMessage(52, SshMsgUserAuthSuccess.class);
        this.transport.getMessageStore().registerMessage(53, SshMsgUserAuthBanner.class);
    }

    @Override
    protected void onServiceRequest() throws IOException {
        throw new IOException("This class implements the client protocol only!");
    }

    public void addEventListener(AuthenticationProtocolListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public List getAvailableAuths(String username, String serviceName) throws IOException {
        log.info("Requesting authentication methods");
        SshMessage msg = new SshMsgUserAuthRequest(username, serviceName, "none", null);
        this.transport.sendMessage(msg, this);
        try {
            msg = this.transport.getMessageStore().getMessage(this.resultFilter);
        }
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
        if (msg instanceof SshMsgUserAuthFailure) {
            List l = ((SshMsgUserAuthFailure)msg).getAvailableAuthentications();
            StringBuffer b = new StringBuffer("Availiable Authorization methods: ");
            Iterator i = l.iterator();
            while (i.hasNext()) {
                b.append((String)i.next());
                if (!i.hasNext()) continue;
                b.append(", ");
            }
            log.debug(b.toString());
            return ((SshMsgUserAuthFailure)msg).getAvailableAuthentications();
        }
        throw new IOException("None request returned success! Insecure feature not supported");
    }

    public int authenticate(SshAuthenticationClient auth, Service serviceToStart, String hostname) throws IOException {
        try {
            SshAuthenticationPrompt prompt;
            int result;
            if (!auth.canAuthenticate() && auth.canPrompt() && ((result = (prompt = auth.getAuthenticationPrompt()).showPrompt(auth)) == 5 || result == 2)) {
                return result;
            }
            auth.setHostname(hostname);
            auth.authenticate(this, serviceToStart.getServiceName());
            SshMessage msg = this.parseMessage(this.transport.getMessageStore().getMessage(this.resultFilter));
            throw new AuthenticationProtocolException("Unexpected authentication message " + msg.getMessageName());
        }
        catch (TerminatedStateException tse) {
            if (tse.getState() == 4) {
                serviceToStart.init(2, this.transport);
                serviceToStart.start();
                for (AuthenticationProtocolListener listener : this.listeners) {
                    if (listener == null) continue;
                    listener.onAuthenticationComplete();
                }
            }
            return tse.getState();
        }
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
    }

    public void sendMessage(SshMessage msg) throws IOException {
        this.transport.sendMessage(msg, this);
    }

    public byte[] getSessionIdentifier() {
        return this.transport.getSessionIdentifier();
    }

    public void registerMessage(Class cls, int messageId) {
        this.transport.getMessageStore().registerMessage(messageId, cls);
    }

    public SshMessage readMessage(int messageId) throws TerminatedStateException, IOException {
        this.singleIdFilter[2] = messageId;
        return this.internalReadMessage(this.singleIdFilter);
    }

    private SshMessage internalReadMessage(int[] messageIdFilter) throws TerminatedStateException, IOException {
        try {
            SshMessage msg = this.transport.getMessageStore().getMessage(messageIdFilter);
            return this.parseMessage(msg);
        }
        catch (MessageStoreEOFException meof) {
            throw new AuthenticationProtocolException("Failed to read messages");
        }
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
    }

    public SshMessage readMessage(int[] messageId) throws TerminatedStateException, IOException {
        int[] messageIdFilter = new int[messageId.length + this.resultFilter.length];
        System.arraycopy(this.resultFilter, 0, messageIdFilter, 0, this.resultFilter.length);
        System.arraycopy(messageId, 0, messageIdFilter, this.resultFilter.length, messageId.length);
        return this.internalReadMessage(messageIdFilter);
    }

    public void readAuthenticationState() throws IOException, TerminatedStateException {
        this.internalReadMessage(this.resultFilter);
    }

    private SshMessage parseMessage(SshMessage msg) throws TerminatedStateException {
        if (msg instanceof SshMsgUserAuthFailure) {
            if (((SshMsgUserAuthFailure)msg).getPartialSuccess()) {
                throw new TerminatedStateException(3);
            }
            throw new TerminatedStateException(2);
        }
        if (msg instanceof SshMsgUserAuthSuccess) {
            throw new TerminatedStateException(4);
        }
        return msg;
    }

    public String getBannerMessage(int timeout) throws IOException {
        try {
            log.debug("getBannerMessage is attempting to read the authentication banner");
            SshMessage msg = this.transport.getMessageStore().peekMessage(53, timeout);
            return ((SshMsgUserAuthBanner)msg).getBanner();
        }
        catch (MessageNotAvailableException e) {
            return "";
        }
        catch (MessageStoreEOFException eof) {
            log.error("Failed to retreive banner becasue the message store is EOF");
            return "";
        }
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
    }

    public GSSContext getGSSContext() {
        return this.transport.getGSSContext();
    }
}

