/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.dsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssPublicKey;
import com.sshtools.j2ssh.util.SimpleASNReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SshDssPrivateKey
extends SshPrivateKey {
    private static Log log = LogFactory.getLog(SshDssPrivateKey.class);
    DSAPrivateKey prvkey;

    public SshDssPrivateKey(DSAPrivateKey prvkey) {
        this.prvkey = prvkey;
    }

    public SshDssPrivateKey(byte[] key) throws InvalidSshKeyException {
        try {
            ByteArrayReader bar = new ByteArrayReader(key);
            String header = bar.readString();
            if (!header.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger p = bar.readBigInteger();
            BigInteger q = bar.readBigInteger();
            BigInteger g = bar.readBigInteger();
            BigInteger x = bar.readBigInteger();
            DSAPrivateKeySpec dsaKey = new DSAPrivateKeySpec(x, p, q, g);
            KeyFactory kf = KeyFactory.getInstance("DSA");
            this.prvkey = (DSAPrivateKey)kf.generatePrivate(dsaKey);
            log.info(this.prvkey.getParams().getP().toString(16));
            log.info(this.prvkey.getParams().getQ().toString(16));
            log.info(this.prvkey.getParams().getG().toString(16));
            log.info(this.getY().toString(16));
        }
        catch (Exception e) {
            throw new InvalidSshKeyException();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshDssPrivateKey) {
            return this.prvkey.equals(((SshDssPrivateKey)obj).prvkey);
        }
        return false;
    }

    public int hashCode() {
        return this.prvkey.hashCode();
    }

    @Override
    public String getAlgorithmName() {
        return "ssh-dss";
    }

    @Override
    public int getBitLength() {
        return this.prvkey.getX().bitLength();
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.writeString("ssh-dss");
            baw.writeBigInteger(this.prvkey.getParams().getP());
            baw.writeBigInteger(this.prvkey.getParams().getQ());
            baw.writeBigInteger(this.prvkey.getParams().getG());
            baw.writeBigInteger(this.prvkey.getX());
            return baw.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public SshPublicKey getPublicKey() {
        try {
            DSAPublicKeySpec spec = new DSAPublicKeySpec(this.getY(), this.prvkey.getParams().getP(), this.prvkey.getParams().getQ(), this.prvkey.getParams().getG());
            KeyFactory kf = KeyFactory.getInstance("DSA");
            return new SshDssPublicKey((DSAPublicKey)kf.generatePublic(spec));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public byte[] generateSignature(byte[] data) throws InvalidSshKeySignatureException {
        try {
            Signature sig = Signature.getInstance("SHA1withDSA");
            sig.initSign(this.prvkey);
            sig.update(data);
            byte[] signature = sig.sign();
            byte[] decoded = new byte[40];
            SimpleASNReader asn = new SimpleASNReader(signature);
            asn.getByte();
            asn.getLength();
            asn.getByte();
            byte[] r = asn.getData();
            asn.getByte();
            byte[] s = asn.getData();
            if (r.length >= 20) {
                System.arraycopy(r, r.length - 20, decoded, 0, 20);
            } else {
                System.arraycopy(r, 0, decoded, 20 - r.length, r.length);
            }
            if (s.length >= 20) {
                System.arraycopy(s, s.length - 20, decoded, 20, 20);
            } else {
                System.arraycopy(s, 0, decoded, 20 + (20 - s.length), s.length);
            }
            if (log.isDebugEnabled()) {
                int i;
                BigInteger rb = new BigInteger(1, r);
                log.debug(rb.toString(16));
                BigInteger sb = new BigInteger(1, s);
                log.debug(sb.toString(16));
                log.debug("s length is " + String.valueOf(s.length));
                log.debug("r length is " + String.valueOf(r.length));
                String str = "";
                for (i = 0; i < signature.length; ++i) {
                    str = str + Integer.toHexString(signature[i] & 0xFF) + " ";
                }
                log.debug("Java signature is " + str);
                str = "";
                for (i = 0; i < decoded.length; ++i) {
                    str = str + Integer.toHexString(decoded[i] & 0xFF) + " ";
                }
                log.debug("SSH signature is " + str);
            }
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.writeString(this.getAlgorithmName());
            baw.writeBinaryString(decoded);
            return baw.toByteArray();
        }
        catch (Exception e) {
            throw new InvalidSshKeySignatureException(e);
        }
    }

    private BigInteger getY() {
        return this.prvkey.getParams().getG().modPow(this.prvkey.getX(), this.prvkey.getParams().getP());
    }
}

