/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SshTermOptionsTab
extends JPanel
implements OptionsTab {
    public static final String TERMINAL_ICON = "/com/sshtools/sshterm/largeterminal.png";
    private JComponent mouseWheelIncrement;

    public SshTermOptionsTab() {
        Insets ins = new Insets(2, 2, 2, 2);
        JPanel s = new JPanel(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.weighty = 1.0;
        gbc1.insets = ins;
        gbc1.anchor = 18;
        gbc1.fill = 2;
        gbc1.weightx = 0.0;
        UIUtil.jGridBagAdd(s, new JLabel("Mouse wheel increment "), gbc1, -1);
        gbc1.weightx = 1.0;
        try {
            Class<?> spinnerModelClass = Class.forName("javax.swing.SpinnerModel");
            Class<?> spinnerNumberModelClass = Class.forName("javax.swing.SpinnerNumberModel");
            Constructor<?> spinnerNumberModelConstructor = spinnerNumberModelClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object spinnerNumberModel = spinnerNumberModelConstructor.newInstance(new Integer(1), new Integer(1), new Integer(999), new Integer(1));
            Class<?> spinnerClass = Class.forName("javax.swing.JSpinner");
            Constructor<?> spinnerConstructor = spinnerClass.getConstructor(spinnerModelClass);
            this.mouseWheelIncrement = (JComponent)spinnerConstructor.newInstance(spinnerNumberModel);
            UIUtil.jGridBagAdd(s, this.mouseWheelIncrement, gbc1, 0);
        }
        catch (Throwable t) {
            throw new RuntimeException("Not 1.4?. This exception should be removed if and when new options that don't depend on 1.4 are added to this panel");
        }
        IconWrapperPanel w = new IconWrapperPanel(new ResourceIcon(TERMINAL_ICON), s);
        this.setLayout(new BorderLayout());
        this.add((Component)w, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.reset();
    }

    @Override
    public void reset() {
        if (this.mouseWheelIncrement != null) {
            try {
                Method m = this.mouseWheelIncrement.getClass().getMethod("setValue", Integer.class);
                Integer i = new Integer(PreferencesStore.getInt("sshterm.mouseWheelIncrement", 1));
                m.invoke((Object)this.mouseWheelIncrement, i);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public String getTabContext() {
        return "Options";
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return "Terminal";
    }

    @Override
    public String getTabToolTipText() {
        return "Terminal options.";
    }

    @Override
    public int getTabMnemonic() {
        return 116;
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public boolean validateTab() {
        return true;
    }

    @Override
    public void applyTab() {
        if (this.mouseWheelIncrement != null) {
            try {
                Method m = this.mouseWheelIncrement.getClass().getMethod("getValue", new Class[0]);
                Integer i = (Integer)m.invoke((Object)this.mouseWheelIncrement, new Object[0]);
                PreferencesStore.putInt("sshterm.mouseWheelIncrement", i);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void tabSelected() {
    }

    class LAFRenderer
    extends DefaultListCellRenderer {
        LAFRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(((UIManager.LookAndFeelInfo)value).getName());
            return this;
        }
    }
}

