/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class XForwardingTab
extends JPanel
implements SshToolsConnectionTab,
ActionListener {
    public static final boolean XON_DEFAULT = true;
    static final String X_ICON = "/com/sshtools/sshterm/x.png";
    protected SshToolsConnectionProfile profile;
    protected JCheckBox enableXForwarding;
    protected XTextField localDisplay;
    protected NumericTextField remoteDisplayNumber;
    protected JLabel localDisplayLabel;
    protected JLabel remoteDisplayNumberLabel;

    public XForwardingTab() {
        Insets ins = new Insets(0, 2, 2, 2);
        Insets ins2 = new Insets(2, 24, 2, 2);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.fill = 2;
        gbc1.anchor = 11;
        gbc1.insets = ins;
        gbc1.weightx = 1.0;
        JPanel main = new JPanel(new GridBagLayout());
        gbc1.weightx = 2.0;
        this.enableXForwarding = new JCheckBox("Enable X Forwarding", true);
        UIUtil.jGridBagAdd(main, this.enableXForwarding, gbc1, 0);
        this.enableXForwarding.addActionListener(this);
        JPanel main2 = new JPanel(new GridBagLayout());
        main2.setBorder(BorderFactory.createTitledBorder("Advanced Settings: "));
        gbc1.insets = ins2;
        gbc1.weightx = 0.0;
        this.localDisplayLabel = new JLabel("Local display ");
        UIUtil.jGridBagAdd(main2, this.localDisplayLabel, gbc1, -1);
        gbc1.weightx = 1.0;
        this.localDisplay = new XTextField(15);
        UIUtil.jGridBagAdd(main2, this.localDisplay, gbc1, 0);
        this.remoteDisplayNumberLabel = new JLabel("Remote display number ");
        this.remoteDisplayNumber = new NumericTextField(new Integer(0), new Integer(65536), new Integer(0));
        gbc1.insets = ins;
        gbc1.weighty = 1.0;
        gbc1.weightx = 1.0;
        UIUtil.jGridBagAdd(main, main2, gbc1, 0);
        IconWrapperPanel iconTerminalPanel = new IconWrapperPanel(new ResourceIcon(X_ICON), main);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)iconTerminalPanel, "Center");
        this.setAvailableActions();
    }

    private void setAvailableActions() {
        this.remoteDisplayNumber.setEnabled(this.enableXForwarding.isSelected());
        this.remoteDisplayNumberLabel.setEnabled(this.enableXForwarding.isSelected());
        this.localDisplay.setEnabled(this.enableXForwarding.isSelected());
        this.localDisplayLabel.setEnabled(this.enableXForwarding.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setAvailableActions();
    }

    @Override
    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        this.enableXForwarding.setSelected(profile.getApplicationPropertyBoolean("sshterm.xForwarding", PreferencesStore.getBoolean("sshterm.xForwarding", true)));
        this.localDisplay.setText(profile.getApplicationProperty("sshterm.xForwarding.localDisplay", ""));
        this.remoteDisplayNumber.setText(profile.getApplicationProperty("sshterm.xForwarding.remoteDisplayNumber", ""));
        this.setAvailableActions();
    }

    @Override
    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    @Override
    public String getTabContext() {
        return "Connection";
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return "X";
    }

    @Override
    public String getTabToolTipText() {
        return "X forwarding configuration.";
    }

    @Override
    public int getTabMnemonic() {
        return 120;
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public boolean validateTab() {
        return true;
    }

    @Override
    public void applyTab() {
        this.profile.setApplicationProperty("sshterm.xForwarding", this.enableXForwarding.isSelected());
        this.profile.setApplicationProperty("sshterm.xForwarding.localDisplay", this.localDisplay.getText());
        this.profile.setApplicationProperty("sshterm.xForwarding.remoteDisplayNumber", this.remoteDisplayNumber.getText());
    }

    @Override
    public void tabSelected() {
    }
}

