/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.hep.dcapj.io;

import edu.caltech.hep.dcapj.dCacheFile;
import edu.caltech.hep.dcapj.nio.dCacheFileChannel;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class dCacheFileOutputStream
extends FileOutputStream {
    private dCacheFile _file = null;

    public dCacheFileOutputStream(dCacheFile file) throws Exception {
        super(file);
        this._file = file;
    }

    public dCacheFileOutputStream(String file) throws Exception {
        this(new dCacheFile(file, dCacheFile.Mode.WRITE_ONLY));
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this._file.write(buffer, -1L);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes, off, len);
        this._file.write(buffer, -1L);
    }

    @Override
    public void close() throws IOException {
        this._file.close();
        super.close();
    }

    protected void finalize() throws IOException {
        this.close();
        super.finalize();
    }

    @Override
    public FileChannel getChannel() {
        return new dCacheFileChannel(this._file, this);
    }
}

