/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.hep.dcapj.test;

import edu.caltech.hep.dcapj.PnfsUtil;
import edu.caltech.hep.dcapj.dCapLayer;
import edu.caltech.hep.dcapj.io.dCacheFileInputStream;
import edu.caltech.hep.dcapj.io.dCacheFileOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class Main3
implements Runnable {
    private String source = null;
    private String destination = null;
    private FileInputStream fileIn = null;
    private FileOutputStream fileOut = null;
    private dCacheFileInputStream dFileIn = null;
    private dCacheFileOutputStream dFileOut = null;

    public Main3(String src, String dest) {
        this.source = src;
        this.destination = dest;
    }

    public static void main(String[] args) {
        int i;
        try {
            dCapLayer.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int ioPairs = args.length / 2;
        if (ioPairs == 0 || ioPairs != 1 && ioPairs % 2 != 0) {
            System.out.println("Not enough source/dest pair! " + ioPairs);
            dCapLayer.close();
            return;
        }
        Main3[] main3 = new Main3[ioPairs];
        Thread[] ioThreads = new Thread[ioPairs];
        int count = 0;
        for (i = 0; i < ioPairs; ++i) {
            main3[i] = new Main3(args[count++], args[count++]);
            ioThreads[i] = new Thread(main3[i]);
            ioThreads[i].start();
        }
        try {
            for (i = 0; i < ioPairs; ++i) {
                ioThreads[i].join();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dCapLayer.close();
    }

    @Override
    public void run() {
        this.doIO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIO() {
        AbstractInterruptibleChannel fC1 = null;
        AbstractInterruptibleChannel fC2 = null;
        try {
            FileChannel[] temp = this.getFileChannels();
            fC1 = temp[0];
            fC2 = temp[1];
            if (fC1 == null) {
                System.out.println("Failed to get IO channel for file " + this.source);
                return;
            }
            if (fC2 == null) {
                System.out.println("Failed to get IO channel for file " + this.destination);
                return;
            }
            int default_buffer_size = 5120;
            ByteBuffer buffer = ByteBuffer.allocate(default_buffer_size);
            long bytesRem = ((FileChannel)fC1).size();
            while (true) {
                int buffSize = Math.min(default_buffer_size, (int)bytesRem);
                buffer.limit(buffSize);
                long nr = ((FileChannel)fC1).read(buffer);
                if (nr <= 0L) break;
                bytesRem -= nr;
                buffer.limit((int)nr).flip();
                ((FileChannel)fC2).write(buffer);
                buffer.clear();
            }
            System.out.println("Done " + this.source + " -> " + this.destination);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fC1.close();
                fC2.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private FileChannel[] getFileChannels() throws Exception {
        FileChannel[] fc = new FileChannel[2];
        if (!PnfsUtil.isPnfs(this.source)) {
            this.dFileOut = new dCacheFileOutputStream(this.destination);
            fc[1] = this.dFileOut.getChannel();
            this.fileIn = new FileInputStream(this.source);
            fc[0] = this.fileIn.getChannel();
        } else {
            this.dFileIn = new dCacheFileInputStream(this.source);
            fc[0] = this.dFileIn.getChannel();
            this.fileOut = new FileOutputStream(this.destination);
            fc[1] = this.fileOut.getChannel();
        }
        return fc;
    }
}

