/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.cms;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1TaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.cms.TimeStampAndCRL;
import java.util.Enumeration;

public class TimeStampTokenEvidence
extends ASN1Encodable {
    private TimeStampAndCRL[] timeStampAndCRLs;

    public TimeStampTokenEvidence(TimeStampAndCRL[] timeStampAndCRLArray) {
        this.timeStampAndCRLs = timeStampAndCRLArray;
    }

    public TimeStampTokenEvidence(TimeStampAndCRL timeStampAndCRL) {
        this.timeStampAndCRLs = new TimeStampAndCRL[1];
        this.timeStampAndCRLs[0] = timeStampAndCRL;
    }

    private TimeStampTokenEvidence(ASN1Sequence aSN1Sequence) {
        this.timeStampAndCRLs = new TimeStampAndCRL[aSN1Sequence.size()];
        int n = 0;
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            this.timeStampAndCRLs[n++] = TimeStampAndCRL.getInstance(enumeration.nextElement());
        }
    }

    public static TimeStampTokenEvidence getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return TimeStampTokenEvidence.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static TimeStampTokenEvidence getInstance(Object object) {
        if (object instanceof TimeStampTokenEvidence) {
            return (TimeStampTokenEvidence)object;
        }
        if (object != null) {
            return new TimeStampTokenEvidence(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public TimeStampAndCRL[] toTimeStampAndCRLArray() {
        return this.timeStampAndCRLs;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i != this.timeStampAndCRLs.length; ++i) {
            aSN1EncodableVector.add(this.timeStampAndCRLs[i]);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

