/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.MonetaryLimit;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import java.io.IOException;

public class MonetaryLimitUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "MonetaryLimit";
    }

    public void performTest() throws Exception {
        String string = "AUD";
        int n = 1;
        int n2 = 2;
        MonetaryLimit monetaryLimit = new MonetaryLimit(string, n, n2);
        this.checkConstruction(monetaryLimit, string, n, n2);
        monetaryLimit = MonetaryLimit.getInstance(null);
        if (monetaryLimit != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            MonetaryLimit.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(MonetaryLimit monetaryLimit, String string, int n, int n2) throws IOException {
        this.checkValues(monetaryLimit, string, n, n2);
        monetaryLimit = MonetaryLimit.getInstance(monetaryLimit);
        this.checkValues(monetaryLimit, string, n, n2);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(monetaryLimit.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        monetaryLimit = MonetaryLimit.getInstance(aSN1Sequence);
        this.checkValues(monetaryLimit, string, n, n2);
    }

    private void checkValues(MonetaryLimit monetaryLimit, String string, int n, int n2) {
        this.checkMandatoryField("currency", string, monetaryLimit.getCurrency());
        this.checkMandatoryField("amount", n, monetaryLimit.getAmount().intValue());
        this.checkMandatoryField("exponent", n2, monetaryLimit.getExponent().intValue());
    }

    public static void main(String[] stringArray) {
        MonetaryLimitUnitTest.runTest(new MonetaryLimitUnitTest());
    }
}

