/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls.test;

import edu.illinois.ncsa.bouncycastle.crypto.tls.test.KeyStores;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;

public class HTTPSServerThread
extends Thread {
    private static final int PORT_NO = 8003;
    private static final char[] SERVER_PASSWORD = "serverPassword".toCharArray();
    private static final char[] TRUST_STORE_PASSWORD = "trustPassword".toCharArray();

    private void readRequest(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        while ((n = inputStream.read()) >= 0 && n != 10 && n2 != 10) {
            if (n == 13) continue;
            n2 = n;
        }
    }

    private void sendResponse(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        printWriter.print("HTTP/1.1 200 OK\r\n");
        printWriter.print("Content-Type: text/html\r\n");
        printWriter.print("\r\n");
        printWriter.print("<html>\r\n");
        printWriter.print("<body>\r\n");
        printWriter.print("Hello World!\r\n");
        printWriter.print("</body>\r\n");
        printWriter.print("</html>\r\n");
        printWriter.flush();
    }

    SSLContext createSSLContext() throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new ByteArrayInputStream(KeyStores.server), SERVER_PASSWORD);
        keyManagerFactory.init(keyStore, SERVER_PASSWORD);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        KeyStore keyStore2 = KeyStore.getInstance("JKS");
        keyStore2.load(new ByteArrayInputStream(KeyStores.trustStore), TRUST_STORE_PASSWORD);
        trustManagerFactory.init(keyStore2);
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sSLContext;
    }

    public void run() {
        try {
            SSLContext sSLContext = this.createSSLContext();
            SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
            SSLServerSocket sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(8003);
            SSLSocket sSLSocket = (SSLSocket)sSLServerSocket.accept();
            sSLSocket.startHandshake();
            this.readRequest(sSLSocket.getInputStream());
            SSLSession sSLSession = sSLSocket.getSession();
            this.sendResponse(sSLSocket.getOutputStream());
            sSLSocket.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

