/*
 * Decompiled with CFR 0.152.
 */
package lia.gsi.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.gsi.authz.LocalMappingAuthorization;
import lia.gsi.net.AbstractServerDeactivator;
import lia.gsi.net.Peer;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.net.ServerSocketFactory;
import org.globus.net.SocketFactory;
import org.globus.util.Util;
import org.globus.util.deactivator.Deactivator;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public abstract class GSIBaseServer
implements Runnable {
    private static final Logger logger = Logger.getLogger(GSIBaseServer.class.getName());
    private static final int SO_TIMEOUT = Integer.getInteger("GSI_SO_TIMEOUT", 300000);
    protected volatile boolean accept;
    protected ServerSocket _server = null;
    protected String url = null;
    protected GSSCredential credentials = null;
    protected Integer gssMode = GSIConstants.MODE_SSL;
    protected int timeout = SO_TIMEOUT;
    protected AbstractServerDeactivator deactivator = null;
    String authzClassName;
    private Thread serverThread = null;
    private boolean secure = true;

    public GSIBaseServer() throws IOException {
        this(null, 0);
    }

    public GSIBaseServer(int port) throws IOException {
        this(null, port);
    }

    public GSIBaseServer(GSSCredential cred, int port) throws IOException {
        this.credentials = cred;
        this._server = ServerSocketFactory.getDefault().createServerSocket(port);
        this.secure = true;
        this.initialize();
    }

    public GSIBaseServer(boolean secure, int port) throws IOException {
        this.credentials = null;
        this._server = ServerSocketFactory.getDefault().createServerSocket(port);
        this.secure = secure;
        this.initialize();
    }

    protected void initialize() {
        this.authzClassName = System.getProperty("gsi.authz.Authorization");
        if (this.authzClassName == null) {
            this.authzClassName = "lia.gsi.authz.GridMapAuthorization";
        }
    }

    private LocalMappingAuthorization createAuthorizer() {
        try {
            Class<?> clazz = Class.forName(this.authzClassName);
            if (!LocalMappingAuthorization.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("Invalid Server Authorization class");
            }
            return (LocalMappingAuthorization)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load '" + this.authzClassName + "' authorization plugin class. Cause: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate '" + this.authzClassName + "'authorization plugin class. Cause: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate '" + this.authzClassName + "'authorization plugin class. Cause: " + e.getMessage());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to instantiate '" + this.authzClassName + "'authorization plugin class. Cause: " + t.getMessage());
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.accept = false;
        try {
            this._server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SocketFactory factory = SocketFactory.getDefault();
        Socket s = null;
        try {
            s = factory.createSocket(InetAddress.getLocalHost(), this.getPort());
            s.getInputStream();
        }
        catch (Exception exception) {
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
        this.serverThread = null;
        this._server = null;
    }

    protected void start() {
        if (this.serverThread == null) {
            this.accept = true;
            this.serverThread = new Thread(this);
            this.serverThread.setName("GSIServer");
            this.serverThread.start();
        }
    }

    public GSSCredential getCredentials() {
        return this.credentials;
    }

    public String getProtocol() {
        return this.secure ? "https" : "http";
    }

    public String getURL() {
        if (this.url == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getProtocol()).append("://").append(this.getHost()).append(":").append(String.valueOf(this.getPort()));
            this.url = buf.toString();
        }
        return this.url;
    }

    public int getPort() {
        return this._server.getLocalPort();
    }

    public String getHostname() {
        return Util.getLocalHostAddress();
    }

    public String getHost() {
        String host = Util.getLocalHostAddress();
        try {
            URL u = new URL("http", host, 80, "/");
            return u.getHost();
        }
        catch (MalformedURLException e) {
            return host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Socket socket = null;
        boolean error = false;
        while (this.accept) {
            error = false;
            socket = null;
            try {
                socket = this._server.accept();
                if (!this.accept) break;
                if (socket == null) {
                    continue;
                }
            }
            catch (IOException e) {
                if (this.accept) {
                    logger.log(Level.WARNING, "Server died: " + e.getMessage(), e);
                }
                error = true;
                break;
            }
            try {
                socket.setSoTimeout(this.getTimeout());
                Peer peer = null;
                if (this.secure) {
                    try {
                        peer = this.wrapSocket(socket);
                    }
                    catch (GSSException e) {
                        logger.log(Level.WARNING, "Failed to secure the socket", e);
                    }
                } else {
                    peer = new Peer(socket, null);
                }
                this.handleConnection(peer);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, " [ GSIBaseServer ] Exception while trying to secure GSI socket: " + socket, t);
                error = true;
            }
            continue;
            finally {
                if (!error || socket == null) continue;
                try {
                    socket.close();
                }
                catch (Throwable throwable) {}
            }
        }
        logger.log(Level.WARNING, "server thread stopped");
    }

    protected Peer wrapSocket(Socket socket) throws GSSException {
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(this.credentials);
        context.setOption(GSSConstants.GSS_MODE, this.gssMode);
        GssSocketFactory factory = GssSocketFactory.getDefault();
        GssSocket gsiSocket = (GssSocket)factory.createSocket(socket, null, 0, context);
        gsiSocket.setUseClientMode(false);
        LocalMappingAuthorization authorizer = this.createAuthorizer();
        gsiSocket.setAuthorization(authorizer);
        return new Peer(gsiSocket, authorizer);
    }

    public void setGssMode(Integer mode) {
        this.gssMode = mode;
    }

    public void setAuthorizationClass(String auth) {
        this.authzClassName = auth;
    }

    protected abstract void handleConnection(Peer var1);

    public void registerDefaultDeactivator() {
        if (this.deactivator == null) {
            this.deactivator = new AbstractServerDeactivator(this);
        }
        Deactivator.registerDeactivation(this.deactivator);
    }

    public void unregisterDefaultDeactivator() {
        if (this.deactivator == null) {
            return;
        }
        Deactivator.unregisterDeactivation(this.deactivator);
    }
}

