/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import lia.util.net.common.FileChannelProviderFactory;
import lia.util.net.common.InvalidFDTParameterException;
import lia.util.net.common.LocalHost;
import lia.util.net.common.MassStorage;
import lia.util.net.common.NetMatcher;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTMain;
import lia.util.net.copy.PosixFSFileChannelProviderFactory;
import org.opentsdb.client.HttpClientImpl;

public class Config {
    public static final int NETWORK_BUFF_LEN_SIZE;
    public static final String[] SINGLE_CMDLINE_ARGS;
    public static final String[] VALUE_CMDLINE_ARGS;
    public static final String[] POSSIBLE_VALUE_CMDLINE_ARGS;
    public static final String REGEX_REMAP_DELIMITER = "(\\s)+/(\\s)+";
    public static final String FDT_MAJOR_VERSION = "0";
    public static final String FDT_MINOR_VERSION = "26";
    public static final String FDT_MAINTENANCE_VERSION = "3";
    public static final String FDT_FULL_VERSION = "0.26.3";
    public static final String FDT_RELEASE_DATE = "2021-03-31";
    public static final String FDT_RELEASE_TIME = "2247";
    public static final int HEADER_SIZE = 56;
    public static final int HEADER_SIZE_v2 = 56;
    public static final boolean TRACK_ALLOCATIONS = true;
    public static final int KILO = 1024;
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    public static final Object BIG_FDTAPP_LOCK;
    public static final int DEFAULT_SOCKET_NO = 4;
    public static final int DEFAULT_PORT_NO = 54321;
    public static final int DEFAULT_TRANSFER_PORT_NO = 43210;
    public static final long DEFAULT_KEEP_ALIVE_NANOS;
    public static final int DEFAULT_PORT_NO_GSI = 54320;
    public static final int DEFAULT_PORT_NO_SSH = 22;
    public static final int SSH_NO_REMOTE = -1;
    public static final int SSH_REMOTE_SERVER_LOCAL_CLIENT_PUSH = 1;
    public static final int SSH_REMOTE_SERVER_LOCAL_CLIENT_PULL = 2;
    public static final int SSH_REMOTE_SERVER_REMOTE_CLIENT_PUSH = 3;
    public static final String APMON = "APMON";
    public static final String OPENTSDB = "OPENTSDB";
    private static final Logger logger;
    private static final String[] exportedSysProps;
    private static volatile Config _thisInstance;
    private final boolean isNagleEnabled;
    private final boolean isStandAlone;
    private final String sshKeyPath;
    private String apMonHosts;
    private final boolean isLisaRestartEnabled;
    private final String writeMode;
    private final String preFilters;
    private final String postFilters;
    private final String monID;
    private final boolean isNetTest;
    private final boolean isGenTest;
    private final long keepAliveDelayNanos;
    private final FileChannelProviderFactory fileChannelProviderFactory;
    private int byteBufferSize;
    private boolean isPullMode;
    private boolean isCoordinatorMode;
    private boolean isRetrievingLogFile;
    private boolean isThirdPartyCopyAgent;
    private int sockNum;
    private int sockBufSize;
    private long rateLimit;
    private long rateLimitDelayMillis;
    private int readersCount;
    private int writersCount;
    private int maxPartitionsCount;
    private String hostname;
    private String lisaHost;
    private int lisaPort;
    private int portNo;
    private int portNoGSI;
    private int portNoSSH;
    private int destPort;
    private int remoteTransferPort;
    private ArrayBlockingQueue<Integer> transportPorts;
    private final List<Object> tp;
    private String[] fileList;
    private String[] remappedFileList;
    private String destDir;
    private String listFilesFrom;
    private String sIP;
    private String dIP;
    private String opentsdb;
    private String opentsdbProtocol;
    private boolean bComputeMD5;
    private boolean bRecursive;
    private boolean bCheckUpdate;
    private boolean isBlocking;
    private boolean bUseFixedBlocks;
    private boolean bLocalLoop;
    private boolean bLoop;
    private NetMatcher sourceAddressFilter;
    private int IORetryFactor;
    private int selectorsNo;
    private boolean bDisableLisa;
    private long lisaReportInterval;
    private long apMonReportInterval;
    private boolean bSSHMode;
    private boolean autoPort;
    private int portRange;
    private boolean bGSISSHMode;
    private boolean bGSIMode;
    private String[] aSourceUsers;
    private String[] aSourceHosts;
    private String sDestinationUser;
    private String sLocalAddresses;
    private String sStartServerCommand;
    private String logLevel;
    private String massStorageConfig;
    private String massStorageType;
    private MassStorage storageParams;
    private Level statsLevel;
    private Map<String, Object> configMap;
    private boolean isNoTmpFlagSet;
    private boolean isNoLockFlagSet;
    private long consoleReportingTaskDelay;
    private Map<String, Integer> sessionPortMap;
    private Map<Integer, List<Object>> sessionSocketMap;
    private HttpClientImpl httpClient;

    private Config(Map<String, Object> configMap) throws InvalidFDTParameterException {
        block62: {
            List lastParams;
            block60: {
                block61: {
                    block59: {
                        long ka;
                        this.byteBufferSize = 0x100000;
                        this.isPullMode = false;
                        this.sockNum = 4;
                        this.sockBufSize = -1;
                        this.rateLimit = -1L;
                        this.rateLimitDelayMillis = 300L;
                        this.readersCount = 1;
                        this.writersCount = 1;
                        this.maxPartitionsCount = 100;
                        this.opentsdb = null;
                        this.opentsdbProtocol = System.getProperty("opentsdb.protocol", "http://");
                        this.bComputeMD5 = false;
                        this.bRecursive = false;
                        this.bCheckUpdate = false;
                        this.isBlocking = false;
                        this.bUseFixedBlocks = false;
                        this.bLocalLoop = false;
                        this.bLoop = false;
                        this.sourceAddressFilter = null;
                        this.IORetryFactor = 2;
                        this.selectorsNo = 1;
                        this.bDisableLisa = false;
                        this.lisaReportInterval = 20L;
                        this.apMonReportInterval = 20L;
                        this.bSSHMode = false;
                        this.autoPort = false;
                        this.portRange = 100;
                        this.bGSISSHMode = false;
                        this.bGSIMode = false;
                        this.aSourceUsers = null;
                        this.aSourceHosts = null;
                        this.sDestinationUser = null;
                        this.sLocalAddresses = null;
                        this.sStartServerCommand = null;
                        this.massStorageConfig = null;
                        this.massStorageType = null;
                        this.storageParams = null;
                        this.statsLevel = null;
                        this.isNoTmpFlagSet = false;
                        this.isNoLockFlagSet = false;
                        this.consoleReportingTaskDelay = 5L;
                        this.sessionPortMap = new HashMap<String, Integer>();
                        this.sessionSocketMap = new HashMap<Integer, List<Object>>();
                        this.httpClient = null;
                        this.configMap = configMap;
                        if (configMap == null) {
                            throw new InvalidFDTParameterException("Null config map");
                        }
                        for (String exportedSysProp : exportedSysProps) {
                            configMap.put(exportedSysProp, System.getProperty(exportedSysProp));
                        }
                        this.isStandAlone = configMap.get("-S") == null;
                        this.setRetrievingLogFile(configMap.get("-sID"));
                        this.byteBufferSize = Utils.getIntValue(configMap, "-bs", 0x100000);
                        configMap.put("-bs", String.valueOf(this.byteBufferSize));
                        this.sockNum = Utils.getIntValue(configMap, "-P", 4);
                        configMap.put("-P", String.valueOf(this.sockNum));
                        this.sockBufSize = Utils.getIntValue(configMap, "-ss", -1);
                        configMap.put("-ss", String.valueOf(this.sockBufSize));
                        this.rateLimit = Utils.getLongValue(configMap, "-limit", -1L);
                        if (this.rateLimit > 0L && this.rateLimit < (long)NETWORK_BUFF_LEN_SIZE) {
                            this.rateLimit = NETWORK_BUFF_LEN_SIZE;
                            logger.log(Level.INFO, " The rate limit (-limit) is too small. It will be set to " + this.rateLimit + " Bytes/s");
                        }
                        configMap.put("-limit", String.valueOf(this.rateLimit));
                        this.rateLimitDelayMillis = Utils.getLongValue(configMap, "-limitDelay", 300L);
                        configMap.put("-limitDelay", String.valueOf(this.rateLimitDelayMillis));
                        this.preFilters = Utils.getStringValue(configMap, "-preFilters", null);
                        this.postFilters = Utils.getStringValue(configMap, "-postFilters", null);
                        this.monID = Utils.getStringValue(configMap, "-monID", null);
                        this.massStorageConfig = Utils.getStringValue(configMap, "-ms", null);
                        this.massStorageType = Utils.getStringValue(configMap, "-mst", null);
                        this.opentsdb = Utils.getStringValue(configMap, "-opentsdb", "localhost:4242");
                        try {
                            if (this.massStorageType() != null && this.massStorageType().equals("dcache")) {
                                System.setProperty("lia.util.net.common.FileChannelProviderFactory", "edu.caltech.hep.dcapj.dCacheFileChannelProviderFactory");
                            }
                        }
                        catch (Throwable e) {
                            System.err.println("FDT was unable to set the FileChannelProviderFactory env variable");
                            e.printStackTrace();
                            System.out.flush();
                            System.err.flush();
                            System.exit(2502);
                        }
                        String className = System.getProperty("lia.util.net.common.FileChannelProviderFactory");
                        FileChannelProviderFactory tmpFCPF = null;
                        if (className != null) {
                            logger.log(Level.INFO, "Trying to load user defined FileChannelProviderFactory: " + className);
                            try {
                                Class<?> c = Class.forName(className, true, ClassLoader.getSystemClassLoader());
                                tmpFCPF = (FileChannelProviderFactory)c.newInstance();
                            }
                            catch (Throwable t) {
                                throw new InvalidFDTParameterException("Unable to load the FileChannelProviderFactory", t);
                            }
                        } else {
                            tmpFCPF = new PosixFSFileChannelProviderFactory();
                        }
                        this.fileChannelProviderFactory = tmpFCPF;
                        if (this.fileChannelProviderFactory == null) {
                            throw new InvalidFDTParameterException("The FileChannelProviderFactory cannot be null!");
                        }
                        logger.log(Level.INFO, "Using " + this.fileChannelProviderFactory.getClass().getName() + " as FileChannelProviderFactory");
                        this.hostname = Utils.getStringValue(configMap, "-c", null);
                        if (this.hostname != null && this.hostname.length() == 0) {
                            this.hostname = null;
                        } else {
                            boolean bl = this.isPullMode = configMap.get("-pull") != null || configMap.get("-sID") != null;
                            if (this.isPullMode) {
                                configMap.put("-pull", "");
                            }
                        }
                        boolean bl = this.autoPort = configMap.get("-autoport") != null;
                        if (this.autoPort) {
                            this.portRange = Utils.getIntValue(configMap, "-portRange", 100);
                        }
                        this.keepAliveDelayNanos = (ka = Utils.getLongValue(configMap, "-ka", TimeUnit.NANOSECONDS.toSeconds(DEFAULT_KEEP_ALIVE_NANOS))) < 0L ? DEFAULT_KEEP_ALIVE_NANOS : TimeUnit.SECONDS.toNanos(ka);
                        configMap.put("-ka", String.valueOf(TimeUnit.NANOSECONDS.toSeconds(this.keepAliveDelayNanos)));
                        this.portNo = Utils.getIntValue(configMap, "-p", 54321);
                        this.transportPorts = Utils.getTransportPortsValue(configMap, "-tp", 43210);
                        this.tp = Arrays.asList(this.transportPorts.toArray());
                        this.isCoordinatorMode = configMap.get("-coord") != null;
                        this.isThirdPartyCopyAgent = configMap.get("-agent") != null;
                        this.portNoGSI = Utils.getIntValue(configMap, "-gsip", 54320);
                        this.portNoSSH = Utils.getIntValue(configMap, "-sshp", 22);
                        this.IORetryFactor = Utils.getIntValue(configMap, "-iof", 1);
                        int avP = Runtime.getRuntime().availableProcessors();
                        if (avP < 1) {
                            avP = 1;
                        }
                        this.selectorsNo = Utils.getIntValue(configMap, "-sn", avP);
                        this.readersCount = Utils.getIntValue(configMap, "-rCount", 1);
                        this.writersCount = Utils.getIntValue(configMap, "-wCount", 1);
                        this.maxPartitionsCount = Utils.getIntValue(configMap, "-pCount", 100);
                        this.consoleReportingTaskDelay = Utils.getLongValue(configMap, "-reportDelay", 5L);
                        this.isNagleEnabled = configMap.get("-N") != null;
                        this.isNetTest = configMap.get("-nettest") != null;
                        this.isGenTest = configMap.get("-genb") != null;
                        this.bGSIMode = configMap.get("-gsi") != null;
                        boolean bl2 = this.isBlocking = configMap.get("-bio") != null;
                        if (!this.isBlocking) {
                            this.isBlocking = configMap.get("-nbio") == null;
                        }
                        this.apMonHosts = Utils.getStringValue(configMap, "-enable_apmon", null);
                        this.bRecursive = configMap.get("-r") != null;
                        this.bUseFixedBlocks = configMap.get("-fbs") != null;
                        this.bLocalLoop = configMap.get("-ll") != null;
                        this.bLoop = configMap.get("-loop") != null;
                        this.isLisaRestartEnabled = configMap.get("-enableLisaRestart") != null;
                        this.bCheckUpdate = configMap.get("-u") != null;
                        this.destDir = Utils.getStringValue(configMap, "-d", null);
                        this.sIP = Utils.getStringValue(configMap, "-sIP", null);
                        this.dIP = Utils.getStringValue(configMap, "-dIP", null);
                        this.destPort = Utils.getIntValue(configMap, "-dp", -1);
                        this.remoteTransferPort = -1;
                        this.listFilesFrom = Utils.getStringValue(configMap, "-ls", null);
                        this.bComputeMD5 = configMap.get("-md5") != null;
                        this.sshKeyPath = Utils.getStringValue(configMap, "-sshKey", null);
                        if (this.isNetTest) {
                            this.destDir = "/dev/null";
                            List lastParams2 = (List)configMap.get("LastParams");
                            lastParams2.add("/dev/zero");
                        }
                        if (this.hostname != null && (this.destDir == null || this.destDir.length() == 0) && this.listFilesFrom == null) {
                            throw new IllegalArgumentException("No destination specified");
                        }
                        if (this.massStorageConfig != null) {
                            this.storageParams = new MassStorage();
                            if (!this.storageParams.init(this.massStorageConfig)) {
                                throw new IllegalArgumentException("Invalid mass storage configuration file");
                            }
                        }
                        if (configMap.get("-printStats") != null) {
                            this.statsLevel = Level.INFO;
                        }
                        this.isNoTmpFlagSet = configMap.get("-notmp") != null;
                        this.isNoLockFlagSet = configMap.get("-nolock") != null || configMap.get("-nolocks") != null;
                        this.writeMode = Utils.getStringValue(configMap, "-writeMode", null);
                        String sLisa = Utils.getStringValue(configMap, "-lisafdtclient", null);
                        if (sLisa == null) {
                            sLisa = Utils.getStringValue(configMap, "-lisafdtserver", null);
                            if (sLisa != null) {
                                sLisa = Utils.getStringValue(configMap, "-lisafdtserver", "127.0.0.1:11001");
                            }
                        } else {
                            sLisa = Utils.getStringValue(configMap, "-lisafdtclient", "127.0.0.1:11001");
                        }
                        if (sLisa == null) {
                            this.bDisableLisa = true;
                        }
                        this.lisaReportInterval = Utils.getIntValue(configMap, "-lisa_rep_delay", 20);
                        this.apMonReportInterval = Utils.getIntValue(configMap, "-apmon_rep_delay", 20);
                        this.lisaHost = null;
                        this.lisaPort = -1;
                        if (!this.bDisableLisa) {
                            try {
                                int idx = sLisa.indexOf(":");
                                if (idx > 0) {
                                    this.lisaHost = sLisa.substring(0, idx);
                                    this.lisaPort = Integer.parseInt(sLisa.substring(idx + 1));
                                } else if (idx == 0) {
                                    this.lisaHost = "127.0.0.1";
                                    this.lisaPort = Integer.parseInt(sLisa.substring(1));
                                } else {
                                    this.lisaHost = sLisa;
                                    this.lisaPort = 11001;
                                }
                            }
                            catch (Throwable t) {
                                if (this.lisaHost == null) {
                                    this.lisaHost = "127.0.0.1";
                                }
                                if (this.lisaPort != -1) break block59;
                                this.lisaPort = 11001;
                            }
                        }
                    }
                    if (configMap.get("SCPSyntaxUsed") != null) {
                        String[] aSourceHosts;
                        String[] aSourceUsers;
                        if (configMap.get("-gsissh") != null) {
                            this.bGSISSHMode = true;
                        }
                        this.bSSHMode = true;
                        Object oSrc = configMap.get("sourceUsers");
                        if (oSrc != null && (aSourceUsers = (String[])oSrc).length > 0) {
                            this.aSourceUsers = aSourceUsers;
                        }
                        if ((oSrc = configMap.get("sourceHosts")) != null && (aSourceHosts = (String[])oSrc).length > 0) {
                            this.aSourceHosts = aSourceHosts;
                        }
                        this.sDestinationUser = Utils.getStringValue(configMap, "destinationUser", System.getProperty("user.name"));
                        this.sLocalAddresses = Utils.getStringValue(configMap, "-local", null);
                        this.sStartServerCommand = Utils.getStringValue(configMap, "-remote", "java -jar fdt.jar");
                    }
                    if (configMap.containsKey("-f") && !configMap.containsKey("-F")) {
                        String sAllowedHosts = Utils.getStringValue(configMap, "-f", "");
                        if (sAllowedHosts.trim().length() == 0) {
                            sAllowedHosts = System.getenv("SSH_CLIENT");
                            if (sAllowedHosts != null) {
                                sAllowedHosts = sAllowedHosts.split("(\\s)+")[0];
                            }
                            if (sAllowedHosts == null || sAllowedHosts.length() == 0) {
                                throw new InvalidFDTParameterException("source filter used but no host/ip supplied");
                            }
                        }
                        this.sourceAddressFilter = new NetMatcher(sAllowedHosts.split(":"));
                    }
                    if ((lastParams = (List)configMap.get("LastParams")) != null && !lastParams.isEmpty()) break block60;
                    String fList = Utils.getStringValue(configMap, "-fl", null);
                    if (fList == null || fList.length() == 0) break block61;
                    ArrayList<String> arrayFileList = new ArrayList<String>();
                    ArrayList<String> remappedArrayFileList = new ArrayList<String>();
                    BufferedReader br = null;
                    FileReader fr = null;
                    try {
                        Pattern splitPattern = Pattern.compile(REGEX_REMAP_DELIMITER);
                        fr = new FileReader(fList);
                        br = new BufferedReader(fr);
                        String line = br.readLine();
                        while (line != null) {
                            String[] tkns = splitPattern.split(line);
                            int tknsCount = tkns.length;
                            if (tknsCount == 1) {
                                arrayFileList.add(line);
                                remappedArrayFileList.add(null);
                            } else if (tknsCount == 2) {
                                arrayFileList.add(tkns[0]);
                                remappedArrayFileList.add(tkns[1]);
                            } else {
                                throw new IllegalArgumentException("The line=" + line + ", from -fl parameter cannot be parsed");
                            }
                            line = br.readLine();
                        }
                        this.remappedFileList = remappedArrayFileList.toArray(new String[0]);
                        this.fileList = arrayFileList.toArray(new String[0]);
                    }
                    catch (Throwable t) {
                        try {
                            throw new IllegalArgumentException("Unable to decode file list", t);
                        }
                        catch (Throwable throwable) {
                            Utils.closeIgnoringExceptions(fr);
                            Utils.closeIgnoringExceptions(br);
                            throw throwable;
                        }
                    }
                    Utils.closeIgnoringExceptions(fr);
                    Utils.closeIgnoringExceptions(br);
                    break block62;
                }
                if (configMap.get("-sID") != null) {
                    String sessionID = (String)configMap.get("-sID");
                    String[] logFiles = this.getLogFiles(sessionID);
                    this.remappedFileList = logFiles;
                    this.fileList = logFiles;
                }
                break block62;
            }
            configMap.remove("-fl");
            this.fileList = lastParams.toArray(new String[lastParams.size()]);
            if (this.fileList != null && this.fileList.length == 0) {
                this.fileList = null;
            }
        }
        Object files = configMap.get("Files");
        if (files != null && files instanceof String[] && ((String[])files).length > 0) {
            this.fileList = (String[])files;
        }
        logger.log(Level.INFO, "FDT started in {0} mode", this.getFDTMode(configMap));
        if (this.hostname != null) {
            if (logger.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Source file list --> remaped file list:\n");
                boolean bRemapFLNull = this.remappedFileList == null;
                for (int i = 0; this.fileList != null && i < this.fileList.length; ++i) {
                    sb.append(this.fileList[i]).append(" ---> ").append(bRemapFLNull || this.remappedFileList[i] == null ? " default mapping: " + this.fileList[i] : " remapped to: " + this.remappedFileList[i]).append("\n");
                }
                logger.log(Level.FINE, sb.toString());
                logger.log(Level.FINE, "Remote destination directory: {0}\nRemote host: {1} port: {2}", new Object[]{this.destDir, this.hostname, this.portNo});
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.INFO, "Local server will try to bind on port:{0}", this.portNo);
        }
    }

    public String getMonitor() {
        if (this.configMap.get("-opentsdb") != null) {
            return OPENTSDB;
        }
        if (this.configMap.get("-apmon") != null) {
            return APMON;
        }
        return APMON;
    }

    public void initOpenTSDBMonitorClient() {
        this.httpClient = new HttpClientImpl(this.opentsdbProtocol + this.getOpentsdb());
    }

    public String getFDTTag() {
        return Utils.getStringValue(this.configMap, "-fdtTAG", "DEFAULT_FDT_TAG");
    }

    public void setFDTTag(String fdtTag) {
        this.configMap.put("-fdtTAG", fdtTag);
    }

    public HttpClientImpl getOpenTSDBMonitorClient() {
        return this.httpClient;
    }

    private static final int getMinMTU() {
        int retMTU = 1500;
        try {
            Enumeration<NetworkInterface> netInterfacesEnum = NetworkInterface.getNetworkInterfaces();
            while (netInterfacesEnum.hasMoreElements()) {
                NetworkInterface netInteface = netInterfacesEnum.nextElement();
                try {
                    if (!netInteface.isUp()) {
                        continue;
                    }
                }
                catch (NoSuchMethodError nsme) {
                    if (logger.isLoggable(Level.FINE)) {
                        System.out.println("The current JVM is not able to determine if the net interface " + netInteface + "is up and running. JVM >= 1.6 should support this feature");
                    }
                    return retMTU;
                }
                catch (Throwable t) {
                    System.err.println(" Cannot determine if the interface: " + netInteface + " is up");
                    return retMTU;
                }
                int cMTU = -1;
                try {
                    cMTU = netInteface.getMTU();
                }
                catch (SocketException se) {
                    System.err.println(" Cannot get MTU for netInterface: " + netInteface + " SocketException: " + se);
                }
                catch (NoSuchMethodError nsme) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    System.out.println("The current JVM is not able to determine the MTU for the net interface " + netInteface + "is up and running. JVM >= 1.6 should support this feature");
                    continue;
                }
                catch (Throwable t) {
                    System.err.println(" Cannot get MTU for netInterface: " + netInteface + " Exception: " + t);
                }
                if (cMTU >= retMTU || cMTU <= 0) continue;
                retMTU = cMTU;
            }
        }
        catch (SocketException se) {
            System.err.println(" Cannot get min MTU for current instance of FDT. SocketException: " + se);
        }
        catch (Throwable t) {
            System.err.println(" Cannot get min MTU for current instance of FDT. Exception: " + t);
        }
        return retMTU;
    }

    public static int getBulkSockConnect() {
        return 30;
    }

    public static long getBulkSockConnectWait() {
        return 1500L;
    }

    public static final String getUsage() {
        return Utils.getUsage();
    }

    public static int getMaxTakePollIter() {
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Config getInstance() {
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            while (_thisInstance == null) {
                try {
                    Config.class.wait();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _thisInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void initInstance(Map<String, Object> configMap) throws Exception {
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (_thisInstance == null) {
                _thisInstance = new Config(configMap);
            }
            Config.class.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void closeSessionRelatedSocks(List<Object> socks) {
        if (socks != null) {
            for (Object o : socks) {
                if (o instanceof ServerSocketChannel) {
                    try {
                        ((ServerSocketChannel)o).close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to close ServerSocketChannel", e);
                    }
                }
                if (o instanceof ServerSocket) {
                    try {
                        ((ServerSocket)o).close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to close ServerSocket", e);
                    }
                }
                if (o instanceof SocketChannel) {
                    try {
                        ((SocketChannel)o).close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Failed to close SocketChannel", e);
                    }
                }
                if (!(o instanceof Socket)) continue;
                try {
                    ((Socket)o).close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close Socket", e);
                }
            }
        }
    }

    private String[] getLogFiles(String sessionID) {
        return new String[]{"/tmp/" + sessionID + ".log"};
    }

    public String getListFilesFrom() {
        return this.listFilesFrom;
    }

    public void setListFilesFrom(String listFilesFrom) {
        this.listFilesFrom = listFilesFrom;
    }

    private String getFDTMode(Map<String, Object> configMap) {
        if (configMap.get("-coord") != null) {
            return "coordinator";
        }
        if (configMap.get("-ls") != null) {
            return "list files";
        }
        if (configMap.get("-agent") != null) {
            return "agent worker";
        }
        return this.hostname == null && configMap.get("SCPSyntaxUsed") == null ? "server" : "client";
    }

    public long getKeepAliveDelay(TimeUnit unit) {
        return unit.convert(this.keepAliveDelayNanos, TimeUnit.NANOSECONDS);
    }

    public Map<String, Object> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<String, Object> configMap) {
        this.configMap = configMap;
    }

    public long getReportingTaskDelay() {
        return this.consoleReportingTaskDelay;
    }

    public Level getStatsLevel() {
        return this.statsLevel;
    }

    public String getMonID() {
        return this.monID;
    }

    public int getRetryIOCount() {
        return this.IORetryFactor;
    }

    public int getByteBufferSize() {
        return this.byteBufferSize;
    }

    public boolean isNagleEnabled() {
        return this.isNagleEnabled;
    }

    public boolean isGSIModeEnabled() {
        return this.bGSIMode;
    }

    public int getSockNum() {
        return this.sockNum;
    }

    public long getLisaReportingInterval() {
        return this.lisaReportInterval;
    }

    public long getApMonReportingInterval() {
        return this.apMonReportInterval;
    }

    public long getRateLimit() {
        return this.rateLimit;
    }

    public long getRateLimitDelay() {
        return this.rateLimitDelayMillis;
    }

    public int getSockBufSize() {
        return this.sockBufSize;
    }

    public String getLisaHost() {
        return this.lisaHost;
    }

    public int getLisaPort() {
        return this.lisaPort;
    }

    public void setLisaPort(int lisaPort) {
        this.lisaPort = lisaPort;
    }

    public String getSshKeyPath() {
        return this.sshKeyPath;
    }

    public boolean isNoTmpFlagSet() {
        return this.isNoTmpFlagSet;
    }

    public boolean isNoLockFlagSet() {
        return this.isNoLockFlagSet;
    }

    public String getHostName() {
        if (this.configMap.get("-agent") != null) {
            return this.dIP;
        }
        return this.hostname;
    }

    public void setHostName(String hostname) {
        this.configMap.put("-destinationHost", hostname);
        this.hostname = hostname;
    }

    public int getPort() {
        return this.portNo;
    }

    public int getDefaultPort() {
        return 54321;
    }

    public int getGSIPort() {
        return this.portNoGSI;
    }

    public void setGSIPort(int port) {
        this.portNoGSI = port;
    }

    public int getSSHPort() {
        return this.portNoSSH;
    }

    public void setSSHPort(int port) {
        this.portNoSSH = port;
    }

    public void setPortNo(int port) {
        this.portNo = port;
    }

    public boolean isStandAlone() {
        return this.isStandAlone;
    }

    public String getWriteMode() {
        return this.writeMode;
    }

    public String[] getFileList() {
        return this.fileList;
    }

    public void setFileList(String[] fileList) {
        this.fileList = fileList;
    }

    public String[] getRemappedFileList() {
        return this.remappedFileList;
    }

    public String getPreFilters() {
        return this.preFilters;
    }

    public String getPostFilters() {
        return this.postFilters;
    }

    public String getDestinationDir() {
        return this.destDir;
    }

    public void setDestinationDir(String destDir) {
        this.destDir = destDir;
    }

    public int getDestinationPort() {
        return this.destPort;
    }

    public void setDestinationPort(int destPort) {
        this.destPort = destPort;
    }

    public void registerTransferPortForSession(int newTransferPort, String sessionID) {
        this.sessionPortMap.put(sessionID, newTransferPort);
    }

    public int getNewRemoteTransferPort() {
        try {
            if (this.autoPort) {
                return this.getRandomPort(this.getDefaultPort());
            }
            if (!this.transportPorts.isEmpty()) {
                int rtp = this.transportPorts.poll(20L, TimeUnit.SECONDS);
                System.out.println("Took new remote transfer port " + rtp);
                return rtp;
            }
        }
        catch (Exception e) {
            if (this.transportPorts.size() == 0) {
                logger.log(Level.WARNING, "No transfer ports defined or no free transfer ports left...", e);
            }
            logger.log(Level.WARNING, "Failed to retrieve remote transfer port", e);
        }
        return -1;
    }

    private int getRandomPort(int defaultPort) {
        int randomPort = -1;
        try {
            Random r = new Random();
            randomPort = r.nextInt(defaultPort + this.portRange - defaultPort + 1) + defaultPort;
            logger.log(Level.INFO, "Auto FDT on port " + randomPort);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    new FDTMain();
                }
            }, "FDT custom port " + randomPort).start();
        }
        catch (Exception e) {
            logger.log(Level.INFO, " FAILED auto FDT on port " + randomPort);
        }
        return randomPort;
    }

    public void setSessionSocket(ServerSocketChannel ssc, ServerSocket ss, SocketChannel sc, Socket s, int port) {
        ArrayList<Closeable> socks = new ArrayList<Closeable>();
        socks.add(ssc);
        socks.add(ss);
        socks.add(sc);
        socks.add(s);
        this.sessionSocketMap.put(port, socks);
    }

    public void releaseRemoteTransferPort(String sessionID) {
        if (this.sessionPortMap.keySet().contains(sessionID)) {
            logger.log(Level.FINER, "Trying to release transfer port from session " + sessionID);
            int sessionPort = this.sessionPortMap.get(sessionID);
            if (sessionPort > 0) {
                try {
                    this.transportPorts.put(sessionPort);
                    this.sessionPortMap.remove(sessionID);
                    Config.closeSessionRelatedSocks(this.sessionSocketMap.get(sessionPort));
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Failed to release remote transfer port: " + this.remoteTransferPort, e);
                }
            }
        }
    }

    public int getRemoteTransferPort() {
        return this.remoteTransferPort;
    }

    public List<Object> getRemoteTransferPorts() {
        return this.tp;
    }

    public void setRemoteTransferPort(int remoteTransferPort) {
        this.remoteTransferPort = remoteTransferPort;
    }

    public String getSourceIP() {
        return this.sIP;
    }

    public String getDestinationIP() {
        return this.dIP;
    }

    public void setDestinationIP(String dIP) {
        this.dIP = dIP;
    }

    public int getNumberOfSelectors() {
        return this.selectorsNo;
    }

    public String getApMonHosts() {
        return this.apMonHosts;
    }

    public void setApMonHosts(String apMonHosts) {
        this.apMonHosts = apMonHosts;
    }

    public boolean isCoordinatorMode() {
        return this.isCoordinatorMode;
    }

    public void setCoordinatorMode(boolean coordinatorMode) {
        this.isCoordinatorMode = coordinatorMode;
        if (coordinatorMode) {
            this.configMap.put("-coord", true);
        } else {
            this.configMap.remove("-coord");
        }
    }

    public boolean isListFilesMode() {
        return this.listFilesFrom != null && this.configMap.get("-ls") != null;
    }

    public boolean isRetrievingLogFile() {
        return this.isRetrievingLogFile || this.configMap.containsKey("-sID");
    }

    public void setRetrievingLogFile(Object sessionID) {
        boolean bl = this.isRetrievingLogFile = sessionID != null;
        if (this.isRetrievingLogFile) {
            this.configMap.put("-sID", (String)sessionID);
        } else {
            this.configMap.remove("-sID");
        }
    }

    public boolean isPullMode() {
        return this.isPullMode;
    }

    public void setPullMode(boolean pullMode) {
        this.isPullMode = pullMode;
        if (pullMode) {
            this.configMap.put("-pull", true);
        } else {
            this.configMap.remove("-pull");
        }
    }

    public boolean shouldUpdate() {
        return this.bCheckUpdate;
    }

    public boolean isRecursive() {
        return this.bRecursive;
    }

    public boolean isLisaDisabled() {
        return this.bDisableLisa;
    }

    public boolean loop() {
        return this.bLoop;
    }

    public boolean localLoop() {
        return this.bLocalLoop;
    }

    public boolean useFixedBlocks() {
        return this.bUseFixedBlocks;
    }

    public NetMatcher getSourceAddressFilter() {
        return this.sourceAddressFilter;
    }

    public boolean computeMD5() {
        return this.bComputeMD5;
    }

    public boolean isSSHModeEnabled() {
        return this.bSSHMode;
    }

    public boolean isGSISSHModeEnabled() {
        return this.bGSISSHMode;
    }

    public int getReadersCount() {
        return this.readersCount;
    }

    public int getWritersCount() {
        return this.writersCount;
    }

    public int getMaxPartitionCount() {
        return this.maxPartitionsCount;
    }

    public int getSSHConfig() {
        if (!this.bSSHMode) {
            return -1;
        }
        String sDestinationHost = Utils.getStringValue(this.configMap, "destinationHost", null);
        if ((this.aSourceHosts == null || this.aSourceHosts.length == 0 || this.aSourceHosts[0] == null) && sDestinationHost != null) {
            return 1;
        }
        if (this.aSourceHosts != null && this.aSourceHosts.length > 0 && sDestinationHost == null) {
            return 2;
        }
        return 3;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public String getDestinationUser() {
        return this.sDestinationUser;
    }

    public boolean isLisaRestartEnabled() {
        return this.isLisaRestartEnabled;
    }

    public String getLocalAddresses() {
        return this.sLocalAddresses == null ? LocalHost.getStringPublicIPs4() : this.sLocalAddresses;
    }

    public String getRemoteCommand() {
        return this.sStartServerCommand;
    }

    public String[] getSourceUsers() {
        return this.aSourceUsers;
    }

    public String[] getSourceHosts() {
        return this.aSourceHosts;
    }

    public String massStorageConfig() {
        return this.massStorageConfig;
    }

    public String massStorageType() {
        return this.massStorageType;
    }

    public MassStorage storageParams() {
        return this.storageParams;
    }

    public boolean isNetTest() {
        return this.isNetTest;
    }

    public boolean isGenTest() {
        return this.isGenTest;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public FileChannelProviderFactory getFileChannelProviderFactory() {
        return this.fileChannelProviderFactory;
    }

    public boolean isThirdPartyCopyAgent() {
        return this.isThirdPartyCopyAgent;
    }

    public void setThirdPartyCopyAgent(boolean isThirdPartyCopyAgent) {
        this.isThirdPartyCopyAgent = isThirdPartyCopyAgent;
        if (isThirdPartyCopyAgent) {
            this.configMap.put("-agent", true);
        } else {
            this.configMap.remove("-agent");
        }
    }

    public String getListenAddress() {
        return (String)this.configMap.get("-FDT_LISTEN");
    }

    public String getOpentsdb() {
        return this.opentsdb;
    }

    public void setOpentsdb(String opentsdb) {
        this.opentsdb = opentsdb;
    }

    static {
        int defaultMSSSize;
        SINGLE_CMDLINE_ARGS = new String[]{"-v", "-vv", "-vvv", "-loop", "-r", "-pull", "-printStats", "-N", "-bio", "-gsi", "-gsissh", "-notmp", "-nolock", "-nolocks", "-nettest", "-genb", "-autoport"};
        VALUE_CMDLINE_ARGS = new String[]{"-bs", "-P", "-ss", "-limit", "-preFilters", "-postFilters", "-monID", "-ms", "-c", "-p", "-sshp", "-gsip", "-iof", "-sn", "-rCount", "-wCount", "-pCount", "-d", "-writeMode", "-lisa_rep_delay", "-apmon_rep_delay", "-fl", "-reportDelay", "-ka", "-tp"};
        POSSIBLE_VALUE_CMDLINE_ARGS = new String[]{"-enable_apmon", "-lisafdtclient", "-lisafdtserver", "-f", "-F", "-h", "-H", "--help", "-help,-u", "-U", "--update", "-update"};
        BIG_FDTAPP_LOCK = new Object();
        DEFAULT_KEEP_ALIVE_NANOS = TimeUnit.MINUTES.toNanos(2L);
        logger = Logger.getLogger("lia.util.net.common.Config");
        exportedSysProps = new String[]{"user.name", "user.home", "user.dir", "file.separator", "file.encoding", "path.separator"};
        try {
            int minMTU = Config.getMinMTU();
            defaultMSSSize = minMTU - 40;
        }
        catch (Throwable ignore) {
            defaultMSSSize = 1460;
        }
        if (defaultMSSSize < 1000) {
            defaultMSSSize = 1460;
        }
        NETWORK_BUFF_LEN_SIZE = defaultMSSSize;
    }
}

