/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import lia.util.net.common.AbstractBPool;
import lia.util.net.common.Config;
import lia.util.net.copy.monitoring.jmx.DBPoolJMX;

public class DirectByteBufferPool
extends AbstractBPool {
    private static final transient Logger logger = Logger.getLogger(DirectByteBufferPool.class.getName());
    private static DirectByteBufferPool _theInstance;
    private static volatile boolean initialized;

    private DirectByteBufferPool(int bufferSize, int maxPollIter, boolean trackAllocations) {
        super(bufferSize, maxPollIter, trackAllocations, Config.getInstance().isGenTest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final DirectByteBufferPool getInstance() {
        if (initialized) return _theInstance;
        Class<DirectByteBufferPool> clazz = DirectByteBufferPool.class;
        synchronized (DirectByteBufferPool.class) {
            while (!initialized) {
                try {
                    DirectByteBufferPool.class.wait();
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, " Got exception waiting for initialization ", t);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _theInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean initInstance(int buffSize, int maxTakePollIter) {
        Class<DirectByteBufferPool> clazz = DirectByteBufferPool.class;
        synchronized (DirectByteBufferPool.class) {
            if (!initialized) {
                int mMax = maxTakePollIter;
                if (maxTakePollIter < 0) {
                    mMax = 0;
                }
                _theInstance = new DirectByteBufferPool(buffSize, mMax, true);
                initialized = true;
                DirectByteBufferPool.class.notifyAll();
                try {
                    ManagementFactory.getPlatformMBeanServer().registerMBean(new DBPoolJMX(_theInstance), new ObjectName("lia.util.net.copy.monitoring.jmx:type=DBPoolJMX"));
                }
                catch (Throwable ex) {
                    logger.log(Level.WARNING, " Unable to init JMX monitoring for DirectByteBufferPool!", ex);
                }
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    static {
        initialized = false;
    }
}

