/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class LocalHost {
    public static List<String> getPublicIPs4() {
        Enumeration<NetworkInterface> ifs;
        ArrayList<String> ips4 = new ArrayList<String>();
        try {
            ifs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return ips4;
        }
        while (ifs.hasMoreElements()) {
            NetworkInterface iface = ifs.nextElement();
            Enumeration<InetAddress> iad = iface.getInetAddresses();
            while (iad.hasMoreElements()) {
                InetAddress localIP = iad.nextElement();
                if (localIP.isSiteLocalAddress() || localIP.isLoopbackAddress() || !(localIP instanceof Inet4Address)) continue;
                ips4.add(localIP.getHostAddress());
            }
        }
        return ips4;
    }

    public static String getStringPublicIPs4() {
        List<String> ip4s = LocalHost.getPublicIPs4();
        if (ip4s.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String ip : ip4s) {
            sb.append(ip).append(':');
        }
        return sb.length() >= 1 ? sb.deleteCharAt(sb.length() - 1).toString() : "";
    }

    public static List<String> getPublicIPs6() {
        Enumeration<NetworkInterface> ifs;
        ArrayList<String> ips6 = new ArrayList<String>();
        try {
            ifs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return ips6;
        }
        while (ifs.hasMoreElements()) {
            NetworkInterface iface = ifs.nextElement();
            Enumeration<InetAddress> iad = iface.getInetAddresses();
            while (iad.hasMoreElements()) {
                InetAddress localIP = iad.nextElement();
                if (localIP.isSiteLocalAddress() || localIP.isLinkLocalAddress() || localIP.isLoopbackAddress() || !(localIP instanceof Inet6Address)) continue;
                ips6.add(localIP.getHostAddress());
            }
        }
        return ips6;
    }

    public static String getPublicIP4() {
        Enumeration<NetworkInterface> ifs;
        try {
            ifs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
        while (ifs.hasMoreElements()) {
            NetworkInterface iface = ifs.nextElement();
            Enumeration<InetAddress> iad = iface.getInetAddresses();
            while (iad.hasMoreElements()) {
                InetAddress localIP = iad.nextElement();
                if (localIP.isSiteLocalAddress() || localIP.isLoopbackAddress() || !(localIP instanceof Inet4Address)) continue;
                return localIP.getHostAddress();
            }
        }
        return null;
    }

    public static String getPublicIP6() {
        Enumeration<NetworkInterface> ifs;
        try {
            ifs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
        while (ifs.hasMoreElements()) {
            NetworkInterface iface = ifs.nextElement();
            Enumeration<InetAddress> iad = iface.getInetAddresses();
            while (iad.hasMoreElements()) {
                InetAddress localIP = iad.nextElement();
                if (localIP.isSiteLocalAddress() || localIP.isLinkLocalAddress() || localIP.isLoopbackAddress() || !(localIP instanceof Inet6Address)) continue;
                return localIP.getHostAddress();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(LocalHost.getPublicIP4());
        System.out.println(LocalHost.getPublicIP6());
        System.out.println(LocalHost.getPublicIPs4());
        System.out.println(LocalHost.getPublicIPs6());
    }
}

