/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import ch.ethz.ssh2.util.PasswordReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.ControlStream;

public class SSHControlStream
implements ControlStream {
    static final String knownHostPath = System.getProperty("user.home") + "/.ssh/known_hosts";
    static final String idDSAPath = System.getProperty("user.home") + "/.ssh/id_dsa.fdt";
    static final String idRSAPath = System.getProperty("user.home") + "/.ssh/id_rsa.fdt";
    private static final Logger logger = Logger.getLogger(SSHControlStream.class.getName());
    private final String hostname;
    private final String username;
    private final int port;
    private Connection conn;
    private Session sess;
    private String cmd;

    public SSHControlStream(String hostname, String username) {
        this(hostname, username, 22);
    }

    public SSHControlStream(String hostname, String username, int port) {
        this.hostname = hostname;
        this.username = username;
        this.port = port;
    }

    public static void main(String[] args) throws IOException {
        String line;
        SSHControlStream cs = new SSHControlStream(args[0], args[1]);
        cs.startProgram(args[2]);
        StreamGobbler stdout = new StreamGobbler(cs.getProgramStdOut());
        BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        System.out.println("ExitCode:" + cs.getExitCode());
        cs.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void connect() throws IOException {
        this.conn = new Connection(this.hostname, this.port);
        this.conn.connect();
        boolean enableKeyboardInteractive = true;
        boolean enableDSA = true;
        boolean enableRSA = true;
        boolean enableKEY = true;
        String lastError = null;
        int passwordRetry = 0;
        String configSshKeyPath = Config.getInstance().getSshKeyPath();
        File sshKeyPath = null;
        if (configSshKeyPath != null) {
            try {
                sshKeyPath = new File(configSshKeyPath);
                if (!sshKeyPath.exists() || !sshKeyPath.canRead()) {
                    sshKeyPath = null;
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, " [ SSHControlStream ] Unable to check configSshKeyPath", t);
            }
        }
        if (sshKeyPath == null) {
            enableKEY = false;
        }
        while (true) {
            if ((enableKEY || enableDSA || enableRSA) && this.conn.isAuthMethodAvailable(this.username, "publickey")) {
                String password;
                File key;
                if (enableKEY && sshKeyPath != null) {
                    boolean res = false;
                    String password2 = this.getPassword("\n [" + this.username + "@" + this.hostname + "] [Public key authentication] Enter password for SSH private key[" + configSshKeyPath + "]: ");
                    try {
                        res = this.conn.authenticateWithPublicKey(this.username, sshKeyPath, password2);
                    }
                    catch (Exception e) {
                        res = false;
                    }
                    if (res) break;
                    enableKEY = false;
                }
                if (enableDSA) {
                    key = new File(idDSAPath);
                    if (key.exists() && key.canRead()) {
                        boolean res = false;
                        password = this.getPassword("\n [" + this.username + "@" + this.hostname + "] [Public key authentication] Enter password for DSA private key[" + idDSAPath + "]: ");
                        try {
                            res = this.conn.authenticateWithPublicKey(this.username, key, password);
                        }
                        catch (Exception e) {
                            res = false;
                        }
                        if (res) break;
                        lastError = "DSA authentication failed.";
                    }
                    enableDSA = false;
                }
                if (!enableRSA) continue;
                key = new File(idRSAPath);
                if (key.exists() && key.exists()) {
                    boolean res = false;
                    password = this.getPassword("\n[" + this.username + "@" + this.hostname + "] [Public key authentication] Enter password for RSA private key[" + idRSAPath + "]: ");
                    try {
                        res = this.conn.authenticateWithPublicKey(this.username, key, password);
                    }
                    catch (Exception e) {
                        res = false;
                    }
                    if (res) break;
                    lastError = "RSA authentication failed.";
                }
                enableRSA = false;
                continue;
            }
            if (enableKeyboardInteractive && this.conn.isAuthMethodAvailable(this.username, "keyboard-interactive")) {
                InteractiveLogic il = new InteractiveLogic(lastError, "\n[" + this.username + "@" + this.hostname + "]");
                boolean res = false;
                try {
                    res = this.conn.authenticateWithKeyboardInteractive(this.username, il);
                }
                catch (Exception e) {
                    res = false;
                    lastError = "Keyboard-interactive auth failed. " + e.getMessage();
                }
                if (res) break;
                if (il.getPromptCount() == 0) {
                    lastError = "Keyboard-interactive does not work.";
                    enableKeyboardInteractive = false;
                    continue;
                }
                lastError = "Keyboard-interactive auth failed.";
                continue;
            }
            if (!this.conn.isAuthMethodAvailable(this.username, "password")) throw new IOException("No supported authentication methods available.");
            boolean res = false;
            String password = this.getPassword("\n[" + this.username + "@" + this.hostname + "] [Password Authentication] Enter password: ");
            res = password == null || password.length() == 0 ? false : this.conn.authenticateWithPassword(this.username, password);
            if (res) break;
            lastError = "Password authentication failed.";
            if (++passwordRetry == 3) throw new IOException("Too many tries. Give up.");
        }
        this.sess = this.conn.openSession();
        this.sess.requestPTY("javash", 0, 0, 0, 0, null);
    }

    public String getPassword(String message) throws IOException {
        return PasswordReader.readPassword(message);
    }

    @Override
    public void startProgram(String cmd) throws IOException {
        this.cmd = "/bin/bash --login -c '" + cmd + " 2>&1'";
        this.sess.execCommand(this.cmd);
    }

    @Override
    public InputStream getProgramStdOut() {
        return this.sess.getStdout();
    }

    @Override
    public InputStream getProgramStdErr() {
        return this.sess.getStderr();
    }

    @Override
    public void waitForControlMessage(String expect, boolean allowEOF, boolean grabRemainingLog) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getProgramStdOut()));
        String outputPrefix = "[" + this.conn.getHostname() + "]$ ";
        do {
            if ((line = br.readLine()) == null) {
                if (allowEOF) {
                    return;
                }
                throw new IOException("[" + this.cmd + "] exited. No control message received]");
            }
            System.err.println(outputPrefix + line);
        } while (!line.trim().equalsIgnoreCase(expect));
        LogWriter lw = grabRemainingLog ? new LogWriter(br, "fdt_" + this.conn.getHostname() + ".log") : new LogWriter(br);
        lw.setDaemon(true);
        lw.start();
    }

    @Override
    public void waitForControlMessage(String expect, boolean allowEOF) throws IOException {
        this.waitForControlMessage(expect, allowEOF, false);
    }

    @Override
    public void waitForControlMessage(String expect) throws IOException {
        this.waitForControlMessage(expect, false, true);
    }

    @Override
    public void saveStdErr() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getProgramStdErr()));
        LogWriter lw = new LogWriter(br, "fdt_" + this.conn.getHostname() + ".err");
        lw.setDaemon(true);
        lw.start();
    }

    @Override
    public int getExitCode() {
        return this.sess.getExitStatus();
    }

    @Override
    public void close() {
        if (this.sess != null) {
            this.sess.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    class InteractiveLogic
    implements InteractiveCallback {
        int promptCount = 0;
        String lastError;
        String prefix;

        public InteractiveLogic(String lastError, String prefix) {
            this.lastError = lastError;
            this.prefix = prefix;
        }

        @Override
        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws IOException {
            String[] result = new String[numPrompts];
            for (int i = 0; i < numPrompts; ++i) {
                if (this.lastError != null) {
                    this.lastError = null;
                }
                StringBuilder sContent = new StringBuilder();
                if (name != null && name.trim().length() > 0) {
                    sContent.append(name).append(' ');
                }
                if (instruction != null && instruction.trim().length() > 0) {
                    sContent.append(instruction).append('\n');
                }
                sContent.append(this.prefix).append("[Keyboard Interactive Authentication] ").append(prompt[i]);
                String userResponse = SSHControlStream.this.getPassword(sContent.toString());
                if (userResponse == null) {
                    throw new IOException("Login aborted by user");
                }
                result[i] = userResponse;
                ++this.promptCount;
            }
            return result;
        }

        public int getPromptCount() {
            return this.promptCount;
        }
    }

    static class LogWriter
    extends Thread {
        BufferedReader br;
        String logFile;

        public LogWriter(BufferedReader br) {
            this.br = br;
            this.logFile = null;
        }

        public LogWriter(BufferedReader br, String fileName) {
            this.br = br;
            this.logFile = fileName;
        }

        @Override
        public void run() {
            BufferedWriter out = null;
            try {
                if (this.logFile != null) {
                    out = new BufferedWriter(new FileWriter(this.logFile, false));
                    Date date = new Date();
                    out.write("==============" + new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z").format(date) + "================\n");
                }
                while (true) {
                    String line;
                    if ((line = this.br.readLine()) == null) {
                        if (out != null) {
                            out.close();
                        }
                        return;
                    }
                    if (out == null) continue;
                    out.write(line + "\n");
                    out.flush();
                }
            }
            catch (IOException e) {
                System.err.println("Cannot write remote log:" + this.logFile);
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
    }
}

