/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.FileChannelProvider;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.FileSession;

public class FileWriterSession
extends FileSession {
    private static final Logger logger = Logger.getLogger(FileSession.class.getName());
    protected final boolean noLock;
    protected final boolean noTmp;
    protected volatile FileLock fLock = null;
    private volatile boolean channelInitialized;
    private volatile File tmpCopyFile;
    private String openMode = "rw";

    public FileWriterSession(UUID uid, FDTSession fdtSession, String fileName, long size, long lastModified, boolean isLoop, String writeMode, boolean noTmp, boolean noLock, FileChannelProvider fcp) throws IOException {
        super(uid, fdtSession, fileName, isLoop, fcp);
        this.noTmp = noTmp;
        this.noLock = noLock;
        this.file = fcp.getFile(this.file.getAbsolutePath());
        this.sessionSize = size;
        if (!this.isNull) {
            this.lastModified = lastModified;
            String tmpF = "";
            File parent = this.file.getParentFile();
            if (parent != null) {
                tmpF = parent.getAbsolutePath();
            }
            String fName = tmpF + File.separator + "." + Math.random() + this.file.getName();
            this.tmpCopyFile = fcp.getFile(noTmp ? this.file.getAbsolutePath() : fName);
        } else {
            this.tmpCopyFile = this.file;
        }
        try {
            this.partitionID = this.fileChannelProvider.getPartitionID(this.tmpCopyFile);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, " [ FileWriterSession ] cannot determine partition id for: " + this.tmpCopyFile, t);
        }
        this.channelInitialized = false;
        this.openMode = writeMode == null || writeMode.equalsIgnoreCase("nosync") ? "rw" : (writeMode.equalsIgnoreCase("dsync") ? "rwd" : (writeMode.equalsIgnoreCase("sync") ? "rws" : "rw"));
    }

    public static FileWriterSession fromFileWriterSession(FileWriterSession other) throws IOException {
        return new FileWriterSession(other.sessionID, other.fdtSession, other.fileName, other.sessionSize(), other.lastModified, other.isLoop, other.openMode, other.noTmp, other.noLock, other.fileChannelProvider);
    }

    public String toString() {
        return "FileWriterSession [tmpCopyFile=" + this.tmpCopyFile + ", file=" + this.file + ", partitionID=" + this.partitionID + ", sessionID=" + this.sessionID + ", sessionSize=" + this.sessionSize + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel getChannel() throws Exception {
        if (this.channelInitialized) {
            if (this.isClosed()) {
                if (!this.isLoop) {
                    throw new Exception("Stream closed!");
                }
            } else {
                return this.fileChannel;
            }
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.channelInitialized) {
                if (this.isClosed()) {
                    throw new Exception("Stream closed!");
                }
                return this.fileChannel;
            }
            if (this.isClosed()) {
                throw new Exception("Stream closed!");
            }
            try {
                FileChannel lfc;
                block21: {
                    File dirs;
                    if (!(this.isNull || this.file.exists() || (dirs = this.fileChannelProvider.getFile(this.file.getParent())).exists() || dirs.mkdirs())) {
                        throw new IOException(" Unable to create parent dirs [ " + dirs + " ]");
                    }
                    try {
                        this.partitionID = this.fileChannelProvider.getPartitionID(this.tmpCopyFile);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, " [ FileWriterSession ] cannot determine partition id for: " + this.tmpCopyFile, t);
                    }
                    lfc = this.fileChannelProvider.getFileChannel(this.tmpCopyFile, this.openMode);
                    if (!this.noLock && !this.isNull) {
                        try {
                            this.fLock = lfc.lock();
                            if (!logger.isLoggable(Level.FINE)) break block21;
                            if (this.fLock == null) {
                                logger.log(Level.FINE, "[ FileWriterSession ] Cannot lock file: " + this.tmpCopyFile + "; will try to write without lock taken. No reason given.");
                                break block21;
                            }
                            logger.log(Level.FINE, "[ FileWriterSession ] File lock for: " + this.tmpCopyFile + " taken!");
                        }
                        catch (Throwable t) {
                            this.fLock = null;
                            logger.log(Level.WARNING, "[ FileWriterSession ] Cannot lock file: " + this.tmpCopyFile + "; will try to write without lock taken. Cause:", t);
                        }
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "[ FileWriterSession ] Not using file lock for: " + this.tmpCopyFile);
                    }
                }
                this.fileChannel = lfc;
                this.channelInitialized = true;
            }
            catch (Exception ex) {
                this.close(null, ex);
                throw ex;
            }
        }
        return this.fileChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalClose() {
        boolean bRename;
        block40: {
            block39: {
                FileLock fLock;
                super.internalClose();
                boolean logFine = logger.isLoggable(Level.FINE);
                bRename = this.channelInitialized && !this.isNull && this.downCause() == null && this.file != null && this.tmpCopyFile != null;
                try {
                    if (bRename) {
                        if (!this.tmpCopyFile.equals(this.file)) {
                            if (this.file.exists()) {
                                if (!this.file.delete()) {
                                    logger.log(Level.WARNING, "Unable to delete existing file: " + this.file + ". Will try to replace it with: " + this.tmpCopyFile);
                                } else if (logFine) {
                                    logger.log(Level.FINE, "Deleted existing file: " + this.file + ". Will replace it with: " + this.tmpCopyFile);
                                }
                            } else if (logFine) {
                                logger.log(Level.FINE, "No existing file: " + this.file + ". Will move temp file: " + this.tmpCopyFile + " to " + this.file);
                            }
                            bRename = this.tmpCopyFile.renameTo(this.file);
                        } else {
                            bRename = true;
                        }
                        if (!this.file.setLastModified(this.lastModified)) {
                            logger.log(Level.WARNING, "Unable to set modification time for file: " + this.file);
                        }
                    } else {
                        bRename = true;
                        if ((this.downCause() != null || this.downMessage() != null && this.tmpCopyFile != null) && !this.isNull && !this.tmpCopyFile.delete() && this.tmpCopyFile.exists()) {
                            logger.log(Level.WARNING, "Unable to delete temporary file: " + this.tmpCopyFile);
                        }
                    }
                    if (this.isLoop) {
                        this.channelInitialized = false;
                        this.closed = false;
                    }
                    if ((fLock = this.fLock) == null) break block39;
                }
                catch (Throwable throwable) {
                    FileLock fLock2 = this.fLock;
                    if (fLock2 != null) {
                        try {
                            if (fLock2.isValid()) {
                                fLock2.release();
                                if (logFine) {
                                    logger.log(Level.FINE, "[ FileWriterSession ] Released the lock for file: " + this.file);
                                }
                            } else if (logFine) {
                                logger.log(Level.FINE, "[ FileWriterSession ] The lock for file: " + this.file + " no longer valid. File chanel open: " + this.fileChannel.isOpen());
                            }
                        }
                        catch (Throwable t) {
                            logger.log(Level.WARNING, "[ FileWriterSession ] Unable to release the lock for file: " + this.file + " file channel opened: " + this.fileChannel.isOpen() + "; Cause: ", t);
                        }
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "[ FileWriterSession ] No lock for file: " + this.file);
                    }
                    if (!bRename) {
                        String msg = "Unable to rename temporary file: [ " + this.tmpCopyFile + " ] to destination file: [ " + this.file + " ]. Check your file system.";
                        logger.log(Level.WARNING, msg);
                        if (!this.isNull & this.tmpCopyFile != null) {
                            if (this.tmpCopyFile.delete()) {
                                logger.log(Level.INFO, "Temporary file: " + this.tmpCopyFile + " deleted");
                            } else {
                                logger.log(Level.WARNING, "Unable to delete temporary file: " + this.tmpCopyFile + " deleted. Check your file system.");
                            }
                        }
                        this.fdtSession.close(msg, new IOException(msg));
                    }
                    throw throwable;
                }
                try {
                    if (fLock.isValid()) {
                        fLock.release();
                        if (logFine) {
                            logger.log(Level.FINE, "[ FileWriterSession ] Released the lock for file: " + this.file);
                        }
                    } else if (logFine) {
                        logger.log(Level.FINE, "[ FileWriterSession ] The lock for file: " + this.file + " no longer valid. File chanel open: " + this.fileChannel.isOpen());
                    }
                    break block40;
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "[ FileWriterSession ] Unable to release the lock for file: " + this.file + " file channel opened: " + this.fileChannel.isOpen() + "; Cause: ", t);
                }
                break block40;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[ FileWriterSession ] No lock for file: " + this.file);
            }
        }
        if (!bRename) {
            String msg = "Unable to rename temporary file: [ " + this.tmpCopyFile + " ] to destination file: [ " + this.file + " ]. Check your file system.";
            logger.log(Level.WARNING, msg);
            if (!this.isNull & this.tmpCopyFile != null) {
                if (this.tmpCopyFile.delete()) {
                    logger.log(Level.INFO, "Temporary file: " + this.tmpCopyFile + " deleted");
                } else {
                    logger.log(Level.WARNING, "Unable to delete temporary file: " + this.tmpCopyFile + " deleted. Check your file system.");
                }
            }
            this.fdtSession.close(msg, new IOException(msg));
        }
    }

    @Override
    public void setFileName(String fileName) throws IOException {
        super.setFileName(fileName);
        if (!this.isNull) {
            this.lastModified = this.lastModified;
            String tmpF = "";
            File parent = this.file.getParentFile();
            if (parent != null) {
                tmpF = parent.getAbsolutePath();
            }
            String fName = tmpF + File.separator + "." + Math.random() + this.file.getName();
            this.tmpCopyFile = this.fileChannelProvider.getFile(this.noTmp ? this.file.getAbsolutePath() : fName);
        } else {
            this.tmpCopyFile = this.file;
        }
    }
}

